/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import java.util.List;
import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.ByFilter;
import org.dmfs.rfc5545.recur.Freq;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByDayFilter
implements ByFilter {
    private final ByExpander.Scope mScope;
    private final boolean mHasPositions;
    private final int[] mPackedDays;
    final CalendarMetrics mCalendarMetrics;

    private static int packWeekday(int pos, int day) {
        return (pos << 8) + day;
    }

    private static int unpackWeekday(int packedDay) {
        return packedDay & 0xFF;
    }

    private static int unpackPos(int packedDay) {
        return packedDay >>> 8;
    }

    public ByDayFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) {
        this.mCalendarMetrics = calendarMetrics;
        List<RecurrenceRule.WeekdayNum> byDay = rule.getByDayPart();
        boolean hasByMonth = rule.hasPart(RecurrenceRule.Part.BYMONTH);
        Freq freq = rule.getFreq();
        this.mScope = rule.hasPart(RecurrenceRule.Part.BYWEEKNO) || freq == Freq.WEEKLY ? (hasByMonth || freq == Freq.MONTHLY ? ByExpander.Scope.WEEKLY_AND_MONTHLY : ByExpander.Scope.WEEKLY) : (hasByMonth || freq == Freq.MONTHLY ? ByExpander.Scope.MONTHLY : ByExpander.Scope.YEARLY);
        boolean hasPositions = false;
        this.mPackedDays = new int[byDay.size()];
        int count = 0;
        for (RecurrenceRule.WeekdayNum w : byDay) {
            if (w.pos != 0) {
                hasPositions = true;
            }
            this.mPackedDays[count] = ByDayFilter.packWeekday(w.pos, w.weekday.ordinal());
            ++count;
        }
        this.mHasPositions = hasPositions;
    }

    @Override
    public boolean filter(long instance) {
        int year = Instance.year((long)instance);
        int month = Instance.month((long)instance);
        int dayOfMonth = Instance.dayOfMonth((long)instance);
        CalendarMetrics calendarMetrics = this.mCalendarMetrics;
        int dayOfWeek = calendarMetrics.getDayOfWeek(year, month, dayOfMonth);
        int[] packedDays = this.mPackedDays;
        if (!this.mHasPositions) {
            return StaticUtils.linearSearch(packedDays, ByDayFilter.packWeekday(0, dayOfWeek)) < 0;
        }
        switch (this.mScope) {
            case WEEKLY: {
                return StaticUtils.linearSearch(packedDays, ByDayFilter.packWeekday(0, dayOfWeek)) < 0;
            }
            case WEEKLY_AND_MONTHLY: 
            case MONTHLY: {
                int nthDay = (dayOfMonth - 1) / 7 + 1;
                int lastNthDay = (dayOfMonth - calendarMetrics.getDaysPerPackedMonth(year, month)) / 7 - 1;
                return !(nthDay > 0 && StaticUtils.linearSearch(packedDays, ByDayFilter.packWeekday(nthDay, dayOfWeek)) >= 0 || lastNthDay < 0 && StaticUtils.linearSearch(packedDays, ByDayFilter.packWeekday(lastNthDay, dayOfWeek)) >= 0 || StaticUtils.linearSearch(packedDays, ByDayFilter.packWeekday(0, dayOfWeek)) >= 0);
            }
            case YEARLY: {
                int yearDay = calendarMetrics.getDayOfYear(year, month, dayOfMonth);
                int nthDay = (yearDay - 1) / 7 + 1;
                int lastNthDay = (yearDay - calendarMetrics.getDaysPerYear(year)) / 7 - 1;
                return !(nthDay > 0 && StaticUtils.linearSearch(packedDays, ByDayFilter.packWeekday(nthDay, dayOfWeek)) >= 0 || lastNthDay < 0 && StaticUtils.linearSearch(packedDays, ByDayFilter.packWeekday(lastNthDay, dayOfWeek)) >= 0 || StaticUtils.linearSearch(packedDays, ByDayFilter.packWeekday(0, dayOfWeek)) >= 0);
            }
        }
        return false;
    }
}

