/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import java.util.List;
import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;

final class ByDayMonthlyExpander
extends ByExpander {
    private final int[] mByDay;

    private static int packWeekday(int pos, int day) {
        return (pos << 8) + day;
    }

    private static int unpackWeekday(int packedDay) {
        return packedDay & 0xFF;
    }

    private static int unpackPos(int packedDay) {
        return packedDay >> 8;
    }

    public ByDayMonthlyExpander(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarTools, long start) {
        super(previous, calendarTools, start);
        List<RecurrenceRule.WeekdayNum> byDay = rule.getByDayPart();
        this.mByDay = new int[byDay.size()];
        int l = byDay.size();
        for (int i = 0; i < l; ++i) {
            RecurrenceRule.WeekdayNum weekdayNum = byDay.get(i);
            this.mByDay[i] = ByDayMonthlyExpander.packWeekday(weekdayNum.pos, weekdayNum.weekday.ordinal());
        }
    }

    @Override
    void expand(long instance, long start) {
        CalendarMetrics calendarMetrics = this.mCalendarMetrics;
        int year = Instance.year((long)instance);
        int month = Instance.month((long)instance);
        for (int packedDay : this.mByDay) {
            int pos = ByDayMonthlyExpander.unpackPos(packedDay);
            int day = ByDayMonthlyExpander.unpackWeekday(packedDay);
            int weekDayOfFirstInMonth = calendarMetrics.getDayOfWeek(year, month, 1);
            int monthDays = calendarMetrics.getDaysPerPackedMonth(year, month);
            int firstDay = (day - weekDayOfFirstInMonth + 7) % 7 + 1;
            if (pos == 0) {
                for (int dayOfMonth = firstDay; dayOfMonth <= monthDays; dayOfMonth += 7) {
                    this.addInstance(Instance.setDayOfMonth((long)instance, (int)dayOfMonth));
                }
                continue;
            }
            int maxPos = 1 + (monthDays - firstDay) / 7;
            if ((pos <= 0 || pos > maxPos) && (pos >= 0 || pos + maxPos + 1 <= 0)) continue;
            this.addInstance(Instance.setDayOfMonth((long)instance, (int)(firstDay + (pos > 0 ? pos - 1 : pos + maxPos) * 7)));
        }
    }
}

