/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByFilter;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.StaticUtils;

final class ByMonthDayFilter
implements ByFilter {
    private final int[] mMonthDays;
    private final CalendarMetrics mCalendarMetrics;

    public ByMonthDayFilter(RecurrenceRule rule, CalendarMetrics calendarMetrics) {
        this.mCalendarMetrics = calendarMetrics;
        this.mMonthDays = StaticUtils.ListToArray(rule.getByPart(RecurrenceRule.Part.BYMONTHDAY));
    }

    @Override
    public boolean filter(long instance) {
        int monthDays = this.mCalendarMetrics.getDaysPerPackedMonth(Instance.year((long)instance), Instance.month((long)instance));
        int dayOfMonth = Instance.dayOfMonth((long)instance);
        return StaticUtils.linearSearch(this.mMonthDays, dayOfMonth) < 0 && StaticUtils.linearSearch(this.mMonthDays, dayOfMonth - 1 - monthDays) < 0 || dayOfMonth > monthDays;
    }
}

