/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import java.util.List;
import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.ByExpander;
import org.dmfs.rfc5545.recur.Freq;
import org.dmfs.rfc5545.recur.LongArray;
import org.dmfs.rfc5545.recur.RecurrenceRule;

public final class FastWeeklyIterator
extends ByExpander {
    private final int mInterval;
    private final LongArray mResultSet = new LongArray(1);
    private long mNextInstance;
    private int mYear;
    private int mYearDay;
    private final int mInstanceLimit;
    private int mCount;

    private FastWeeklyIterator(RecurrenceRule rule, CalendarMetrics calendarMetrics, long firstInstance) {
        super(null, calendarMetrics, firstInstance);
        this.mInterval = rule.getInterval();
        this.mNextInstance = firstInstance;
        this.mYear = Instance.year((long)firstInstance);
        this.mYearDay = calendarMetrics.getDayOfYear(this.mYear, Instance.month((long)firstInstance), Instance.dayOfMonth((long)firstInstance));
        Integer max = rule.getCount();
        this.mInstanceLimit = max == null ? -1 : max;
    }

    public static FastWeeklyIterator getInstance(RecurrenceRule rule, CalendarMetrics calendarMetrics, long start) {
        Freq freq = rule.getFreq();
        if (freq != Freq.WEEKLY || rule.hasPart(RecurrenceRule.Part.BYMONTH) || rule.hasPart(RecurrenceRule.Part.BYYEARDAY) || rule.hasPart(RecurrenceRule.Part.BYMONTHDAY) || rule.hasPart(RecurrenceRule.Part.BYWEEKNO) || rule.hasPart(RecurrenceRule.Part.BYHOUR) || rule.hasPart(RecurrenceRule.Part.BYMINUTE) || rule.hasPart(RecurrenceRule.Part.BYSECOND) || rule.hasPart(RecurrenceRule.Part.BYSETPOS) || rule.getSkip() != RecurrenceRule.Skip.OMIT) {
            return null;
        }
        List<RecurrenceRule.WeekdayNum> weekdays = rule.getByDayPart();
        if (weekdays == null || weekdays.size() == 1) {
            long instance = start;
            if (weekdays != null) {
                int yearDay;
                int weekday = weekdays.get((int)0).weekday.ordinal();
                int year = Instance.year((long)instance);
                int currentWeekDay = calendarMetrics.getDayOfWeek(year, yearDay = calendarMetrics.getDayOfYear(year, Instance.month((long)instance), Instance.dayOfMonth((long)instance)));
                if (currentWeekDay != weekday) {
                    int daysPerYear = calendarMetrics.getDaysPerYear(Instance.year((long)instance));
                    if ((yearDay += (weekday - currentWeekDay + 7) % 7) > daysPerYear) {
                        ++year;
                        yearDay -= daysPerYear;
                    }
                    int monthAndDay = calendarMetrics.getMonthAndDayOfYearDay(year, yearDay);
                    instance = Instance.setMonthAndDayOfMonth((long)Instance.setYear((long)instance, (int)year), (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay));
                }
            }
            return new FastWeeklyIterator(rule, calendarMetrics, instance);
        }
        return null;
    }

    @Override
    public long next() {
        if (this.mInstanceLimit > 0 && ++this.mCount > this.mInstanceLimit) {
            this.mNextInstance = Long.MIN_VALUE;
            return Long.MIN_VALUE;
        }
        long result = this.mNextInstance;
        int daysPerYear = this.mCalendarMetrics.getDaysPerYear(this.mYear);
        this.mYearDay += 7 * this.mInterval;
        while (this.mYearDay > daysPerYear) {
            ++this.mYear;
            this.mYearDay -= daysPerYear;
            daysPerYear = this.mCalendarMetrics.getDaysPerYear(this.mYear);
        }
        int monthAndDay = this.mCalendarMetrics.getMonthAndDayOfYearDay(this.mYear, this.mYearDay);
        this.mNextInstance = Instance.setMonthAndDayOfMonth((long)Instance.setYear((long)this.mNextInstance, (int)this.mYear), (int)CalendarMetrics.packedMonth((int)monthAndDay), (int)CalendarMetrics.dayOfMonth((int)monthAndDay));
        return result;
    }

    @Override
    LongArray nextSet() {
        this.mResultSet.clear();
        this.mResultSet.add(this.next());
        return this.mResultSet;
    }

    @Override
    void expand(long instance, long start) {
    }

    @Override
    void fastForward(long untilInstance) {
        int untilYear = Instance.year((long)untilInstance);
        int untilMonth = Instance.month((long)untilInstance);
        int monthsOfPrevYear = this.mCalendarMetrics.getMonthsPerYear(untilYear - 1);
        int nextMonth = Instance.month((long)this.mNextInstance);
        while ((this.mYear < untilYear - 1 || this.mYear == untilYear - 1 && untilMonth == 0 && nextMonth < monthsOfPrevYear - 1 || this.mYear == untilYear && nextMonth < untilMonth) && this.mNextInstance > Long.MIN_VALUE) {
            this.next();
            nextMonth = Instance.month((long)this.mNextInstance);
        }
    }
}

