/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recurrenceset;

import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.dmfs.rfc5545.recurrenceset.AbstractRecurrenceAdapter;
import org.dmfs.rfc5545.recurrenceset.RecurrenceList;
import org.dmfs.rfc5545.recurrenceset.RecurrenceSetIterator;

public class RecurrenceSet {
    private final List<AbstractRecurrenceAdapter> mInstances = new ArrayList<AbstractRecurrenceAdapter>();
    private List<AbstractRecurrenceAdapter> mExceptions = null;
    private boolean mIsInfinite = false;

    public void addInstances(AbstractRecurrenceAdapter adapter) {
        this.mInstances.add(adapter);
        this.mIsInfinite |= adapter.isInfinite();
    }

    public void addExceptions(AbstractRecurrenceAdapter adapter) {
        if (this.mExceptions == null) {
            this.mExceptions = new ArrayList<AbstractRecurrenceAdapter>();
        }
        this.mExceptions.add(adapter);
    }

    public RecurrenceSetIterator iterator(TimeZone timezone, long start) {
        return this.iterator(timezone, start, Long.MAX_VALUE);
    }

    public RecurrenceSetIterator iterator(TimeZone timezone, long start, long end) {
        ArrayList<AbstractRecurrenceAdapter.InstanceIterator> instances = new ArrayList<AbstractRecurrenceAdapter.InstanceIterator>(this.mInstances.size());
        instances.add(new RecurrenceList(new long[]{start}).getIterator(timezone, start));
        for (AbstractRecurrenceAdapter adapter : this.mInstances) {
            instances.add(adapter.getIterator(timezone, start));
        }
        ArrayList<AbstractRecurrenceAdapter.InstanceIterator> exceptions = null;
        if (this.mExceptions != null) {
            exceptions = new ArrayList<AbstractRecurrenceAdapter.InstanceIterator>(this.mExceptions.size());
            for (AbstractRecurrenceAdapter adapter : this.mExceptions) {
                exceptions.add(adapter.getIterator(timezone, start));
            }
        }
        return new RecurrenceSetIterator(instances, exceptions).setEnd(end);
    }

    public boolean isInfinite() {
        return this.mIsInfinite;
    }

    public long getLastInstance(TimeZone timezone, long start) {
        if (this.isInfinite()) {
            throw new IllegalStateException("can not calculate the last instance of an infinite recurrence set");
        }
        if (this.mExceptions != null && this.mExceptions.size() > 0) {
            long last = Long.MIN_VALUE;
            RecurrenceSetIterator iterator = this.iterator(timezone, start);
            while (iterator.hasNext()) {
                last = iterator.next();
            }
            return last;
        }
        if (this.mInstances.size() == 1) {
            return this.mInstances.get(0).getLastInstance(timezone, start);
        }
        long last = Long.MIN_VALUE;
        for (AbstractRecurrenceAdapter adapter : this.mInstances) {
            long lastOfAdapter = adapter.getLastInstance(timezone, start);
            if (lastOfAdapter <= last) continue;
            last = lastOfAdapter;
        }
        return last;
    }
}

