/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recurrenceset;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.dmfs.rfc5545.recur.StaticUtils;
import org.dmfs.rfc5545.recurrenceset.AbstractRecurrenceAdapter;

public class RecurrenceSetIterator {
    private static final int INSTANCE_CACHE_SIZE = 32;
    private static final int EXCEPTION_CACHE_SIZE = 16;
    private static final int MAX_SKIPPED_INSTANCES = 1000;
    private AbstractRecurrenceAdapter.InstanceIterator[] mInstances;
    private AbstractRecurrenceAdapter.InstanceIterator[] mExceptions;
    private long[] mInstanceCache;
    private int mInstancesInCache;
    private int mNextInstance = 0;
    private long[] mExceptionCache;
    private int mExceptionsInCache;
    private int mLastExceptionIndex = -1;
    private long mIterateEnd = Long.MAX_VALUE;
    private Comparator<AbstractRecurrenceAdapter.InstanceIterator> mAdapterComparator = new Comparator<AbstractRecurrenceAdapter.InstanceIterator>(){

        @Override
        public int compare(AbstractRecurrenceAdapter.InstanceIterator o1, AbstractRecurrenceAdapter.InstanceIterator o2) {
            boolean hasNext1 = o1.hasNext();
            boolean hasNext2 = o2.hasNext();
            if (hasNext1 && hasNext2) {
                long diff = o1.peek() - o2.peek();
                return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
            }
            if (!hasNext1 && !hasNext2) {
                return 0;
            }
            return hasNext1 ? 1 : -1;
        }
    };
    public static final AbstractRecurrenceAdapter.InstanceIterator[] EMPTY_INSTANCE_ITERATOR_ARRAY = new AbstractRecurrenceAdapter.InstanceIterator[0];

    RecurrenceSetIterator(List<AbstractRecurrenceAdapter.InstanceIterator> instances, List<AbstractRecurrenceAdapter.InstanceIterator> exceptions) {
        this.mInstances = instances.toArray(EMPTY_INSTANCE_ITERATOR_ARRAY);
        Arrays.sort(this.mInstances, this.mAdapterComparator);
        if (exceptions != null && exceptions.size() > 0) {
            this.mExceptions = exceptions.toArray(EMPTY_INSTANCE_ITERATOR_ARRAY);
            Arrays.sort(this.mExceptions, this.mAdapterComparator);
        } else {
            this.mExceptions = EMPTY_INSTANCE_ITERATOR_ARRAY;
        }
    }

    RecurrenceSetIterator setEnd(long end) {
        this.mIterateEnd = end;
        return this;
    }

    public boolean hasNext() {
        if (this.mInstanceCache == null || this.mNextInstance == 32) {
            this.fillInstanceCache();
        }
        return this.mNextInstance < this.mInstancesInCache;
    }

    public long next() {
        if (this.mInstanceCache == null || this.mNextInstance == 32) {
            this.fillInstanceCache();
        }
        if (this.mNextInstance >= this.mInstancesInCache) {
            throw new ArrayIndexOutOfBoundsException("no more instances to iterate");
        }
        return this.mInstanceCache[this.mNextInstance++];
    }

    public void fastForward(long until) {
        if (this.mInstanceCache != null) {
            int next;
            long[] instanceCache = this.mInstanceCache;
            int instanceCount = this.mInstancesInCache;
            for (next = this.mNextInstance; next < instanceCount && instanceCache[next] < until; ++next) {
            }
            if (next < instanceCount) {
                this.mNextInstance = next;
                return;
            }
        }
        for (AbstractRecurrenceAdapter.InstanceIterator instances : this.mInstances) {
            instances.fastForward(until);
        }
        if (this.mExceptions.length > 0) {
            for (AbstractRecurrenceAdapter.InstanceIterator exceptions : this.mExceptions) {
                exceptions.fastForward(until);
            }
        }
    }

    private void fillInstanceCache() {
        long[] instanceCache = this.mInstanceCache;
        if (instanceCache == null) {
            this.mInstanceCache = instanceCache = new long[32];
        }
        long iterateEnd = this.mIterateEnd;
        AbstractRecurrenceAdapter.InstanceIterator[] instances = this.mInstances;
        int count = 0;
        int skipped = 0;
        long last = Long.MIN_VALUE;
        if (instances != null && instances.length == 1) {
            AbstractRecurrenceAdapter.InstanceIterator ra = instances[0];
            while (ra.hasNext() && count < 32) {
                try {
                    long next = ra.next();
                    if (next > iterateEnd) break;
                    if (last != next && !this.isException(next)) {
                        instanceCache[count] = next;
                        ++count;
                        skipped = 0;
                        last = next;
                        continue;
                    }
                    if (last == next) continue;
                    last = next;
                    if (++skipped < 1000) continue;
                    break;
                }
                catch (IllegalArgumentException e) {
                    this.mInstances = null;
                    instances = null;
                }
            }
        } else if (instances != null) {
            while (instances.length > 0 && count < 32) {
                AbstractRecurrenceAdapter.InstanceIterator ra = instances[0];
                try {
                    if (ra.hasNext()) {
                        long next = ra.next();
                        if (next > iterateEnd) break;
                        if (!this.isException(next) && last != next) {
                            instanceCache[count] = next;
                            ++count;
                            skipped = 0;
                            last = next;
                        } else if (last != next) {
                            last = next;
                            if (++skipped >= 1000) break;
                        }
                        Arrays.sort(instances, this.mAdapterComparator);
                        continue;
                    }
                    AbstractRecurrenceAdapter.InstanceIterator[] tempInstances = new AbstractRecurrenceAdapter.InstanceIterator[instances.length - 1];
                    System.arraycopy(instances, 1, tempInstances, 0, tempInstances.length);
                    this.mInstances = tempInstances;
                    instances = tempInstances;
                }
                catch (IllegalArgumentException e) {
                    AbstractRecurrenceAdapter.InstanceIterator[] tempInstances = new AbstractRecurrenceAdapter.InstanceIterator[instances.length - 1];
                    System.arraycopy(instances, 1, tempInstances, 0, tempInstances.length);
                    this.mInstances = tempInstances;
                    instances = tempInstances;
                }
            }
        }
        this.mInstancesInCache = count;
        this.mNextInstance = 0;
    }

    private boolean isException(long instance) {
        if (this.mExceptions.length == 0) {
            return false;
        }
        if (this.mExceptionCache == null) {
            this.fillExceptionCache();
        }
        while (this.mExceptionsInCache > 0) {
            if (instance < this.mExceptionCache[0]) {
                return false;
            }
            if (instance <= this.mExceptionCache[this.mExceptionsInCache - 1]) {
                int pos = StaticUtils.linearSearch(this.mExceptionCache, this.mLastExceptionIndex + 1, this.mExceptionsInCache, instance);
                if (pos >= 0) {
                    this.mLastExceptionIndex = pos;
                    return true;
                }
                return false;
            }
            this.fillExceptionCache();
        }
        return false;
    }

    private void fillExceptionCache() {
        int count;
        this.mLastExceptionIndex = -1;
        long[] exceptionCache = this.mExceptionCache;
        if (exceptionCache == null || exceptionCache.length == 0) {
            exceptionCache = this.mExceptionCache = new long[16];
        }
        long iterateEnd = this.mIterateEnd;
        AbstractRecurrenceAdapter.InstanceIterator[] exceptions = this.mExceptions;
        if (exceptions.length == 0) {
            return;
        }
        if (exceptions.length == 1) {
            long next;
            AbstractRecurrenceAdapter.InstanceIterator ra = exceptions[0];
            if (!ra.hasNext()) {
                this.mExceptionsInCache = count;
                return;
            }
            for (count = 0; ra.hasNext() && count < 16 && (next = (exceptionCache[count] = ra.next())) <= iterateEnd; ++count) {
            }
        } else {
            while (exceptions.length > 0 && count < 16) {
                AbstractRecurrenceAdapter.InstanceIterator exceptionIterator = exceptions[0];
                if (exceptionIterator.hasNext()) {
                    exceptionCache[count++] = exceptionIterator.next();
                    long next = exceptionCache[count++];
                    if (next <= iterateEnd) {
                        Arrays.sort(exceptions, this.mAdapterComparator);
                        continue;
                    }
                    break;
                }
                AbstractRecurrenceAdapter.InstanceIterator[] tempExceptions = new AbstractRecurrenceAdapter.InstanceIterator[exceptions.length - 1];
                System.arraycopy(exceptions, 1, tempExceptions, 0, tempExceptions.length);
                this.mExceptions = tempExceptions;
                exceptions = tempExceptions;
            }
        }
        this.mExceptionsInCache = count;
    }
}

