/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545;

import java.io.IOException;
import java.io.Writer;
import java.util.TimeZone;
import org.dmfs.rfc5545.Duration;
import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.UnicodeCalendarScales;
import org.dmfs.rfc5545.Weekday;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.calendarmetrics.GregorianCalendarMetrics;

public final class DateTime {
    public static final CalendarMetrics GREGORIAN_CALENDAR_SCALE = new GregorianCalendarMetrics(Weekday.MO, 4);
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final CalendarMetrics mCalendarMetrics;
    private final TimeZone mTimezone;
    private final boolean mAllday;
    private long mTimestamp = Long.MAX_VALUE;
    private long mInstance = Long.MAX_VALUE;
    private int mWeekOfYear = -1;
    private int mDayOfWeek = -1;

    public DateTime(CalendarMetrics calendarMetrics, DateTime dateTime) {
        this.mCalendarMetrics = calendarMetrics;
        this.mTimestamp = dateTime.getTimestamp();
        this.mTimezone = dateTime.mTimezone;
        this.mAllday = dateTime.mAllday;
    }

    public DateTime(CalendarMetrics calendarMetrics, TimeZone timezone, DateTime dateTime) {
        this.mCalendarMetrics = calendarMetrics;
        this.mTimestamp = dateTime.getTimestamp();
        if (dateTime.mAllday) {
            this.mTimezone = null;
            if (calendarMetrics.scaleEquals(dateTime.mCalendarMetrics)) {
                this.mInstance = dateTime.mInstance;
            }
        } else {
            this.mTimezone = timezone;
        }
        this.mAllday = dateTime.mAllday;
    }

    public DateTime(long timestamp) {
        this(GREGORIAN_CALENDAR_SCALE, UTC, timestamp);
    }

    public DateTime(TimeZone timezone, long timestamp) {
        this(GREGORIAN_CALENDAR_SCALE, timezone, timestamp);
    }

    public DateTime(CalendarMetrics calendarMetrics, TimeZone timezone, long timestamp) {
        this.mCalendarMetrics = calendarMetrics;
        this.mTimestamp = timestamp;
        this.mTimezone = timezone;
        this.mAllday = false;
    }

    public DateTime(int year, int month, int dayOfMonth) {
        this.mCalendarMetrics = GREGORIAN_CALENDAR_SCALE;
        this.mInstance = Instance.make(year, month, dayOfMonth, 0, 0, 0);
        this.mTimezone = null;
        this.mAllday = true;
    }

    public DateTime(int year, int month, int dayOfMonth, int hours, int minutes, int seconds) {
        this((TimeZone)null, year, month, dayOfMonth, hours, minutes, seconds);
    }

    public DateTime(TimeZone timezone, int year, int month, int dayOfMonth, int hours, int minutes, int seconds) {
        this.mCalendarMetrics = GREGORIAN_CALENDAR_SCALE;
        this.mInstance = Instance.make(year, month, dayOfMonth, hours, minutes, seconds);
        this.mTimezone = timezone;
        this.mAllday = false;
    }

    public DateTime(String calScale, int year, int month, int dayOfMonth) {
        this.mCalendarMetrics = UnicodeCalendarScales.getCalendarMetricsForName(calScale).getCalendarMetrics(Weekday.MO);
        this.mInstance = Instance.make(year, month, dayOfMonth, 0, 0, 0);
        this.mTimezone = null;
        this.mAllday = true;
    }

    public DateTime(String calScale, int year, int month, int dayOfMonth, int hours, int minutes, int seconds) {
        this(calScale, null, year, month, dayOfMonth, hours, minutes, seconds);
    }

    public DateTime(String calScale, TimeZone timezone, int year, int month, int dayOfMonth, int hours, int minutes, int seconds) {
        this.mCalendarMetrics = UnicodeCalendarScales.getCalendarMetricsForName(calScale).getCalendarMetrics(Weekday.MO);
        this.mInstance = Instance.make(year, month, dayOfMonth, hours, minutes, seconds);
        this.mTimezone = timezone;
        this.mAllday = false;
    }

    public DateTime(CalendarMetrics calendarMetrics, int year, int month, int dayOfMonth) {
        this.mCalendarMetrics = calendarMetrics;
        this.mInstance = Instance.make(year, month, dayOfMonth, 0, 0, 0);
        this.mTimezone = null;
        this.mAllday = true;
    }

    public DateTime(CalendarMetrics calendarMetrics, int year, int month, int dayOfMonth, int hours, int minutes, int seconds) {
        this(calendarMetrics, null, year, month, dayOfMonth, hours, minutes, seconds);
    }

    public DateTime(CalendarMetrics calendarMetrics, TimeZone timezone, int year, int month, int dayOfMonth, int hours, int minutes, int seconds) {
        this.mCalendarMetrics = calendarMetrics;
        this.mInstance = Instance.make(year, month, dayOfMonth, hours, minutes, seconds);
        this.mTimezone = timezone;
        this.mAllday = false;
    }

    private DateTime(CalendarMetrics calendarMetrics, TimeZone timezone, long instance, boolean allDay, long timeStamp) {
        this.mCalendarMetrics = calendarMetrics;
        this.mInstance = instance;
        this.mTimezone = timezone;
        this.mAllday = allDay;
        this.mTimestamp = timeStamp;
    }

    public static DateTime now() {
        return DateTime.now(UTC);
    }

    public static DateTime nowAndHere() {
        return DateTime.now(TimeZone.getDefault());
    }

    public static DateTime now(TimeZone timeZone) {
        return new DateTime(GREGORIAN_CALENDAR_SCALE, timeZone, System.currentTimeMillis());
    }

    public static DateTime today() {
        TimeZone tz = TimeZone.getDefault();
        long nowInstance = GREGORIAN_CALENDAR_SCALE.toInstance(System.currentTimeMillis(), tz);
        return new DateTime(GREGORIAN_CALENDAR_SCALE, null, Instance.setSecond(Instance.setMinute(Instance.setHour(nowInstance, 0), 0), 0), true, Long.MAX_VALUE);
    }

    public static DateTime parse(String string) {
        return DateTime.parse(GREGORIAN_CALENDAR_SCALE, null, string);
    }

    public static DateTime parse(String timeZone, String string) {
        return DateTime.parse(GREGORIAN_CALENDAR_SCALE, timeZone == null ? null : TimeZone.getTimeZone(timeZone), string);
    }

    public static DateTime parse(TimeZone timeZone, String string) {
        return DateTime.parse(GREGORIAN_CALENDAR_SCALE, timeZone, string);
    }

    public static DateTime parse(String calScale, TimeZone timeZone, String string) {
        return DateTime.parse(UnicodeCalendarScales.getCalendarMetricsForName(calScale).getCalendarMetrics(Weekday.MO), timeZone, string);
    }

    public static DateTime parse(CalendarMetrics calendarMetrics, TimeZone timeZone, String string) {
        if (string == null) {
            throw new NullPointerException("a date-time string must not be null");
        }
        try {
            if (string.length() == 8) {
                return new DateTime(calendarMetrics, DateTime.parseFourDigits(string, 0), DateTime.parseTwoDigits(string, 4) - 1, DateTime.parseTwoDigits(string, 6));
            }
            if (string.length() == 15 && string.charAt(8) == 'T') {
                return new DateTime(calendarMetrics, timeZone, DateTime.parseFourDigits(string, 0), DateTime.parseTwoDigits(string, 4) - 1, DateTime.parseTwoDigits(string, 6), DateTime.parseTwoDigits(string, 9), DateTime.parseTwoDigits(string, 11), DateTime.parseTwoDigits(string, 13));
            }
            if (string.length() == 16 && string.charAt(8) == 'T' && string.charAt(15) == 'Z') {
                return new DateTime(calendarMetrics, UTC, DateTime.parseFourDigits(string, 0), DateTime.parseTwoDigits(string, 4) - 1, DateTime.parseTwoDigits(string, 6), DateTime.parseTwoDigits(string, 9), DateTime.parseTwoDigits(string, 11), DateTime.parseTwoDigits(string, 13));
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("illegal characters in date-time string: '" + string + "'", e);
        }
        throw new IllegalArgumentException("illegal date-time string: '" + string + "'");
    }

    private static boolean sameTimestamps(TimeZone first, TimeZone second) {
        String secondId;
        String firstId;
        if (first == second) {
            return true;
        }
        String string = firstId = first != null ? first.getID() : null;
        if (second == null && ("UTC".equals(firstId) || UTC.equals(first) || UTC.hasSameRules(first))) {
            return true;
        }
        String string2 = secondId = second != null ? second.getID() : null;
        if (first == null && ("UTC".equals(secondId) || UTC.equals(second) || UTC.hasSameRules(second))) {
            return true;
        }
        return first != null && second != null && (firstId.equals(secondId) || first.equals(second) || first.hasSameRules(second));
    }

    private static int parseFourDigits(String string, int offset) {
        return DateTime.parseTwoDigits(string, offset) * 100 + DateTime.parseTwoDigits(string, offset + 2);
    }

    private static int parseTwoDigits(String string, int offset) {
        int d1 = string.charAt(offset) - 48;
        int d2 = string.charAt(offset + 1) - 48;
        if (d1 < 0 || d2 < 0 || d1 > 9 || d2 > 9) {
            throw new NumberFormatException("illegal digit in number " + string.substring(offset, 2));
        }
        return d1 * 10 + d2;
    }

    public CalendarMetrics getCalendarMetrics() {
        return this.mCalendarMetrics;
    }

    public TimeZone getTimeZone() {
        return this.mTimezone;
    }

    public long getTimestamp() {
        if (this.mTimestamp == Long.MAX_VALUE) {
            long instance = this.getInstance();
            this.mTimestamp = this.mCalendarMetrics.toMillis(this.mTimezone, Instance.year(instance), Instance.month(instance), Instance.dayOfMonth(instance), Instance.hour(instance), Instance.minute(instance), Instance.second(instance), 0);
            return this.mTimestamp;
        }
        return this.mTimestamp;
    }

    public DateTime toAllDay() {
        if (this.mAllday) {
            return this;
        }
        long instance = this.getInstance();
        return new DateTime(Instance.year(instance), Instance.month(instance), Instance.dayOfMonth(instance));
    }

    public DateTime startOfDay() {
        if (!this.mAllday && this.getHours() == 0 && this.getMinutes() == 0 && this.getSeconds() == 0) {
            return this;
        }
        return new DateTime(this.mCalendarMetrics, this.mTimezone, this.getYear(), this.getMonth(), this.getDayOfMonth(), 0, 0, 0);
    }

    public DateTime swapTimeZone(TimeZone timezone) {
        if (this.mAllday) {
            throw new IllegalStateException("can not swap the time zone of an all-day date");
        }
        TimeZone oldTimeZone = this.mTimezone;
        if (oldTimeZone == null && timezone == null || oldTimeZone != null && oldTimeZone.equals(timezone)) {
            return this;
        }
        long timestamp = this.mTimestamp;
        if (timestamp == Long.MAX_VALUE || oldTimeZone != null && oldTimeZone.hasSameRules(timezone) || DateTime.sameTimestamps(oldTimeZone, timezone)) {
            return new DateTime(this.mCalendarMetrics, timezone, this.getInstance(), false, timestamp);
        }
        return new DateTime(this.mCalendarMetrics, timezone, this.getInstance(), false, Long.MAX_VALUE);
    }

    public DateTime shiftTimeZone(TimeZone timezone) {
        if (this.mAllday) {
            throw new IllegalStateException("can not shift the time zone of an all-day date");
        }
        TimeZone oldTimeZone = this.mTimezone;
        if (oldTimeZone == null && timezone == null || oldTimeZone != null && oldTimeZone.equals(timezone)) {
            return this;
        }
        long instance = this.mInstance;
        if (instance == Long.MAX_VALUE || oldTimeZone != null && oldTimeZone.hasSameRules(timezone) || DateTime.sameTimestamps(oldTimeZone, timezone)) {
            return new DateTime(this.mCalendarMetrics, timezone, instance, false, this.getTimestamp());
        }
        return new DateTime(timezone, this.getTimestamp());
    }

    public boolean isAllDay() {
        return this.mAllday;
    }

    public boolean isFloating() {
        return this.mTimezone == null;
    }

    public int getYear() {
        return Instance.year(this.getInstance());
    }

    public int getMonth() {
        return Instance.month(this.getInstance());
    }

    public int getWeekOfYear() {
        int weekOfYear = this.mWeekOfYear;
        if (weekOfYear < 0) {
            long instance = this.getInstance();
            this.mWeekOfYear = weekOfYear = this.mCalendarMetrics.getWeekOfYear(Instance.year(instance), Instance.month(instance), Instance.dayOfMonth(instance));
        }
        return weekOfYear;
    }

    public int getDayOfWeek() {
        int dayOfweek = this.mDayOfWeek;
        if (dayOfweek < 0) {
            long instance = this.getInstance();
            this.mDayOfWeek = dayOfweek = this.mCalendarMetrics.getDayOfWeek(Instance.year(instance), Instance.month(instance), Instance.dayOfMonth(instance));
        }
        return dayOfweek;
    }

    public int getDayOfMonth() {
        return Instance.dayOfMonth(this.getInstance());
    }

    public int getHours() {
        return Instance.hour(this.getInstance());
    }

    public int getMinutes() {
        return Instance.minute(this.getInstance());
    }

    public int getSeconds() {
        return Instance.second(this.getInstance());
    }

    public DateTime addDuration(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("Duration must not be null");
        }
        if (duration.isZero()) {
            return this;
        }
        if (this.mAllday && duration.getSecondsOfDay() > 0) {
            throw new IllegalArgumentException("Can't add a duration with time to an all-day DateTime.");
        }
        long newInstance = this.mInstance;
        if (!(newInstance != Long.MAX_VALUE || this.mTimezone != null && this.mTimezone.useDaylightTime())) {
            return new DateTime(this.mCalendarMetrics, this.mTimezone, Long.MAX_VALUE, this.mAllday, this.mTimestamp + duration.toMillis());
        }
        if (duration.getRawDays() > 0) {
            newInstance = duration.getSign() > 0 ? this.mCalendarMetrics.nextDay(this.getInstance(), duration.getRawDays()) : this.mCalendarMetrics.prevDay(this.getInstance(), duration.getRawDays());
        }
        if (duration.getSecondsOfDay() == 0) {
            return new DateTime(this.mCalendarMetrics, this.mTimezone, newInstance, this.mAllday, Long.MAX_VALUE);
        }
        long newTimestamp = newInstance == this.mInstance ? this.getTimestamp() : this.mCalendarMetrics.toMillis(newInstance == Long.MAX_VALUE ? this.getInstance() : newInstance, this.mTimezone);
        return new DateTime(this.mCalendarMetrics, this.mTimezone, newTimestamp += (long)(duration.getSign() * duration.getSecondsOfDay() * 1000));
    }

    public long getInstance() {
        long instance = this.mInstance;
        if (instance == Long.MAX_VALUE) {
            this.mInstance = this.mCalendarMetrics.toInstance(this.mTimestamp, this.mTimezone);
            return this.mInstance;
        }
        return instance;
    }

    public boolean after(DateTime that) {
        if (that.mInstance != Long.MAX_VALUE && (that.mTimestamp == Long.MAX_VALUE || this.mInstance != Long.MAX_VALUE) && this.mCalendarMetrics.scaleEquals(that.mCalendarMetrics) && this.mAllday == that.mAllday && DateTime.sameTimestamps(this.mTimezone, that.mTimezone)) {
            return this.getInstance() > that.mInstance;
        }
        return this.getTimestamp() > that.getTimestamp();
    }

    public boolean before(DateTime that) {
        if (that.mInstance != Long.MAX_VALUE && (that.mTimestamp == Long.MAX_VALUE || this.mInstance != Long.MAX_VALUE) && this.mCalendarMetrics.scaleEquals(that.mCalendarMetrics) && this.mAllday == that.mAllday && DateTime.sameTimestamps(this.mTimezone, that.mTimezone)) {
            return this.getInstance() < that.mInstance;
        }
        return this.getTimestamp() < that.getTimestamp();
    }

    public int hashCode() {
        return (int)this.getTimestamp();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DateTime)) {
            return false;
        }
        DateTime other = (DateTime)obj;
        if (this.mInstance != Long.MAX_VALUE && other.mInstance != Long.MAX_VALUE) {
            return this.mInstance == other.mInstance && this.mAllday == other.mAllday && this.mCalendarMetrics.scaleEquals(other.mCalendarMetrics) && (this.mTimezone == other.mTimezone || this.mTimezone != null && other.mTimezone != null && DateTime.sameTimestamps(this.mTimezone, other.mTimezone));
        }
        return this.mAllday == other.mAllday && this.mCalendarMetrics.scaleEquals(other.mCalendarMetrics) && this.getTimestamp() == other.getTimestamp() && (this.mTimezone == other.mTimezone || this.mTimezone != null && other.mTimezone != null && DateTime.sameTimestamps(this.mTimezone, other.mTimezone));
    }

    public String toString() {
        long instance = this.getInstance();
        StringBuilder result = new StringBuilder(16);
        Instance.writeTo(result, instance, this.mAllday);
        TimeZone tz = this.mTimezone;
        if (!this.mAllday && tz != null && "UTC".equals(tz.getID())) {
            result.append('Z');
        }
        return result.toString();
    }

    public void writeTo(StringBuilder out) throws IOException {
        long instance = this.getInstance();
        Instance.writeTo(out, instance, this.mAllday);
        TimeZone tz = this.mTimezone;
        if (!this.mAllday && tz != null && "UTC".equals(tz.getID())) {
            out.append('Z');
        }
    }

    public void writeTo(Writer out) throws IOException {
        long instance = this.getInstance();
        Instance.writeTo(out, instance, this.mAllday);
        TimeZone tz = this.mTimezone;
        if (!this.mAllday && tz != null && "UTC".equals(tz.getID())) {
            out.write(90);
        }
    }
}

