/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545;

import java.io.IOException;
import java.io.Writer;
import java.util.TimeZone;
import org.dmfs.rfc5545.DateTime;

public final class Duration {
    private static final int PARSER_STATE_SIGN = 0;
    private static final int PARSER_STATE_P = 1;
    private static final int PARSER_STATE_D = 3;
    private static final int PARSER_STATE_T = 4;
    private static final int PARSER_STATE_H = 5;
    private static final int PARSER_STATE_M = 6;
    private static final int PARSER_STATE_S = 7;
    private static final int PARSER_STATE_W = 8;
    private final int mSign;
    private final int mDays;
    private final int mTime;

    public Duration(int sign, int weeks) {
        this(sign, weeks * 7, 0);
    }

    public Duration(int sign, int days, int hours, int minutes, int seconds) {
        this(sign, days, hours * 3600 + minutes * 60 + seconds);
    }

    public Duration(int sign, int days, int time) {
        if (sign != 1 && sign != -1) {
            throw new IllegalArgumentException("sign must be 1 or -1");
        }
        if (days < 0 || time < 0) {
            throw new IllegalArgumentException("Duration values must be >=0");
        }
        this.mSign = sign;
        this.mDays = days;
        this.mTime = time;
    }

    public static Duration parse(String durationString) {
        if (durationString == null || durationString.length() < 3) {
            throw new IllegalArgumentException("Invalid Duration string: " + durationString);
        }
        int sign = 1;
        int weeks = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int currentValue = 0;
        int parserState = -1;
        int nextState = -1;
        boolean hadD = false;
        boolean hadT = false;
        int count = durationString.length();
        for (int i = 0; i < count; ++i) {
            char c = durationString.charAt(i);
            boolean wasDigit = false;
            switch (c) {
                case '-': {
                    sign = -1;
                }
                case '+': {
                    nextState = 0;
                    break;
                }
                case 'P': 
                case 'p': {
                    nextState = 1;
                    break;
                }
                case 'D': 
                case 'd': {
                    days = currentValue;
                    currentValue = 0;
                    nextState = 3;
                    hadD = true;
                    break;
                }
                case 'T': 
                case 't': {
                    nextState = 4;
                    hadT = true;
                    break;
                }
                case 'H': 
                case 'h': {
                    hours = currentValue;
                    currentValue = 0;
                    nextState = 5;
                    break;
                }
                case 'M': 
                case 'm': {
                    minutes = currentValue;
                    currentValue = 0;
                    nextState = 6;
                    break;
                }
                case 'S': 
                case 's': {
                    seconds = currentValue;
                    currentValue = 0;
                    nextState = 7;
                    break;
                }
                case 'W': 
                case 'w': {
                    weeks = currentValue;
                    currentValue = 0;
                    nextState = 8;
                    break;
                }
                default: {
                    if (c < '0' || c > '9') {
                        throw new IllegalArgumentException("Unexpected char '" + c + "' at position " + i);
                    }
                    currentValue = currentValue * 10 + (c - 48);
                    wasDigit = true;
                }
            }
            if (parserState > nextState || !wasDigit && parserState == nextState) {
                throw new IllegalArgumentException("Unexpected char '" + c + "' at position " + i);
            }
            parserState = nextState;
        }
        if (parserState <= 1 || !hadD && parserState == 4 || !hadT && parserState > 4 && parserState < 8) {
            throw new IllegalArgumentException("Invalid duration string: " + durationString);
        }
        if (weeks != 0) {
            return new Duration(sign, weeks);
        }
        return new Duration(sign, days, hours, minutes, seconds);
    }

    public boolean isZero() {
        return this.mDays + this.mTime == 0;
    }

    public int getSign() {
        return this.mSign;
    }

    public int getWeeks() {
        return this.mDays % 7 + this.mTime == 0 ? this.mDays / 7 : 0;
    }

    public int getDays() {
        return this.mDays % 7 + this.mTime > 0 ? this.mDays : 0;
    }

    public int getRawDays() {
        return this.mDays;
    }

    public int getHours() {
        return this.mTime / 3600;
    }

    public int getMinutes() {
        return this.mTime / 60 % 60;
    }

    public int getSeconds() {
        return this.mTime % 60;
    }

    public int getSecondsOfDay() {
        return this.mTime;
    }

    public long toMillis() {
        return (long)this.mSign * ((long)this.mDays * 24L * 3600L + (long)this.mTime) * 1000L;
    }

    public long addTo(TimeZone timezone, long timestamp) {
        if (this.isZero()) {
            return timestamp;
        }
        if (timezone == null || !timezone.useDaylightTime()) {
            return timestamp + this.toMillis();
        }
        return new DateTime(timezone, timestamp).addDuration(this).getTimestamp();
    }

    public Duration addDuration(Duration other) {
        if (other == null) {
            throw new IllegalArgumentException("Duration must not be null");
        }
        if (other.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return other;
        }
        if (this.mSign == other.mSign) {
            int newDays = this.mDays + other.mDays;
            int newTime = this.mTime + other.mTime;
            return new Duration(this.mSign, newDays, newTime);
        }
        int newDays = this.mSign * this.mDays + other.mSign * other.mDays;
        int newTime = this.mSign * this.mTime + other.mSign * other.mTime;
        if (newDays >= 0 && newTime >= 0) {
            return new Duration(1, newDays, newTime);
        }
        if (newDays < 0 && newTime < 0) {
            return new Duration(-1, -newDays, -newTime);
        }
        int totalSeconds = newDays * 24 * 3600 + newTime;
        newDays = totalSeconds / 86400;
        newTime = totalSeconds % 86400;
        if (totalSeconds >= 0) {
            return new Duration(1, newDays, newTime);
        }
        return new Duration(-1, -newDays, -newTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(15);
        this.writeTo(sb);
        return sb.toString();
    }

    public void writeTo(StringBuilder builder) {
        if (this.mSign < 0 && (this.mDays > 0 || this.mTime > 0)) {
            builder.append('-');
        }
        builder.append('P');
        int weeks = this.getWeeks();
        if (weeks > 0) {
            builder.append(weeks);
            builder.append('W');
        } else {
            if (this.mDays > 0) {
                builder.append(this.mDays);
                builder.append('D');
            }
            if (this.mTime != 0) {
                int hours = this.getHours();
                int minutes = this.getMinutes();
                int seconds = this.getSeconds();
                builder.append('T');
                if (hours > 0) {
                    builder.append(hours);
                    builder.append('H');
                }
                if (minutes > 0) {
                    builder.append(minutes);
                    builder.append('M');
                }
                if (seconds > 0) {
                    builder.append(seconds);
                    builder.append('S');
                }
            } else if (this.mDays == 0) {
                builder.append("0D");
            }
        }
    }

    public void writeTo(Writer writer) throws IOException {
        if (this.mSign < 0 && (this.mDays > 0 || this.mTime > 0)) {
            writer.append('-');
        }
        writer.append('P');
        int weeks = this.getWeeks();
        if (weeks > 0) {
            writer.write(Integer.toString(weeks));
            writer.write(87);
        } else {
            if (this.mDays > 0) {
                writer.write(Integer.toString(this.mDays));
                writer.write(68);
            }
            if (this.mTime != 0) {
                int hours = this.getHours();
                int minutes = this.getMinutes();
                int seconds = this.getSeconds();
                writer.write(84);
                if (hours > 0) {
                    writer.write(Integer.toString(hours));
                    writer.write(72);
                }
                if (minutes > 0) {
                    writer.write(Integer.toString(minutes));
                    writer.write(77);
                }
                if (seconds > 0) {
                    writer.write(Integer.toString(seconds));
                    writer.write(83);
                }
            } else if (this.mDays == 0) {
                writer.write("0D");
            }
        }
    }

    public int hashCode() {
        return this.mSign * (this.mDays * 24 * 3600 + this.mTime);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Duration)) {
            return false;
        }
        Duration other = (Duration)obj;
        return this.mSign == other.mSign && this.mDays == other.mDays && this.mTime == other.mTime;
    }
}

