/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545;

import java.io.IOException;
import java.io.Writer;

public final class Instance {
    private static final int YEAR_BITS = 18;
    private static final int MONTH_BITS = 8;
    private static final int DAY_BITS = 7;
    private static final int HOUR_BITS = 5;
    private static final int MINUTE_BITS = 6;
    private static final int SECOND_BITS = 6;
    private static final int WEEKDAY_BITS = 4;
    private static final int WEEKDAY_POS = 0;
    private static final int SECOND_POS = 4;
    private static final int MINUTE_POS = 10;
    private static final int HOUR_POS = 16;
    private static final int DAY_POS = 21;
    private static final int MONTH_POS = 28;
    private static final int YEAR_POS = 36;
    private static final long SECOND_MASK = 1008L;
    private static final long MINUTE_MASK = 64512L;
    private static final long HOUR_MASK = 0x1F0000L;
    private static final long WEEKDAY_MASK = 15L;
    private static final long DAY_MASK = 0xFE00000L;
    private static final long MONTH_MASK = 0xFF0000000L;
    private static final long YEAR_MASK = 0x3FFFF000000000L;
    private static final int YEAR_BIAS = 0;
    private static final int DAY_BIAS = 64;

    private Instance() {
    }

    public static long make(int year, int month, int dayOfMonth, int hour, int minute, int second, int dayOfWeek) {
        return (long)year + 0L << 36 | (long)month << 28 | (long)dayOfMonth + 64L << 21 | (long)dayOfWeek << 0 | (long)hour << 16 | (long)minute << 10 | (long)second << 4;
    }

    public static long make(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        return (long)year + 0L << 36 | (long)month << 28 | (long)dayOfMonth + 64L << 21 | (long)hour << 16 | (long)minute << 10 | (long)second << 4;
    }

    public static long setYear(long instance, int year) {
        return instance & 0xFFC0000FFFFFFFFFL | (long)year + 0L << 36;
    }

    public static long setMonth(long instance, int month) {
        return instance & 0xFFFFFFF00FFFFFFFL | (long)month << 28;
    }

    public static long setDayOfMonth(long instance, int dayOfMonth) {
        return instance & 0xFFFFFFFFF01FFFFFL | (long)dayOfMonth + 64L << 21;
    }

    public static long setDayOfWeek(long instance, int dayOfWeek) {
        return instance & 0xFFFFFFFFFFFFFFF0L | (long)(dayOfWeek << 0);
    }

    public static long setMonthAndDayOfMonth(long instance, int month, int dayOfMonth) {
        return instance & 0xFFFFFFF0001FFFFFL | (long)month << 28 | (long)dayOfMonth + 64L << 21;
    }

    public static long setHour(long instance, int hour) {
        return instance & 0xFFFFFFFFFFE0FFFFL | (long)hour << 16;
    }

    public static long setMinute(long instance, int minute) {
        return instance & 0xFFFFFFFFFFFF03FFL | (long)minute << 10;
    }

    public static long setSecond(long instance, int second) {
        return instance & 0xFFFFFFFFFFFFFC0FL | (long)second << 4;
    }

    public static long maskWeekday(long instance) {
        return instance & 0xFFFFFFFFFFFFFFF0L;
    }

    public static int year(long instance) {
        return (int)((instance & 0x3FFFF000000000L) >>> 36) - 0;
    }

    public static int month(long instance) {
        return (int)((instance & 0xFF0000000L) >>> 28);
    }

    public static int dayOfMonth(long instance) {
        return (int)((instance & 0xFE00000L) >>> 21) - 64;
    }

    public static int hour(long instance) {
        return (int)((instance & 0x1F0000L) >>> 16);
    }

    public static int minute(long instance) {
        return (int)((instance & 0xFC00L) >>> 10);
    }

    public static int second(long instance) {
        return (int)((instance & 0x3F0L) >>> 4);
    }

    public static int dayOfWeek(long instance) {
        return (int)((instance & 0xFL) >>> 0);
    }

    public static String toString(long instance) {
        return Instance.toString(instance, false);
    }

    public static String toString(long instance, boolean dateOnly) {
        StringBuilder result = new StringBuilder(16);
        Instance.writeTo(result, instance, dateOnly);
        return result.toString();
    }

    private static void writeDigits(StringBuilder sb, int num) {
        sb.append((char)(num / 10 % 10 + 48));
        sb.append((char)(num % 10 + 48));
    }

    public static void writeTo(StringBuilder out, long instance) {
        Instance.writeTo(out, instance, false);
    }

    public static void writeTo(StringBuilder out, long instance, boolean dateOnly) {
        int year = Instance.year(instance);
        Instance.writeDigits(out, year / 100);
        Instance.writeDigits(out, year % 100);
        Instance.writeDigits(out, Instance.month(instance) + 1);
        Instance.writeDigits(out, Instance.dayOfMonth(instance));
        if (!dateOnly) {
            out.append('T');
            Instance.writeDigits(out, Instance.hour(instance));
            Instance.writeDigits(out, Instance.minute(instance));
            Instance.writeDigits(out, Instance.second(instance));
        }
    }

    public static void writeTo(Writer out, long instance) throws IOException {
        Instance.writeTo(out, instance, false);
    }

    public static void writeTo(Writer out, long instance, boolean dateOnly) throws IOException {
        int year = Instance.year(instance);
        Instance.writeDigits(out, year / 100);
        Instance.writeDigits(out, year % 100);
        Instance.writeDigits(out, Instance.month(instance) + 1);
        Instance.writeDigits(out, Instance.dayOfMonth(instance));
        if (!dateOnly) {
            out.append('T');
            Instance.writeDigits(out, Instance.hour(instance));
            Instance.writeDigits(out, Instance.minute(instance));
            Instance.writeDigits(out, Instance.second(instance));
        }
    }

    private static void writeDigits(Writer out, int num) throws IOException {
        out.write(num / 10 % 10 + 48);
        out.write(num % 10 + 48);
    }
}

