/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.calendarmetrics;

import java.util.TimeZone;
import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.Weekday;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.calendarmetrics.GregorianCalendarMetrics;
import org.dmfs.rfc5545.calendarmetrics.NoLeapMonthCalendarMetrics;

public class IslamicCalendarMetrics
extends NoLeapMonthCalendarMetrics {
    public static final long DAYS_PER_CYCLE = 10631L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long MILLIS_PER_CYCLE = 918518400000L;
    public static final long MILLIS_TO_1389_10_22C = 42521587200000L;
    public static final String CALENDAR_SCALE_TLBA = "ISLAMIC-TLBA";
    public static final String CALENDAR_SCALE_CIVIL = "ISLAMIC-CIVIL";
    public static final int[] LEAP_YEAR_PATTERNS = new int[]{623158436, 623191204, 690562340, 0x49292924};
    public static final byte[][] LEAP_YEAR_COUNT = new byte[][]{{0, 0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11}, {0, 0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11}, {0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 11, 11}, {0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 10, 11}};
    public static final Weekday[] WEEKDAYS = Weekday.values();
    private static final CalendarMetrics GREGORIAN_METRICS = GregorianCalendarMetrics.FACTORY.getCalendarMetrics(Weekday.SU);
    private final int mLeapYearPatternIndex;
    private final boolean mCivil;

    public IslamicCalendarMetrics(String name, Weekday weekStart, int minDaysInFirstWeek, LeapYearPattern leapYearPatternIndex, boolean civil) {
        super(name, weekStart, minDaysInFirstWeek);
        this.mLeapYearPatternIndex = leapYearPatternIndex.ordinal();
        this.mCivil = civil;
    }

    @Override
    public int getMaxMonthDayNum() {
        return 30;
    }

    @Override
    public int getMaxYearDayNum() {
        return 355;
    }

    @Override
    public int getMaxWeekNoNum() {
        return 52;
    }

    @Override
    public int getDaysPerPackedMonth(int year, int packedMonth) {
        if (packedMonth == 11 && this.isLeapYear(year)) {
            return 30;
        }
        return 30 - (packedMonth & 1);
    }

    @Override
    public int getYearDaysForPackedMonth(int year, int packedMonth) {
        return packedMonth * 29 + (packedMonth + 1 >>> 1);
    }

    @Override
    public int getMonthsPerYear() {
        return 12;
    }

    @Override
    public int getDaysPerYear(int year) {
        return this.isLeapYear(year) ? 355 : 354;
    }

    @Override
    public int getWeeksPerYear(int year) {
        int yd1st = this.getYearDayOfFirstWeekStart(year);
        int yearDays = this.getDaysPerYear(year) - yd1st + 1;
        int fullweeks = yearDays / 7;
        int remainingDays = yearDays % 7;
        return 7 - remainingDays >= this.minDaysInFirstWeek ? fullweeks : fullweeks + 1;
    }

    @Override
    public int getWeekOfYear(int year, int yearDay) {
        int yd1st = this.getYearDayOfFirstWeekStart(year);
        if (yearDay < yd1st) {
            int weeksInYear = this.getWeeksPerYear(year - 1);
            return weeksInYear;
        }
        int week = (yearDay - yd1st) / 7 + 1;
        int weeksInYear = this.getWeeksPerYear(year);
        return week > weeksInYear ? week - weeksInYear : week;
    }

    @Override
    public int getDayOfYear(int year, int packedMonth, int dayOfMonth) {
        return this.getYearDaysForPackedMonth(year, packedMonth) + dayOfMonth;
    }

    boolean isLeapYear(int year) {
        return (LEAP_YEAR_PATTERNS[this.mLeapYearPatternIndex] & 1 << (year - 1) % 30 + 1) != 0;
    }

    @Override
    public int getWeekDayOfFirstYearDay(int year) {
        int y = year - 1;
        int yc = y % 30;
        return (5 + 5 * (y / 30) + 4 * yc + LEAP_YEAR_COUNT[this.mLeapYearPatternIndex][yc]) % 7;
    }

    @Override
    public int getYearDayOfFirstWeekStart(int year) {
        int jan1stWeekDay = this.getWeekDayOfFirstYearDay(year);
        int diff = this.weekStartInt - jan1stWeekDay;
        int yd = 1 + diff;
        return yd > this.minDaysInFirstWeek ? yd - 7 : (yd < this.minDaysInFirstWeek - 6 ? yd + 7 : yd);
    }

    @Override
    public int getPackedMonthOfYearDay(int year, int yearDay) {
        int yearDays;
        while (yearDay < 1) {
            yearDay += this.getDaysPerYear(--year);
        }
        while (yearDay > (yearDays = this.getDaysPerYear(year))) {
            ++year;
            yearDay -= yearDays;
        }
        return yearDay == 355 ? 11 : (yearDay - 1) * 2 / 59;
    }

    @Override
    public int getDayOfMonthOfYearDay(int year, int yearDay) {
        return yearDay - this.getYearDaysForPackedMonth(year, this.getPackedMonthOfYearDay(year, yearDay));
    }

    @Override
    public int getMonthAndDayOfYearDay(int year, int yearDay) {
        int yearDays;
        while (yearDay < 1) {
            yearDay += this.getDaysPerYear(--year);
        }
        while (yearDay > (yearDays = this.getDaysPerYear(year))) {
            ++year;
            yearDay -= yearDays;
        }
        int month = yearDay == 355 ? 11 : (yearDay - 1) * 2 / 59;
        return IslamicCalendarMetrics.monthAndDay(month, yearDay - this.getYearDaysForPackedMonth(year, month));
    }

    @Override
    public int getYearDayOfIsoYear(int year, int weekOfYear, int dayOfWeek) {
        return weekOfYear * 7 - 7 + (dayOfWeek - this.weekStartInt + 7) % 7 + this.getYearDayOfFirstWeekStart(year);
    }

    @Override
    public int getYearDayOfWeekStart(int year, int week) {
        return this.getYearDayOfFirstWeekStart(year) + (week - 1) * 7;
    }

    @Override
    public long toMillis(TimeZone timeZone, int year, int packedMonth, int dayOfMonth, int hours, int minutes, int seconds, int millis) {
        long gregorianDate = this.toGregorian(Instance.make(year, packedMonth, dayOfMonth, 0, 0, 0));
        year = Instance.year(gregorianDate);
        packedMonth = Instance.month(gregorianDate);
        dayOfMonth = Instance.dayOfMonth(gregorianDate);
        return GREGORIAN_METRICS.toMillis(timeZone, year, packedMonth, dayOfMonth, hours, minutes, seconds, millis);
    }

    @Override
    public long toInstance(long timestamp, TimeZone timeZone) {
        long localTime = timestamp;
        if (timeZone != null) {
            localTime += (long)timeZone.getOffset(timestamp);
        }
        int time = (int)((localTime += this.mCivil ? 42521587200000L : 42521673600000L) % 86400000L);
        localTime /= 86400000L;
        if (time < 0) {
            time += 86400000;
            --localTime;
        }
        int cycles = (int)(localTime / 10631L);
        long daysInCycle = localTime % 10631L;
        int year = (int)(daysInCycle / 355L);
        int yearDay = (int)(daysInCycle - (long)(year * 354 + LEAP_YEAR_COUNT[this.mLeapYearPatternIndex][year])) + 1;
        if (yearDay > 355 || yearDay == 355 && !this.isLeapYear(++year)) {
            yearDay -= this.getDaysPerYear(year);
            ++year;
        }
        int minutes = time / 60000;
        int monthAndDay = this.getMonthAndDayOfYearDay(year, yearDay);
        return Instance.make(30 * cycles + year, IslamicCalendarMetrics.packedMonth(monthAndDay), IslamicCalendarMetrics.dayOfMonth(monthAndDay), minutes / 60, minutes % 60, time / 1000 % 60);
    }

    public long toGregorian(long islamicInstance) {
        int iYear = Instance.year(islamicInstance);
        int iPackedMonth = Instance.month(islamicInstance);
        int iDayOfMonth = Instance.dayOfMonth(islamicInstance);
        int yearInCycle = (iYear - 1) % 30;
        long iTimeStamp = (((long)iYear - 1L) / 30L * 10631L + (354L * (long)yearInCycle + (long)LEAP_YEAR_COUNT[this.mLeapYearPatternIndex][yearInCycle]) + (long)this.getDayOfYear(iYear, iPackedMonth, iDayOfMonth) - 1L) * 24L * 3600L * 1000L;
        long localTime = this.mCivil ? iTimeStamp - 42521587200000L : iTimeStamp - 42521587200000L - 86400000L;
        return GREGORIAN_METRICS.toInstance(localTime, null);
    }

    public static final class IslamicCalendarMetricsFactory
    extends CalendarMetrics.CalendarMetricsFactory {
        private final String mName;
        private final LeapYearPattern mPattern;
        private final boolean mCivil;

        public IslamicCalendarMetricsFactory(String name, LeapYearPattern pattern, boolean civil) {
            this.mName = name;
            this.mPattern = pattern;
            this.mCivil = civil;
        }

        @Override
        public CalendarMetrics getCalendarMetrics(Weekday weekStart) {
            return new IslamicCalendarMetrics(this.mName, weekStart, 4, this.mPattern, this.mCivil);
        }

        public String toString() {
            return this.mName;
        }
    }

    public static enum LeapYearPattern {
        I,
        II,
        III,
        IV;

    }
}

