/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.calendarmetrics;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.Weekday;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;

public abstract class NoLeapMonthCalendarMetrics
extends CalendarMetrics {
    public NoLeapMonthCalendarMetrics(String name, Weekday weekStart, int minDaysInFirstWeek) {
        super(name, weekStart, minDaysInFirstWeek);
    }

    @Override
    public int packedMonth(String month) {
        try {
            int monthNum = Integer.parseInt(month) - 1;
            if (monthNum < 0 || monthNum >= this.getMonthsPerYear()) {
                throw new IllegalArgumentException("month " + month + " is out of range 1.." + this.getMonthsPerYear());
            }
            return monthNum;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("illegal month string " + month, e);
        }
    }

    @Override
    public String packedMonthToString(int packedMonth) {
        return String.valueOf(packedMonth + 1);
    }

    @Override
    public int packedMonth(int monthNum, boolean leapMonth) {
        return monthNum;
    }

    @Override
    public boolean isLeapMonth(int packedMonth) {
        return false;
    }

    @Override
    public int monthNum(int packedMonth) {
        return packedMonth;
    }

    @Override
    public int getMonthsPerYear(int year) {
        return this.getMonthsPerYear();
    }

    public abstract int getMonthsPerYear();

    @Override
    public long nextMonth(long instance) {
        int newMonth = Instance.month(instance) + 1;
        if (newMonth < this.getMonthsPerYear()) {
            return Instance.setMonth(instance, newMonth);
        }
        return Instance.setYear(Instance.setMonth(instance, 0), Instance.year(instance) + 1);
    }

    @Override
    public long nextMonth(long instance, int n) {
        int maxMonthsPerYear;
        if (n < 0) {
            throw new IllegalArgumentException("n must be >=0");
        }
        if (n == 0) {
            return instance;
        }
        int newMonth = Instance.month(instance) + n;
        if (newMonth < (maxMonthsPerYear = this.getMonthsPerYear())) {
            return Instance.setMonth(instance, newMonth);
        }
        return Instance.setYear(Instance.setMonth(instance, newMonth % maxMonthsPerYear), Instance.year(instance) + newMonth / maxMonthsPerYear);
    }

    @Override
    public long prevMonth(long instance) {
        int newMonth = Instance.month(instance) - 1;
        if (newMonth >= 0) {
            return Instance.setMonth(instance, newMonth);
        }
        return Instance.setYear(Instance.setMonth(instance, this.getMonthsPerYear() - 1), Instance.year(instance) - 1);
    }

    @Override
    public long prevMonth(long instance, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be >=0");
        }
        if (n == 0) {
            return instance;
        }
        int newMonth = Instance.month(instance) - n;
        int maxMonthsPerYear = this.getMonthsPerYear();
        if (newMonth >= 0) {
            return Instance.setMonth(instance, newMonth);
        }
        return Instance.setYear(Instance.setMonth(instance, (maxMonthsPerYear + newMonth % maxMonthsPerYear) % maxMonthsPerYear), Instance.year(instance) + newMonth / maxMonthsPerYear);
    }

    @Override
    public long nextDay(long instance) {
        int month;
        int year;
        int day = Instance.dayOfMonth(instance) + 1;
        if (day > this.getDaysPerPackedMonth(year = Instance.year(instance), month = Instance.month(instance))) {
            day = 1;
            if (++month == this.getMonthsPerYear()) {
                instance = Instance.setYear(instance, year + 1);
                month = 0;
            }
            instance = Instance.setMonth(instance, month);
        }
        return Instance.setDayOfMonth(instance, day);
    }

    @Override
    public long nextDay(long instance, int n) {
        int yearDays;
        if (n < 0) {
            throw new IllegalArgumentException("n must be >=0");
        }
        if (n == 0) {
            return instance;
        }
        int year = Instance.year(instance);
        int month = Instance.month(instance);
        int day = Math.min(Instance.dayOfMonth(instance), this.getDaysPerPackedMonth(year, month));
        int yearDay = this.getDayOfYear(year, month, day) + n;
        while (yearDay > (yearDays = this.getDaysPerYear(year))) {
            yearDay -= yearDays;
            ++year;
        }
        int monthAndDay = this.getMonthAndDayOfYearDay(year, yearDay);
        return Instance.setYear(Instance.setMonthAndDayOfMonth(instance, NoLeapMonthCalendarMetrics.packedMonth(monthAndDay), NoLeapMonthCalendarMetrics.dayOfMonth(monthAndDay)), year);
    }

    @Override
    public long prevDay(long instance) {
        int day = Math.min(Instance.dayOfMonth(instance) - 1, this.getDaysPerPackedMonth(Instance.year(instance), Instance.month(instance)));
        if (day <= 0) {
            int year = Instance.year(instance);
            int month = Instance.month(instance) - 1;
            if (month <= -1) {
                instance = Instance.setYear(instance, --year);
                month = this.getMonthsPerYear() - 1;
            }
            day = this.getDaysPerPackedMonth(year, month);
            instance = Instance.setMonth(instance, month);
        }
        return Instance.setDayOfMonth(instance, day);
    }

    @Override
    public long prevDay(long instance, int n) {
        int yearDay;
        if (n < 0) {
            throw new IllegalArgumentException("n must be >=0");
        }
        if (n == 0) {
            return instance;
        }
        int year = Instance.year(instance);
        int month = Instance.month(instance);
        int day = Math.min(Instance.dayOfMonth(instance), this.getDaysPerPackedMonth(year, month) + 1);
        for (yearDay = this.getDayOfYear(year, month, day) - n; yearDay < 1; yearDay += this.getDaysPerYear(--year)) {
        }
        int monthAndDay = this.getMonthAndDayOfYearDay(year, yearDay);
        return Instance.setYear(Instance.setMonthAndDayOfMonth(instance, NoLeapMonthCalendarMetrics.packedMonth(monthAndDay), NoLeapMonthCalendarMetrics.dayOfMonth(monthAndDay)), year);
    }
}

