/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBElement;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.FormattingOption;
import org.docx4j.convert.in.xhtml.ListHelper;
import org.docx4j.convert.in.xhtml.PPrCleanser;
import org.docx4j.convert.in.xhtml.RPrCleanser;
import org.docx4j.convert.in.xhtml.XHTMLImageHandler;
import org.docx4j.convert.in.xhtml.XHTMLImageHandlerDefault;
import org.docx4j.convert.in.xhtml.XHTMLImporter;
import org.docx4j.convert.out.html.HtmlCssHelper;
import org.docx4j.jaxb.Context;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.properties.paragraph.AbstractParagraphProperty;
import org.docx4j.model.properties.paragraph.Indent;
import org.docx4j.model.properties.run.AbstractRunProperty;
import org.docx4j.model.properties.run.FontSize;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.org.xhtmlrenderer.css.constants.CSSName;
import org.docx4j.org.xhtmlrenderer.css.constants.IdentValue;
import org.docx4j.org.xhtmlrenderer.css.parser.FSColor;
import org.docx4j.org.xhtmlrenderer.css.parser.FSRGBColor;
import org.docx4j.org.xhtmlrenderer.css.style.CalculatedStyle;
import org.docx4j.org.xhtmlrenderer.css.style.CssContext;
import org.docx4j.org.xhtmlrenderer.css.style.DerivedValue;
import org.docx4j.org.xhtmlrenderer.css.style.FSDerivedValue;
import org.docx4j.org.xhtmlrenderer.css.style.derived.LengthValue;
import org.docx4j.org.xhtmlrenderer.docx.DocxRenderer;
import org.docx4j.org.xhtmlrenderer.layout.Styleable;
import org.docx4j.org.xhtmlrenderer.newtable.TableBox;
import org.docx4j.org.xhtmlrenderer.newtable.TableCellBox;
import org.docx4j.org.xhtmlrenderer.newtable.TableRowBox;
import org.docx4j.org.xhtmlrenderer.newtable.TableSectionBox;
import org.docx4j.org.xhtmlrenderer.render.AnonymousBlockBox;
import org.docx4j.org.xhtmlrenderer.render.BlockBox;
import org.docx4j.org.xhtmlrenderer.render.Box;
import org.docx4j.org.xhtmlrenderer.render.InlineBox;
import org.docx4j.org.xhtmlrenderer.resource.XMLResource;
import org.docx4j.org.xhtmlrenderer.util.XRRuntimeException;
import org.docx4j.relationships.ObjectFactory;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Body;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.CTTblLayoutType;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.DocDefaults;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.RStyle;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.STTblLayoutType;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblBorders;
import org.docx4j.wml.TblGrid;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XHTMLImporterImpl
implements XHTMLImporter {
    public static Logger log = LoggerFactory.getLogger(XHTMLImporterImpl.class);
    private String hyperlinkStyleId = null;
    private XHTMLImageHandler xHTMLImageHandler = new XHTMLImageHandlerDefault();
    private Body imports = null;
    protected WordprocessingMLPackage wordMLPackage;
    private RelationshipsPart rp;
    private NumberingDefinitionsPart ndp;
    private ListHelper listHelper;
    private DocxRenderer renderer;
    private static FontFamilyMap fontFamilyToFont = new FontFamilyMap();
    private FormattingOption runFormatting = FormattingOption.CLASS_PLUS_OTHER;
    private FormattingOption paragraphFormatting = FormattingOption.CLASS_PLUS_OTHER;
    private FormattingOption tableFormatting = FormattingOption.CLASS_PLUS_OTHER;
    private static Set<String> cssWhiteList = null;
    Map<String, Style> stylesByID = new HashMap<String, Style>();
    private LinkedList<ContentAccessor> contentContextStack = new LinkedList();
    P attachmentPointP = null;
    P.Hyperlink attachmentPointH = null;
    boolean paraStillEmpty;
    private CTMarkupRange markuprange;
    private AtomicInteger bookmarkId = new AtomicInteger();
    private Map<String, RFonts> fontFamiliesToFont = new HashMap<String, RFonts>();

    public void setHyperlinkStyle(String hyperlinkStyleID) {
        this.hyperlinkStyleId = hyperlinkStyleID;
    }

    public void setXHTMLImageHandler(XHTMLImageHandler xHTMLImageHandler) {
        this.xHTMLImageHandler = xHTMLImageHandler;
    }

    public DocxRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = this.paragraphFormatting == FormattingOption.CLASS_PLUS_OTHER || this.paragraphFormatting == FormattingOption.CLASS_TO_STYLE_ONLY ? new DocxRenderer(this.stylesToCSS()) : new DocxRenderer();
        }
        return this.renderer;
    }

    public void setRenderer(DocxRenderer renderer) {
        this.renderer = renderer;
    }

    public static void addFontMapping(String cssFontFamily, RFonts rFonts) {
        fontFamilyToFont.put(cssFontFamily, rFonts);
    }

    public void setRunFormatting(FormattingOption runFormatting) {
        this.runFormatting = runFormatting;
    }

    public void setParagraphFormatting(FormattingOption paragraphFormatting) {
        this.paragraphFormatting = paragraphFormatting;
    }

    public void setTableFormatting(FormattingOption tableFormatting) {
        this.tableFormatting = tableFormatting;
    }

    private void displayFormattingOptionSettings() {
        log.info("tableFormatting: " + this.tableFormatting);
        log.info("paragraphFormatting: " + this.paragraphFormatting);
        log.info("runFormatting: " + this.runFormatting);
    }

    @Deprecated
    public static void setCssWhiteList(Set<String> cssWhiteList) {
    }

    private XHTMLImporterImpl() {
    }

    public XHTMLImporterImpl(WordprocessingMLPackage wordMLPackage) {
        this.displayFormattingOptionSettings();
        this.wordMLPackage = wordMLPackage;
        this.rp = wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        this.ndp = wordMLPackage.getMainDocumentPart().getNumberingDefinitionsPart();
        if (this.ndp == null) {
            log.debug("No NumberingDefinitions part - so adding");
            try {
                this.ndp = new NumberingDefinitionsPart();
                wordMLPackage.getMainDocumentPart().addTargetPart((Part)this.ndp);
                this.ndp.setJaxbElement((Object)Context.getWmlObjectFactory().createNumbering());
            }
            catch (InvalidFormatException e1) {
                e1.printStackTrace();
            }
        }
        this.listHelper = new ListHelper(this.ndp);
        if (this.hyperlinkStyleId != null && wordMLPackage instanceof WordprocessingMLPackage) {
            wordMLPackage.getMainDocumentPart().getPropertyResolver().activateStyle(this.hyperlinkStyleId);
        }
        this.initStyleMap(wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart());
        this.imports = Context.getWmlObjectFactory().createBody();
        this.contentContextStack.push((ContentAccessor)this.imports);
    }

    private void setDefaultFontSize() {
        DocDefaults.RPrDefault rPrDefault;
        StyleDefinitionsPart sdp = this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart();
        if (sdp != null && ((Styles)sdp.getJaxbElement()).getDocDefaults() != null && (rPrDefault = ((Styles)sdp.getJaxbElement()).getDocDefaults().getRPrDefault()) != null && rPrDefault.getRPr() != null && rPrDefault.getRPr().getSz() != null) {
            HpsMeasure sz = rPrDefault.getRPr().getSz();
            FontSize.mediumHalfPts.set(sz.getVal());
        }
    }

    private void unsetDefaultFontSize() {
        FontSize.mediumHalfPts.remove();
    }

    private void initStyleMap(StyleDefinitionsPart sdp) {
        if (sdp == null) {
            return;
        }
        Styles styles = (Styles)sdp.getJaxbElement();
        for (Style s : styles.getStyle()) {
            this.stylesByID.put(s.getStyleId(), s);
        }
    }

    private String stylesToCSS() {
        String css = this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart().getCss();
        if (css == null) {
            StringBuilder result = new StringBuilder();
            HtmlCssHelper.createCssForStyles((OpcPackage)this.wordMLPackage, (StyleTree)this.wordMLPackage.getMainDocumentPart().getStyleTree(), (StringBuilder)result);
            css = result.toString();
            this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart().setCss(css);
        }
        return css;
    }

    public List<Object> convert(File file, String baseUrl) throws Docx4JException {
        this.renderer = this.getRenderer();
        File parent = file.getAbsoluteFile().getParentFile();
        try {
            this.renderer.setDocument(this.renderer.loadDocument(file.toURI().toURL().toExternalForm()), parent == null ? "" : parent.toURI().toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new Docx4JException("Malformed URL", (Exception)e);
        }
        this.renderer.layout();
        this.traverse((Box)this.renderer.getRootBox(), null);
        return this.imports.getContent();
    }

    public List<Object> convert(InputSource is, String baseUrl) throws Docx4JException {
        this.renderer = this.getRenderer();
        Document dom = XMLResource.load((InputSource)is).getDocument();
        this.renderer.setDocument(dom, baseUrl);
        this.renderer.layout();
        this.traverse((Box)this.renderer.getRootBox(), null);
        return this.imports.getContent();
    }

    public List<Object> convert(InputStream is, String baseUrl) throws Docx4JException {
        this.renderer = this.getRenderer();
        Document dom = XMLResource.load((InputStream)is).getDocument();
        this.renderer.setDocument(dom, baseUrl);
        this.renderer.layout();
        this.traverse((Box)this.renderer.getRootBox(), null);
        return this.imports.getContent();
    }

    public List<Object> convert(Node node, String baseUrl) throws Docx4JException {
        this.renderer = this.getRenderer();
        if (node instanceof Document) {
            this.renderer.setDocument((Document)node, baseUrl);
        } else {
            Document doc = XmlUtils.neww3cDomDocument();
            doc.importNode(node, true);
            this.renderer.setDocument(doc, baseUrl);
        }
        this.renderer.layout();
        this.traverse((Box)this.renderer.getRootBox(), null);
        return this.imports.getContent();
    }

    public List<Object> convert(Reader reader, String baseUrl) throws Docx4JException {
        this.renderer = this.getRenderer();
        Document dom = XMLResource.load((Reader)reader).getDocument();
        this.renderer.setDocument(dom, baseUrl);
        this.renderer.layout();
        this.traverse((Box)this.renderer.getRootBox(), null);
        return this.imports.getContent();
    }

    public List<Object> convert(Source source, String baseUrl) throws Docx4JException {
        this.renderer = this.getRenderer();
        Document dom = XMLResource.load((Source)source).getDocument();
        this.renderer.setDocument(dom, baseUrl);
        this.renderer.layout();
        this.traverse((Box)this.renderer.getRootBox(), null);
        return this.imports.getContent();
    }

    public List<Object> convert(URL url) throws Docx4JException {
        this.renderer = this.getRenderer();
        String urlString = url.toString();
        Document dom = this.renderer.loadDocument(urlString);
        this.renderer.setDocument(dom, urlString);
        this.renderer.layout();
        this.traverse((Box)this.renderer.getRootBox(), null);
        return this.imports.getContent();
    }

    public List<Object> convert(String content, String baseUrl) throws Docx4JException {
        Document dom;
        int firstChar = content.codePointAt(0);
        if (firstChar == 65279) {
            log.info("Removing BOM..");
            content = content.substring(1);
        }
        this.renderer = this.getRenderer();
        InputSource is = new InputSource(new BufferedReader(new StringReader(content)));
        try {
            dom = XMLResource.load((InputSource)is).getDocument();
        }
        catch (XRRuntimeException xre) {
            Throwable t = xre.getCause();
            log.error(t.getMessage(), t);
            if (t instanceof TransformerException) {
                Throwable t2 = ((TransformerException)t).getCause();
                if (t2 instanceof SAXParseException) {
                    throw new Docx4JException("issues at Line " + ((SAXParseException)t2).getLineNumber() + ", Col " + ((SAXParseException)t2).getColumnNumber(), t);
                }
                throw new Docx4JException(((TransformerException)t).getLocationAsString(), t);
            }
            throw xre;
        }
        this.renderer.setDocument(dom, baseUrl);
        this.renderer.layout();
        this.traverse((Box)this.renderer.getRootBox(), null);
        return this.imports.getContent();
    }

    private Map<String, CSSValue> getCascadedProperties(CalculatedStyle cs) {
        HashMap<String, CSSValue> cssMap = new HashMap<String, CSSValue>();
        FSDerivedValue[] derivedValues = cs.getDerivedValues();
        for (int i = 0; i < derivedValues.length; ++i) {
            CSSName name = CSSName.getByID((int)i);
            if (name.toString().startsWith("-fs") || cssWhiteList != null && !cssWhiteList.contains(name.toString())) continue;
            FSDerivedValue val = cs.valueByName(name);
            if (val != null && val instanceof DerivedValue) {
                cssMap.put(name.toString(), ((DerivedValue)val).getCSSPrimitiveValue());
                continue;
            }
            if (val != null && val instanceof IdentValue) {
                cssMap.put(name.toString(), ((IdentValue)val).getCSSPrimitiveValue());
                continue;
            }
            if (val != null && val instanceof LengthValue) {
                cssMap.put(name.toString(), ((LengthValue)val).getCSSPrimitiveValue());
                continue;
            }
            if (val == null) continue;
        }
        return cssMap;
    }

    private void pushBlockStack(ContentAccessor ca) {
        this.contentContextStack.push(ca);
        this.attachmentPointP = null;
    }

    private ContentAccessor popBlockStack() {
        this.attachmentPointP = null;
        return this.contentContextStack.pop();
    }

    private P getCurrentParagraph(boolean create) {
        if (this.attachmentPointP != null) {
            return this.attachmentPointP;
        }
        if (create) {
            P newP;
            this.attachmentPointP = newP = Context.getWmlObjectFactory().createP();
            this.contentContextStack.peek().getContent().add(newP);
            this.paraStillEmpty = true;
            return newP;
        }
        return null;
    }

    private ContentAccessor getListForRun() {
        if (this.attachmentPointH != null) {
            return this.attachmentPointH;
        }
        return this.getCurrentParagraph(true);
    }

    private void traverse(Box box, TableProperties tableProperties) throws Docx4JException {
        this.setDefaultFontSize();
        this.traverse(box, null, tableProperties);
        this.unsetDefaultFontSize();
    }

    private void traverse(Box box, Box parent, TableProperties tableProperties) throws Docx4JException {
        boolean mustPop = false;
        log.debug(box.getClass().getName());
        if (box instanceof BlockBox) {
            Tc tc;
            BlockBox blockBox = (BlockBox)box;
            Element e = box.getElement();
            if (e == null) {
                log.debug("<NULL>");
            } else {
                log.debug("BB<" + e.getNodeName() + " " + box.getStyle().toStringMine());
                log.debug(box.getStyle().getDisplayMine());
                Map<String, CSSValue> cssMap = this.getCascadedProperties(box.getStyle());
                if (!box.getStyle().getDisplayMine().equals("inline")) {
                    P currentP;
                    Tbl tbl;
                    ContentAccessor contentContext;
                    if (e.getNodeName().equals("ol") || e.getNodeName().equals("ul")) {
                        log.info("entering list");
                        this.listHelper.pushListStack(blockBox);
                    } else if (box instanceof TableSectionBox) {
                        log.debug(".. processing <tbody");
                    } else if (box instanceof TableBox) {
                        log.debug(".. processing table");
                        contentContext = this.contentContextStack.peek();
                        this.nestedTableHierarchyFix(contentContext, parent);
                        tbl = Context.getWmlObjectFactory().createTbl();
                        contentContext.getContent().add(tbl);
                        this.paraStillEmpty = true;
                        this.pushBlockStack((ContentAccessor)tbl);
                        mustPop = true;
                        TableBox tableBox = (TableBox)box;
                        tableProperties = new TableProperties();
                        tableProperties.setTableBox(tableBox);
                        this.setupTblPr(tableBox, tbl, tableProperties);
                        this.setupTblGrid(tableBox, tbl, tableProperties);
                    } else if (e.getNodeName().equals("table")) {
                        log.warn("Encountered non-TableBox table: " + box.getClass().getName());
                        contentContext = this.contentContextStack.peek();
                        this.nestedTableHierarchyFix(contentContext, parent);
                        tbl = Context.getWmlObjectFactory().createTbl();
                        contentContext.getContent().add(tbl);
                        this.paraStillEmpty = true;
                        this.pushBlockStack((ContentAccessor)tbl);
                        mustPop = true;
                    } else if (box instanceof TableRowBox) {
                        log.debug(".. processing <tr");
                        Tr tr = Context.getWmlObjectFactory().createTr();
                        this.contentContextStack.peek().getContent().add(tr);
                        this.paraStillEmpty = true;
                        this.pushBlockStack((ContentAccessor)tr);
                        mustPop = true;
                        this.setupTrPr((TableRowBox)box, tr);
                    } else if (box instanceof TableCellBox) {
                        log.debug(".. processing <td");
                        ContentAccessor trContext = this.contentContextStack.peek();
                        TableCellBox tcb = (TableCellBox)box;
                        if (tcb.getParent().getChild(0) == tcb && tcb.getCol() > 0) {
                            this.insertDummyVMergedCells(this.contentContextStack.peek(), tcb, true);
                        }
                        Tc tc2 = Context.getWmlObjectFactory().createTc();
                        this.contentContextStack.peek().getContent().add(tc2);
                        this.pushBlockStack((ContentAccessor)tc2);
                        mustPop = true;
                        this.setupTcPr(tcb, tc2, tableProperties);
                        this.insertDummyVMergedCells(trContext, tcb, false);
                    } else if (this.isListItem(blockBox.getElement())) {
                        currentP = this.getCurrentParagraph(true);
                        PPr pPr = Context.getWmlObjectFactory().createPPr();
                        currentP.setPPr(pPr);
                        if (this.paragraphFormatting.equals((Object)FormattingOption.IGNORE_CLASS)) {
                            this.listHelper.addNumbering(this.getCurrentParagraph(true), blockBox.getElement(), cssMap);
                            this.addParagraphProperties(pPr, (Styleable)blockBox, cssMap);
                        } else if (this.listHelper.peekListStack().getElement() != null && this.listHelper.peekListStack().getElement().getAttribute("class") != null) {
                            String cssClass = this.listHelper.peekListStack().getElement().getAttribute("class").trim();
                            if (cssClass.equals("")) {
                                if (this.paragraphFormatting.equals((Object)FormattingOption.CLASS_PLUS_OTHER)) {
                                    this.listHelper.addNumbering(this.getCurrentParagraph(true), blockBox.getElement(), cssMap);
                                    this.addParagraphProperties(pPr, (Styleable)blockBox, cssMap);
                                }
                            } else {
                                Style s;
                                int pos = cssClass.indexOf(" ");
                                if (pos > -1) {
                                    cssClass = cssClass.substring(0, pos);
                                }
                                if ((s = this.stylesByID.get(cssClass)) == null) {
                                    log.debug("No docx style for @class='" + cssClass + "'");
                                    if (this.paragraphFormatting.equals((Object)FormattingOption.CLASS_PLUS_OTHER)) {
                                        this.listHelper.addNumbering(this.getCurrentParagraph(true), blockBox.getElement(), cssMap);
                                        this.addParagraphProperties(pPr, (Styleable)blockBox, cssMap);
                                    }
                                } else if (s.getType() != null && s.getType().equals("numbering")) {
                                    log.debug("Using list style from @class='" + cssClass + "'");
                                    BigInteger numId = s.getPPr().getNumPr().getNumId().getVal();
                                    this.listHelper.setNumbering(pPr, numId);
                                    if (this.paragraphFormatting.equals((Object)FormattingOption.CLASS_PLUS_OTHER)) {
                                        this.addParagraphProperties(pPr, (Styleable)blockBox, cssMap);
                                    }
                                } else {
                                    log.debug("For docx style for @class='" + cssClass + "', but its not a paragraph style ");
                                    if (this.paragraphFormatting.equals((Object)FormattingOption.CLASS_PLUS_OTHER)) {
                                        this.listHelper.addNumbering(this.getCurrentParagraph(true), blockBox.getElement(), cssMap);
                                        this.addParagraphProperties(pPr, (Styleable)blockBox, cssMap);
                                    }
                                }
                            }
                        } else if (this.paragraphFormatting.equals((Object)FormattingOption.CLASS_PLUS_OTHER)) {
                            this.addParagraphProperties(pPr, (Styleable)blockBox, cssMap);
                        }
                    } else if (e.getNodeName().equals("img")) {
                        this.addImage(blockBox);
                    } else {
                        currentP = this.getCurrentParagraph(true);
                        currentP.setPPr(this.getPPr(blockBox, cssMap));
                    }
                }
            }
            log.debug("Processing children of " + box.getElement().getNodeName());
            switch (blockBox.getChildrenContentType()) {
                case 2: {
                    log.debug(".. which are BlockBox.CONTENT_BLOCK");
                    for (Object o : ((BlockBox)box).getChildren()) {
                        log.debug("   processing child " + o.getClass().getName());
                        this.traverse((Box)o, box, tableProperties);
                        log.debug(".. processed child " + o.getClass().getName());
                    }
                    break;
                }
                case 1: {
                    log.debug(".. which are BlockBox.CONTENT_INLINE");
                    if (((BlockBox)box).getInlineContent() == null) break;
                    for (Object o : ((BlockBox)box).getInlineContent()) {
                        if (o instanceof InlineBox) {
                            this.processInlineBox((InlineBox)o);
                        } else if (o instanceof BlockBox) {
                            this.traverse((Box)o, box, tableProperties);
                        } else {
                            log.debug("What to do with " + box.getClass().getName());
                        }
                        log.debug(".. processed child " + o.getClass().getName());
                    }
                    if (this.markuprange == null) break;
                    this.getCurrentParagraph(true).getContent().add(this.markuprange);
                    this.markuprange = null;
                }
            }
            log.debug("Done processing children of " + box.getClass().getName());
            if (e.getNodeName().equals("ol") || e.getNodeName().equals("ul")) {
                log.info(".. exiting list");
                this.listHelper.popListStack();
            }
            if (this.contentContextStack.peek() instanceof Tc && ((tc = (Tc)this.contentContextStack.peek()).getContent().size() == 0 || tc.getContent().get(tc.getContent().size() - 1) instanceof Tbl)) {
                tc.getContent().add(Context.getWmlObjectFactory().createP());
            }
            if (!e.getNodeName().equals("img")) {
                this.attachmentPointP = null;
                if (mustPop) {
                    this.popBlockStack();
                }
            }
        } else if (box instanceof AnonymousBlockBox) {
            log.debug("AnonymousBlockBox");
        }
    }

    protected PPr getPPr(BlockBox blockBox, Map<String, CSSValue> cssMap) {
        PPr pPr = Context.getWmlObjectFactory().createPPr();
        this.populatePPr(pPr, blockBox, cssMap);
        return pPr;
    }

    protected void populatePPr(PPr pPr, BlockBox blockBox, Map<String, CSSValue> cssMap) {
        if (this.paragraphFormatting.equals((Object)FormattingOption.IGNORE_CLASS)) {
            this.addParagraphProperties(pPr, (Styleable)blockBox, cssMap);
        } else {
            String cssClass;
            if (blockBox.getElement() != null && blockBox.getElement().getAttribute("class") != null && !(cssClass = blockBox.getElement().getAttribute("class").trim()).equals("")) {
                Style s;
                int pos = cssClass.indexOf(" ");
                if (pos > -1) {
                    cssClass = cssClass.substring(0, pos);
                }
                if ((s = this.stylesByID.get(cssClass)) == null) {
                    log.debug("No docx style for @class='" + cssClass + "'");
                } else if (s.getType() != null && s.getType().equals("paragraph")) {
                    PPrBase.PStyle pStyle = Context.getWmlObjectFactory().createPPrBasePStyle();
                    pPr.setPStyle(pStyle);
                    pStyle.setVal(cssClass);
                } else {
                    log.debug("For docx style for @class='" + cssClass + "', but its not a paragraph style ");
                }
            }
            if (this.paragraphFormatting.equals((Object)FormattingOption.CLASS_PLUS_OTHER)) {
                this.addParagraphProperties(pPr, (Styleable)blockBox, cssMap);
            }
        }
    }

    protected void setupTblPr(TableBox cssTable, Tbl tbl, TableProperties tableProperties) {
        Element e = cssTable.getElement();
        TblPr tblPr = Context.getWmlObjectFactory().createTblPr();
        tbl.setTblPr(tblPr);
        String cssClass = null;
        if (e.getAttribute("class") != null) {
            cssClass = e.getAttribute("class").trim();
            this.setTableStyle(tblPr, cssClass);
        }
        TblBorders borders = Context.getWmlObjectFactory().createTblBorders();
        borders.setTop(this.copyBorderStyle((Box)cssTable, "top", true));
        borders.setBottom(this.copyBorderStyle((Box)cssTable, "bottom", true));
        borders.setLeft(this.copyBorderStyle((Box)cssTable, "left", true));
        borders.setRight(this.copyBorderStyle((Box)cssTable, "right", true));
        borders.setInsideH(this.createBorderStyle(STBorder.NONE, null, null));
        borders.setInsideV(this.createBorderStyle(STBorder.NONE, null, null));
        tblPr.setTblBorders(borders);
        TblWidth spacingWidth = Context.getWmlObjectFactory().createTblWidth();
        if (cssTable.getStyle().isCollapseBorders()) {
            spacingWidth.setW(BigInteger.ZERO);
            spacingWidth.setType("auto");
        } else {
            int cssSpacing = cssTable.getStyle().getBorderHSpacing((CssContext)this.renderer.getLayoutContext());
            spacingWidth.setW(BigInteger.valueOf(cssSpacing / 2));
            spacingWidth.setType("dxa");
        }
        tblPr.setTblCellSpacing(spacingWidth);
        if (cssTable.getMargin() != null && cssTable.getMargin().left() > 0.0f) {
            log.debug("Calculating TblInd from margin.left: " + cssTable.getMargin().left());
            TblWidth tblIW = Context.getWmlObjectFactory().createTblWidth();
            tblIW.setW(BigInteger.valueOf(Math.round(cssTable.getMargin().left())));
            tblIW.setType("dxa");
            tblPr.setTblInd(tblIW);
        } else {
            CTBorder leftBorder = borders.getLeft();
            if (leftBorder != null && leftBorder.getVal() != null && leftBorder.getVal() != STBorder.NONE && leftBorder.getVal() != STBorder.NIL) {
                log.debug("applying fix to align left edge of table with text");
                TblWidth tblIW = Context.getWmlObjectFactory().createTblWidth();
                tblIW.setW(BigInteger.valueOf(115L));
                tblIW.setType("dxa");
                tblPr.setTblInd(tblIW);
            }
        }
        TblWidth tblW = Context.getWmlObjectFactory().createTblWidth();
        tblW.setW(BigInteger.ZERO);
        tblW.setType("auto");
        tblPr.setTblW(tblW);
        if (cssTable.getStyle().isIdent(CSSName.TABLE_LAYOUT, IdentValue.AUTO) || cssTable.getStyle().isAutoWidth()) {
            tableProperties.setFixedWidth(false);
        } else {
            tableProperties.setFixedWidth(true);
            CTTblLayoutType tblLayout = Context.getWmlObjectFactory().createCTTblLayoutType();
            tblLayout.setType(STTblLayoutType.FIXED);
            tblPr.setTblLayout(tblLayout);
        }
    }

    protected void setupTblGrid(TableBox cssTable, Tbl tbl, TableProperties tableProperties) {
        TblGrid tblGrid = Context.getWmlObjectFactory().createTblGrid();
        tbl.setTblGrid(tblGrid);
        int[] colPos = tableProperties.getColumnPos();
        for (int i = 1; i <= cssTable.numEffCols(); ++i) {
            TblGridCol tblGridCol = Context.getWmlObjectFactory().createTblGridCol();
            tblGrid.getGridCol().add(tblGridCol);
            log.debug("colpos=" + colPos[i]);
            tblGridCol.setW(BigInteger.valueOf(colPos[i] - colPos[i - 1]));
        }
    }

    protected void setupTrPr(TableRowBox trBox, Tr tr) {
    }

    protected void setupTcPr(TableCellBox tcb, Tc tc, TableProperties tableProperties) {
        FSColor fsColor;
        int effCol = tcb.getTable().colToEffCol(tcb.getCol());
        TcPr tcPr = Context.getWmlObjectFactory().createTcPr();
        tc.setTcPr(tcPr);
        if (tcb.getStyle().getRowSpan() > 1) {
            TcPrInner.VMerge vm = Context.getWmlObjectFactory().createTcPrInnerVMerge();
            vm.setVal("restart");
            tcPr.setVMerge(vm);
        }
        try {
            TblWidth tblW = Context.getWmlObjectFactory().createTblWidth();
            tblW.setW(BigInteger.valueOf(tableProperties.getColumnWidth(effCol + 1)));
            tblW.setType("dxa");
            tcPr.setTcW(tblW);
        }
        catch (ArrayIndexOutOfBoundsException aioob) {
            log.error("Problem with getColumnWidth for col" + (effCol + 1));
        }
        int colspan = tcb.getStyle().getColSpan();
        if (colspan > 1) {
            TcPr tcPr2 = tc.getTcPr();
            if (tcPr2 == null) {
                tcPr2 = Context.getWmlObjectFactory().createTcPr();
                tc.setTcPr(tcPr2);
            }
            TcPrInner.GridSpan gs = Context.getWmlObjectFactory().createTcPrInnerGridSpan();
            gs.setVal(BigInteger.valueOf(colspan));
            tcPr2.setGridSpan(gs);
            this.setCellWidthAuto(tcPr2);
        }
        if ((fsColor = tcb.getStyle().getBackgroundColor()) != null && fsColor instanceof FSRGBColor) {
            FSRGBColor rgbResult = (FSRGBColor)fsColor;
            CTShd shd = Context.getWmlObjectFactory().createCTShd();
            shd.setFill(UnitsOfMeasurement.rgbTripleToHex((float)rgbResult.getRed(), (float)rgbResult.getGreen(), (float)rgbResult.getBlue()));
            tcPr.setShd(shd);
        }
        tcPr.setTcBorders(this.copyCellBorderStyles(tcb));
    }

    private CTBorder copyBorderStyle(Box box, String side, boolean keepNone) {
        STBorder stBorder;
        FSDerivedValue borderStyle = box.getStyle().valueByName(CSSName.getByPropertyName((String)("border-" + side + "-style")));
        FSDerivedValue borderColor = box.getStyle().valueByName(CSSName.getByPropertyName((String)("border-" + side + "-color")));
        float width = box.getStyle().getFloatPropertyProportionalHeight(CSSName.getByPropertyName((String)("border-" + side + "-width")), 0.0f, (CssContext)this.renderer.getLayoutContext());
        if (borderStyle.asIdentValue() == IdentValue.NONE || width == 0.0f) {
            return keepNone ? this.createBorderStyle(STBorder.NONE, null, null) : null;
        }
        if (borderStyle.asIdentValue() == IdentValue.HIDDEN) {
            return this.createBorderStyle(STBorder.NONE, "FFFFFF", BigInteger.ZERO);
        }
        if (borderStyle.asIdentValue() == IdentValue.DOUBLE) {
            width /= 3.0f;
        }
        try {
            stBorder = STBorder.fromValue((String)borderStyle.asString());
        }
        catch (IllegalArgumentException e) {
            stBorder = STBorder.SINGLE;
        }
        width = UnitsOfMeasurement.twipToPoint((int)Math.round(width)) * 8.0f;
        String color = borderColor.asString();
        return this.createBorderStyle(stBorder, color, BigInteger.valueOf(Math.round(width)));
    }

    private CTBorder createBorderStyle(STBorder val, String color, BigInteger sz) {
        CTBorder border = Context.getWmlObjectFactory().createCTBorder();
        border.setVal(val);
        border.setColor(color);
        border.setSz(sz);
        return border;
    }

    private TcPrInner.TcBorders copyCellBorderStyles(TableCellBox box) {
        TcPrInner.TcBorders tcBorders = Context.getWmlObjectFactory().createTcPrInnerTcBorders();
        tcBorders.setTop(this.copyBorderStyle((Box)box, "top", false));
        tcBorders.setBottom(this.copyBorderStyle((Box)box, "bottom", false));
        tcBorders.setLeft(this.copyBorderStyle((Box)box, "left", false));
        tcBorders.setRight(this.copyBorderStyle((Box)box, "right", false));
        return tcBorders;
    }

    private void insertDummyVMergedCells(ContentAccessor trContext, TableCellBox tcb, boolean backwards) {
        log.debug("Scanning cells from " + tcb.getRow() + ", " + tcb.getCol() + " to the " + (backwards ? "left" : "right"));
        ArrayList<TableCellBox> adjCells = new ArrayList<TableCellBox>();
        int numEffCols = tcb.getTable().numEffCols();
        for (int i = tcb.getCol(); i >= 0 && i < numEffCols; i += backwards ? -1 : 1) {
            TableCellBox adjCell = tcb.getSection().cellAt(tcb.getRow(), i);
            if (adjCell == null) {
                log.error("XHTML table import: Null adjCell for row " + tcb.getRow() + ", col " + tcb.getCol() + " at col " + i);
                break;
            }
            if (adjCell == tcb || adjCell == TableCellBox.SPANNING_CELL) continue;
            log.debug("Got adjCell, it is  " + adjCell.getRow() + ", " + adjCell.getCol());
            if (adjCell.getRow() >= tcb.getRow() || adjCell.getStyle() == null || adjCell.getStyle().getRowSpan() <= 1) break;
            adjCells.add(adjCell);
        }
        if (backwards && !adjCells.isEmpty()) {
            Collections.reverse(adjCells);
        }
        for (TableCellBox adjCell : adjCells) {
            Tc dummy = Context.getWmlObjectFactory().createTc();
            trContext.getContent().add(dummy);
            TcPr tcPr = Context.getWmlObjectFactory().createTcPr();
            dummy.setTcPr(tcPr);
            TcPrInner.VMerge vm = Context.getWmlObjectFactory().createTcPrInnerVMerge();
            tcPr.setVMerge(vm);
            int colspan = adjCell.getStyle().getColSpan();
            if (colspan > 1) {
                TcPrInner.GridSpan gs = Context.getWmlObjectFactory().createTcPrInnerGridSpan();
                gs.setVal(BigInteger.valueOf(colspan));
                tcPr.setGridSpan(gs);
            }
            TcPrInner.TcBorders borders = this.copyCellBorderStyles(adjCell);
            borders.setTop(this.createBorderStyle(STBorder.NIL, null, null));
            tcPr.setTcBorders(borders);
            this.setCellWidthAuto(tcPr);
            dummy.getContent().add(new P());
        }
    }

    private void nestedTableHierarchyFix(ContentAccessor contentContext, Box parent) {
        if (parent == null) {
            return;
        }
        if (parent instanceof TableBox || parent.getElement().getNodeName().equals("table")) {
            log.warn("table: Constructing missing w:tr/w:td..");
            P captionP = null;
            for (int i = 0; i < contentContext.getContent().size(); ++i) {
                Object next = contentContext.getContent().get(i);
                if (!(next instanceof P)) continue;
                captionP = (P)XmlUtils.deepCopy((Object)((P)next));
                contentContext.getContent().remove(i);
                break;
            }
            TblPr tblPr = Context.getWmlObjectFactory().createTblPr();
            contentContext.getContent().add(tblPr);
            String cssClass = null;
            if (parent.getElement().getAttribute("class") != null) {
                cssClass = parent.getElement().getAttribute("class").trim();
            }
            this.setTableStyle(tblPr, cssClass);
            Tr tr = Context.getWmlObjectFactory().createTr();
            contentContext.getContent().add(tr);
            contentContext = tr;
            Tc tc = Context.getWmlObjectFactory().createTc();
            contentContext.getContent().add(tc);
            contentContext = tc;
            if (captionP != null) {
                contentContext.getContent().add(captionP);
            }
        }
    }

    private void setTableStyle(TblPr tblPr, String cssClass) {
        if (!this.tableFormatting.equals((Object)FormattingOption.IGNORE_CLASS) && cssClass != null && !cssClass.equals("")) {
            Style s;
            int pos = cssClass.indexOf(" ");
            if (pos > -1) {
                cssClass = cssClass.substring(0, pos);
            }
            if ((s = this.stylesByID.get(cssClass)) == null) {
                log.debug("No docx style for @class='" + cssClass + "'");
            } else if (s.getType() != null && s.getType().equals("table")) {
                CTTblPrBase.TblStyle tblStyle = Context.getWmlObjectFactory().createCTTblPrBaseTblStyle();
                tblPr.setTblStyle(tblStyle);
                tblStyle.setVal(cssClass);
            } else {
                log.debug("For docx style for @class='" + cssClass + "', but its not a table style ");
            }
        }
    }

    private void setCellWidthAuto(TcPr tcPr) {
        TblWidth tblW = Context.getWmlObjectFactory().createTblWidth();
        tblW.setW(BigInteger.ZERO);
        tblW.setType("auto");
        tcPr.setTcW(tblW);
    }

    private void addImage(BlockBox box) {
        Long cx = box.getStyle().valueByName(CSSName.WIDTH) == IdentValue.AUTO ? null : Long.valueOf(UnitsOfMeasurement.twipToEMU((double)box.getWidth()));
        Long cy = box.getStyle().valueByName(CSSName.HEIGHT) == IdentValue.AUTO ? null : Long.valueOf(UnitsOfMeasurement.twipToEMU((double)box.getHeight()));
        this.xHTMLImageHandler.addImage(this.renderer.getDocx4jUserAgent(), this.wordMLPackage, this.getCurrentParagraph(true), box.getElement(), cx, cy);
        this.paraStillEmpty = false;
    }

    private void storeBookmarkEnd() {
        this.markuprange = Context.getWmlObjectFactory().createCTMarkupRange();
        JAXBElement markuprangeWrapped = Context.getWmlObjectFactory().createPBookmarkEnd(this.markuprange);
        this.markuprange.setId(BigInteger.valueOf(this.bookmarkId.getAndIncrement()));
    }

    private void processInlineBox(InlineBox inlineBox) {
        InlineBox s = inlineBox;
        if (log.isDebugEnabled()) {
            log.debug(inlineBox.toString());
            if (s.getElement() == null) {
                log.debug("Null element name");
            } else {
                log.debug(s.getElement().getNodeName());
            }
        }
        if (s.getStyle() == null) {
            log.error("getStyle returned null!");
        }
        if (s.getElement() != null && s.getElement().getNodeName().equals("a") && inlineBox.isStartsHere() && !inlineBox.getElement().hasChildNodes()) {
            log.debug("anchor which starts and ends here");
            String name = s.getElement().getAttribute("name");
            String href = s.getElement().getAttribute("href");
            if (name != null && !name.trim().equals("")) {
                log.debug("[NAMED ANCHOR] " + name);
                CTBookmark bookmark = Context.getWmlObjectFactory().createCTBookmark();
                JAXBElement bookmarkWrapped = Context.getWmlObjectFactory().createPBookmarkStart(bookmark);
                this.getCurrentParagraph(true).getContent().add(bookmarkWrapped);
                bookmark.setName(name);
                bookmark.setId(BigInteger.valueOf(this.bookmarkId.get()));
                this.storeBookmarkEnd();
                this.getCurrentParagraph(true).getContent().add(this.markuprange);
                this.markuprange = null;
                this.paraStillEmpty = false;
            }
            if (href != null && !href.trim().equals("")) {
                log.warn("Ignoring @href on <a> without content.");
            }
            return;
        }
        Map<String, CSSValue> cssMap = this.getCascadedProperties(s.getStyle());
        P p = this.getCurrentParagraph(true);
        if (p.getPPr() == null) {
            PPr pPr = Context.getWmlObjectFactory().createPPr();
            this.addParagraphProperties(pPr, (Styleable)s, cssMap);
            p.setPPr(pPr);
        }
        String debug = "<UNKNOWN Styleable";
        if (s.getElement() != null) {
            debug = "<" + s.getElement().getNodeName();
            String cssClass = this.getClassAttribute(s.getElement());
            if (cssClass != null) {
                cssClass = cssClass.trim();
            }
            if (s.getElement().getNodeName().equals("a")) {
                if (inlineBox.isStartsHere()) {
                    log.debug("Processing <a>... ");
                    String name = s.getElement().getAttribute("name");
                    String href = s.getElement().getAttribute("href");
                    if (name != null && !name.trim().equals("")) {
                        log.debug("NAMED ANCHOR " + name);
                        CTBookmark bookmark = Context.getWmlObjectFactory().createCTBookmark();
                        JAXBElement bookmarkWrapped = Context.getWmlObjectFactory().createPBookmarkStart(bookmark);
                        this.getCurrentParagraph(true).getContent().add(bookmarkWrapped);
                        this.paraStillEmpty = false;
                        bookmark.setName(name);
                        bookmark.setId(BigInteger.valueOf(this.bookmarkId.get()));
                        this.storeBookmarkEnd();
                        if (href == null || href.trim().equals("")) {
                            String theText = inlineBox.getElement().getTextContent();
                            this.addRun(cssClass, cssMap, theText);
                            return;
                        }
                    }
                    if (href != null && !href.trim().equals("")) {
                        P.Hyperlink h = null;
                        String linkText = inlineBox.getElement().getTextContent();
                        RPr rPr = Context.getWmlObjectFactory().createRPr();
                        this.formatRPr(rPr, cssClass, cssMap);
                        log.debug(linkText);
                        if (linkText != null && !linkText.trim().equals("")) {
                            h = this.createHyperlink(href, rPr, inlineBox.getText(), this.rp);
                            this.getCurrentParagraph(true).getContent().add(h);
                            this.paraStillEmpty = false;
                            if (inlineBox.isEndsHere()) {
                                log.debug("Processing ..</a> (ends here as well) ");
                                return;
                            }
                            this.attachmentPointH = h;
                            return;
                        }
                        log.warn("Expected hyperlink content, since tag not self-closing");
                        h = this.createHyperlink(href, rPr, href, this.rp);
                        this.getCurrentParagraph(true).getContent().add(h);
                        this.paraStillEmpty = false;
                        return;
                    }
                } else {
                    if (inlineBox.isEndsHere()) {
                        log.debug("Processing ..</a> ");
                        this.attachmentPointH = null;
                        return;
                    }
                    log.debug("Processing <a> content!");
                }
            }
        }
        if (s.getStyle() != null) {
            debug = debug + " " + s.getStyle().toStringMine();
        }
        log.debug(debug);
        this.processInlineBoxContent(inlineBox, (Styleable)s, cssMap);
    }

    private void processInlineBoxContent(InlineBox inlineBox, Styleable s, Map<String, CSSValue> cssMap) {
        if (inlineBox.getTextNode() == null) {
            if (s.getElement().getNodeName().equals("br")) {
                R run = Context.getWmlObjectFactory().createR();
                this.getListForRun().getContent().add(run);
                run.getContent().add(Context.getWmlObjectFactory().createBr());
            } else {
                log.debug("InlineBox has no TextNode, so skipping");
            }
        } else {
            log.debug(inlineBox.getTextNode().getTextContent());
            String theText = inlineBox.getTextNode().getTextContent();
            log.debug("Processing " + theText);
            this.paraStillEmpty = false;
            String cssClass = this.getClassAttribute(s.getElement());
            if (cssClass != null) {
                cssClass = cssClass.trim();
            }
            this.addRun(cssClass, cssMap, theText);
        }
    }

    private String getClassAttribute(Element e) {
        if (e == null) {
            return null;
        }
        if (e.getAttribute("class") != null && !e.getAttribute("class").trim().equals("")) {
            return e.getAttribute("class");
        }
        if (e.getParentNode() instanceof Element) {
            return this.getClassAttribute((Element)e.getParentNode());
        }
        return null;
    }

    private void addRun(String cssClass, Map<String, CSSValue> cssMap, String theText) {
        R run = Context.getWmlObjectFactory().createR();
        Text text = Context.getWmlObjectFactory().createText();
        text.setValue(theText);
        if (theText.startsWith(" ") || theText.endsWith(" ")) {
            text.setSpace("preserve");
        }
        run.getContent().add(text);
        this.getListForRun().getContent().add(run);
        RPr rPr = Context.getWmlObjectFactory().createRPr();
        run.setRPr(rPr);
        this.formatRPr(rPr, cssClass, cssMap);
    }

    private void formatRPr(RPr rPr, String cssClass, Map<String, CSSValue> cssMap) {
        this.addRunProperties(rPr, cssMap);
        if (this.runFormatting.equals((Object)FormattingOption.IGNORE_CLASS)) {
            this.addRunProperties(rPr, cssMap);
        } else {
            if (cssClass != null && !cssClass.equals("")) {
                Style s;
                int pos = cssClass.indexOf(" ");
                if (pos > -1) {
                    cssClass = cssClass.substring(0, pos);
                }
                if ((s = this.stylesByID.get(cssClass)) == null) {
                    log.debug("No docx style for @class='" + cssClass + "'");
                } else if (s.getType() != null && s.getType().equals("character")) {
                    RStyle rStyle = Context.getWmlObjectFactory().createRStyle();
                    rPr.setRStyle(rStyle);
                    rStyle.setVal(cssClass);
                } else {
                    log.debug("For docx style for @class='" + cssClass + "', but its not a character style ");
                }
            }
            if (this.runFormatting.equals((Object)FormattingOption.CLASS_PLUS_OTHER)) {
                this.addRunProperties(rPr, cssMap);
            }
        }
        CSSValue fontFamily = cssMap.get("font-family");
        this.setRFont(fontFamily, rPr);
    }

    private void setRFont(CSSValue fontFamily, RPr rpr) {
        if (fontFamily == null) {
            return;
        }
        RFonts rfonts = this.fontFamiliesToFont.get(fontFamily.getCssText());
        if (rfonts != null) {
            rpr.setRFonts(rfonts);
            return;
        }
        StringTokenizer st = new StringTokenizer(fontFamily.getCssText(), ",");
        while (st.hasMoreTokens()) {
            String thisFontFamily = st.nextToken().trim();
            RFonts mappedTo = fontFamilyToFont.get(thisFontFamily);
            if (mappedTo == null) continue;
            rpr.setRFonts(mappedTo);
            this.fontFamiliesToFont.put(fontFamily.getCssText(), mappedTo);
            return;
        }
    }

    private boolean isListItem(Element e) {
        return e.getNodeName().equals("li");
    }

    private void addParagraphProperties(PPr pPr, Styleable styleable, Map cssMap) {
        for (Object o : cssMap.keySet()) {
            CSSValue cssValue;
            String cssName = (String)o;
            Property p = PropertyFactory.createPropertyFromCssName((String)cssName, (CSSValue)(cssValue = (CSSValue)cssMap.get(cssName)));
            if (p == null) continue;
            if (p instanceof AbstractParagraphProperty) {
                ((AbstractParagraphProperty)p).set(pPr);
                continue;
            }
            p = PropertyFactory.createPropertyFromCssNameForPPr((String)cssName, (CSSValue)cssValue);
            if (p == null || !(p instanceof AbstractParagraphProperty)) continue;
            ((AbstractParagraphProperty)p).set(pPr);
        }
        if (styleable.getElement() != null && this.isListItem(styleable.getElement())) {
            int defaultInd;
            int totalPadding = 0;
            LengthValue padding = (LengthValue)styleable.getStyle().valueByName(CSSName.PADDING_LEFT);
            totalPadding += Indent.getTwip((CSSPrimitiveValue)padding.getCSSPrimitiveValue());
            LengthValue margin = (LengthValue)styleable.getStyle().valueByName(CSSName.MARGIN_LEFT);
            totalPadding += Indent.getTwip((CSSPrimitiveValue)margin.getCSSPrimitiveValue());
            if ((totalPadding += this.listHelper.getAncestorIndentation()) == (defaultInd = 600 * this.listHelper.getDepth())) {
                log.debug("explicitly unsetting pPr indent");
                pPr.setInd(null);
            } else {
                pPr.setInd(this.listHelper.getInd(totalPadding));
            }
        }
        PPr stylePPr = null;
        PropertyResolver propertyResolver = this.wordMLPackage.getMainDocumentPart().getPropertyResolver();
        if (this.getCurrentParagraph(false).getPPr() != null && this.getCurrentParagraph(false).getPPr().getPStyle() != null) {
            String styleId = this.getCurrentParagraph(false).getPPr().getPStyle().getVal();
            stylePPr = propertyResolver.getEffectivePPr(styleId);
            PPrCleanser.removeRedundantProperties(stylePPr, pPr);
        }
        log.debug(XmlUtils.marshaltoString((Object)pPr, (boolean)true, (boolean)true));
    }

    private void addRunProperties(RPr rPr, Map cssMap) {
        String styleId;
        for (Object o : cssMap.keySet()) {
            CSSValue cssValue;
            String cssName = (String)o;
            Property runProp = PropertyFactory.createPropertyFromCssName((String)cssName, (CSSValue)(cssValue = (CSSValue)cssMap.get(cssName)));
            if (runProp == null || !(runProp instanceof AbstractRunProperty)) continue;
            ((AbstractRunProperty)runProp).set(rPr);
        }
        RPr styleRPr = null;
        PropertyResolver propertyResolver = this.wordMLPackage.getMainDocumentPart().getPropertyResolver();
        if (this.getCurrentParagraph(false).getPPr() != null && this.getCurrentParagraph(false).getPPr().getPStyle() != null) {
            styleId = this.getCurrentParagraph(false).getPPr().getPStyle().getVal();
            styleRPr = propertyResolver.getEffectiveRPr(styleId);
            RPrCleanser.removeRedundantProperties(styleRPr, rPr);
        }
        propertyResolver = this.wordMLPackage.getMainDocumentPart().getPropertyResolver();
        if (rPr.getRStyle() != null) {
            styleId = rPr.getRStyle().getVal();
            styleRPr = propertyResolver.getEffectiveRPr(styleId);
            RPrCleanser.removeRedundantProperties(styleRPr, rPr);
        }
    }

    private P.Hyperlink createHyperlink(String url, RPr rPr, String linkText, RelationshipsPart rp) {
        if (linkText.contains("&") && !linkText.contains("&amp;")) {
            linkText = linkText.replace("&", "&amp;");
        }
        try {
            ObjectFactory factory = new ObjectFactory();
            Relationship rel = factory.createRelationship();
            rel.setType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
            rel.setTarget(url);
            rel.setTargetMode("External");
            rp.addRelationship(rel);
            String hpl = "<w:hyperlink r:id=\"" + rel.getId() + "\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" " + "xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" >" + "<w:r>" + "<w:t>" + linkText + "</w:t>" + "</w:r>" + "</w:hyperlink>";
            P.Hyperlink hyperlink = (P.Hyperlink)XmlUtils.unmarshalString((String)hpl);
            R r = (R)hyperlink.getContent().get(0);
            r.setRPr(rPr);
            if (this.hyperlinkStyleId != null) {
                RStyle rStyle = Context.getWmlObjectFactory().createRStyle();
                rStyle.setVal(this.hyperlinkStyleId);
                rPr.setRStyle(rStyle);
            }
            return hyperlink;
        }
        catch (Exception e) {
            log.error("Dodgy link text: '" + linkText + "'", (Throwable)e);
            return null;
        }
    }

    public static final class TableProperties {
        private TableBox tableBox;
        private int[] colPos;
        boolean isFixedWidth;

        public TableBox getTableBox() {
            return this.tableBox;
        }

        public void setTableBox(TableBox tableBox) {
            this.tableBox = tableBox;
            this.colPos = tableBox.getColumnPos();
        }

        public int[] getColumnPos() {
            return this.colPos;
        }

        public int getColumnWidth(int col) {
            return this.colPos[col] - this.colPos[col - 1];
        }

        public boolean isFixedWidth() {
            return this.isFixedWidth;
        }

        public void setFixedWidth(boolean isFixedWidth) {
            this.isFixedWidth = isFixedWidth;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FontFamilyMap
    extends HashMap<String, RFonts> {
        private FontFamilyMap() {
        }

        @Override
        public RFonts put(String key, RFonts value) {
            return super.put(key.toLowerCase(), value);
        }

        public RFonts get(String key) {
            return (RFonts)super.get(key.toLowerCase());
        }
    }
}

