/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.util.HashMap;
import java.util.Map;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;

public class HeadingHandler {
    private Map<String, String> elementToStyleId = new HashMap<String, String>();
    private static final String HEADING_NAME_PREFIX = "heading ";

    protected HeadingHandler(Styles styles) {
        for (Style s : styles.getStyle()) {
            if (!s.getName().getVal().startsWith(HEADING_NAME_PREFIX)) continue;
            String styleName = s.getName().getVal();
            String suffix = styleName.substring(HEADING_NAME_PREFIX.length());
            try {
                int lvl = Integer.parseInt(suffix);
                if (lvl < 1 || lvl > 9) continue;
                this.elementToStyleId.put("h" + lvl, s.getStyleId());
            }
            catch (NumberFormatException nfe) {}
        }
    }

    protected String getStyle(String localname) {
        return this.elementToStyleId.get(localname);
    }
}

