/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.util.List;
import javax.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationAnchorTest {
    private WordprocessingMLPackage wordMLPackage;
    private final String PNG_IMAGE_DATA = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC";

    @Before
    public void setup() throws InvalidFormatException {
        this.wordMLPackage = WordprocessingMLPackage.createPackage();
    }

    private List<Object> convert(String xhtml) throws Docx4JException {
        XHTMLImporterImpl XHTMLImporter2 = new XHTMLImporterImpl(this.wordMLPackage);
        return XHTMLImporter2.convert(xhtml, "");
    }

    @Test
    public void bookmarkDiv() throws Docx4JException, JAXBException {
        String id = "mydiv";
        String content = "<div id=\"" + id + "\">foo</div>";
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(this.convert(content));
        System.out.println(this.wordMLPackage.getMainDocumentPart().getXML());
        List matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkStart", false);
        CTBookmark start = (CTBookmark)XmlUtils.unwrap(matches.get(0));
        Assert.assertTrue((boolean)start.getName().equals(id));
        matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkEnd", false);
        CTMarkupRange end = (CTMarkupRange)XmlUtils.unwrap(matches.get(0));
        Assert.assertEquals((Object)start.getId(), (Object)end.getId());
    }

    @Test
    public void bookmarkInDivP() throws Docx4JException, JAXBException {
        String id = "mydiv";
        String content = "<div><p  id=\"" + id + "\">foo</p>" + "</div>";
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(this.convert(content));
        System.out.println(this.wordMLPackage.getMainDocumentPart().getXML());
        List matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkStart", false);
        CTBookmark start = (CTBookmark)XmlUtils.unwrap(matches.get(0));
        Assert.assertTrue((boolean)start.getName().equals(id));
        matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkEnd", false);
        CTMarkupRange end = (CTMarkupRange)XmlUtils.unwrap(matches.get(0));
        Assert.assertEquals((Object)start.getId(), (Object)end.getId());
    }

    @Test
    public void bookmarkInP() throws Docx4JException, JAXBException {
        String id = "mydiv";
        String content = "<p>Hello <span id=\"" + id + "\">foo</span> done</p>";
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(this.convert(content));
        System.out.println(this.wordMLPackage.getMainDocumentPart().getXML());
        List matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkStart", false);
        CTBookmark start = (CTBookmark)XmlUtils.unwrap(matches.get(0));
        Assert.assertTrue((boolean)start.getName().equals(id));
        matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkEnd", false);
        CTMarkupRange end = (CTMarkupRange)XmlUtils.unwrap(matches.get(0));
        Assert.assertEquals((Object)start.getId(), (Object)end.getId());
    }

    @Test
    public void bookmarkInTable() throws Docx4JException, JAXBException {
        String id = "mydiv";
        String content = "<div><table id=\"" + id + "\"><tr><th>1</th></tr></table>" + "</div>";
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(this.convert(content));
        System.out.println(this.wordMLPackage.getMainDocumentPart().getXML());
        List matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkStart", false);
        CTBookmark start = (CTBookmark)XmlUtils.unwrap(matches.get(0));
        Assert.assertTrue((boolean)start.getName().equals(id));
        matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkEnd", false);
        CTMarkupRange end = (CTMarkupRange)XmlUtils.unwrap(matches.get(0));
        Assert.assertEquals((Object)start.getId(), (Object)end.getId());
    }

    @Test
    public void bookmarkInTr() throws Docx4JException, JAXBException {
        String id = "mydiv";
        String content = "<div><table><tr  id=\"" + id + "\"><th>1</th></tr></table>" + "</div>";
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(this.convert(content));
        System.out.println(this.wordMLPackage.getMainDocumentPart().getXML());
        List matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkStart", false);
        CTBookmark start = (CTBookmark)XmlUtils.unwrap(matches.get(0));
        Assert.assertTrue((boolean)start.getName().equals(id));
        matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkEnd", false);
        CTMarkupRange end = (CTMarkupRange)XmlUtils.unwrap(matches.get(0));
        Assert.assertEquals((Object)start.getId(), (Object)end.getId());
    }

    @Test
    public void bookmarkInTd() throws Docx4JException, JAXBException {
        String id = "mydiv";
        String content = "<div><table><tr><td  id=\"" + id + "\">1</td></tr></table>" + "</div>";
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(this.convert(content));
        System.out.println(this.wordMLPackage.getMainDocumentPart().getXML());
        List matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkStart", false);
        CTBookmark start = (CTBookmark)XmlUtils.unwrap(matches.get(0));
        Assert.assertTrue((boolean)start.getName().equals(id));
        matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkEnd", false);
        CTMarkupRange end = (CTMarkupRange)XmlUtils.unwrap(matches.get(0));
        Assert.assertEquals((Object)start.getId(), (Object)end.getId());
    }

    @Test
    public void bookmarkInTdP() throws Docx4JException, JAXBException {
        String id = "mydiv";
        String content = "<div><table><tr><td><p  id=\"" + id + "\">foo</p>" + "</td></tr></table>" + "</div>";
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(this.convert(content));
        System.out.println(this.wordMLPackage.getMainDocumentPart().getXML());
        List matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkStart", false);
        CTBookmark start = (CTBookmark)XmlUtils.unwrap(matches.get(0));
        Assert.assertTrue((boolean)start.getName().equals(id));
        matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkEnd", false);
        CTMarkupRange end = (CTMarkupRange)XmlUtils.unwrap(matches.get(0));
        Assert.assertEquals((Object)start.getId(), (Object)end.getId());
    }

    @Test
    public void bookmarkUL() throws Docx4JException, JAXBException {
        String id = "mydiv";
        String content = "<ul>  <li> Outer 1 </li> <li> Outer 2 </li>  <ul  id=\"" + id + "\">" + "   <li> Inner 1 </li>" + "  <li> Inner 2 </li>" + "</ul>" + " <li> Outer 3 </li>" + "</ul>";
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(this.convert(content));
        System.out.println(this.wordMLPackage.getMainDocumentPart().getXML());
        List matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkStart", false);
        CTBookmark start = (CTBookmark)XmlUtils.unwrap(matches.get(0));
        Assert.assertTrue((boolean)start.getName().equals(id));
        matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkEnd", false);
        CTMarkupRange end = (CTMarkupRange)XmlUtils.unwrap(matches.get(0));
        Assert.assertEquals((Object)start.getId(), (Object)end.getId());
    }

    @Test
    public void bookmarkLI() throws Docx4JException, JAXBException {
        String id = "mydiv";
        String content = "<ul>  <li> Outer 1 </li> <li> Outer 2 </li>  <ul >   <li  id=\"" + id + "\"> Inner 1 </li>" + "  <li> Inner 2 </li>" + "</ul>" + " <li> Outer 3 </li>" + "</ul>";
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(this.convert(content));
        System.out.println(this.wordMLPackage.getMainDocumentPart().getXML());
        List matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkStart", false);
        CTBookmark start = (CTBookmark)XmlUtils.unwrap(matches.get(0));
        Assert.assertTrue((boolean)start.getName().equals(id));
        matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkEnd", false);
        CTMarkupRange end = (CTMarkupRange)XmlUtils.unwrap(matches.get(0));
        Assert.assertEquals((Object)start.getId(), (Object)end.getId());
    }

    @Test
    public void bookmarkImg() throws Docx4JException, JAXBException {
        String id = "mydiv";
        String content = "<div><img  id=\"" + id + "\" src='" + "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC" + "'/></div>";
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(this.convert(content));
        System.out.println(this.wordMLPackage.getMainDocumentPart().getXML());
        List matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkStart", false);
        CTBookmark start = (CTBookmark)XmlUtils.unwrap(matches.get(0));
        Assert.assertTrue((boolean)start.getName().equals(id));
        matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkEnd", false);
        CTMarkupRange end = (CTMarkupRange)XmlUtils.unwrap(matches.get(0));
        Assert.assertEquals((Object)start.getId(), (Object)end.getId());
    }

    @Test
    public void bookmarksNested() throws Docx4JException, JAXBException {
        String id = "id1";
        String id2 = "id2";
        String content = "<ul>  <li> Outer 1 </li> <li> Outer 2 </li>  <ul  id=\"" + id + "\">" + "   <li  id=\"" + id2 + "\"> Inner 1 </li>" + "  <li> Inner 2 </li>" + "</ul>" + " <li> Outer 3 </li>" + "</ul>";
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(this.convert(content));
        System.out.println(this.wordMLPackage.getMainDocumentPart().getXML());
        List matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkStart", false);
        Assert.assertTrue((matches.size() == 2 ? 1 : 0) != 0);
        CTBookmark start = (CTBookmark)XmlUtils.unwrap(matches.get(0));
        CTBookmark start2 = (CTBookmark)XmlUtils.unwrap(matches.get(1));
        Assert.assertTrue((boolean)start.getName().equals(id));
        Assert.assertTrue((boolean)start2.getName().equals(id2));
        matches = this.wordMLPackage.getMainDocumentPart().getJAXBNodesViaXPath("//w:bookmarkEnd", false);
        CTMarkupRange end2 = (CTMarkupRange)XmlUtils.unwrap(matches.get(0));
        CTMarkupRange end1 = (CTMarkupRange)XmlUtils.unwrap(matches.get(1));
        Assert.assertEquals((Object)start.getId(), (Object)end1.getId());
        Assert.assertEquals((Object)start2.getId(), (Object)end2.getId());
    }
}

