/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.docx4j.Docx4J;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.DivToSdt;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.convert.out.HTMLSettings;
import org.docx4j.convert.out.html.SdtTagHandler;
import org.docx4j.convert.out.html.SdtWriter;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.SdtPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public class DivRoundtrip {
    private static Logger log = LoggerFactory.getLogger(DivRoundtrip.class);

    public static void main(String[] args) throws Exception {
        String xhtml = "<div id=\"top\"><h1>Heading</h1><div class=\"inner\"><p>p1</p><p>p2</p></div><div id=\"transient-container\" class=\"IGNORE\"><p>p1</p><p>p2</p></div></div>";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        XHTMLImporterImpl XHTMLImporter2 = new XHTMLImporterImpl(wordMLPackage);
        XHTMLImporter2.setDivHandler(new DivToSdt());
        wordMLPackage.getMainDocumentPart().getContent().addAll(XHTMLImporter2.convert(xhtml, null));
        System.out.println(XmlUtils.marshaltoString((Object)wordMLPackage.getMainDocumentPart().getJaxbElement(), (boolean)true, (boolean)true));
        wordMLPackage.save(new File(System.getProperty("user.dir") + "/OUT_from_XHTML.docx"));
        HTMLSettings htmlSettings = Docx4J.createHTMLSettings();
        htmlSettings.setWmlPackage((OpcPackage)wordMLPackage);
        SdtWriter.registerTagHandler((String)"*", (SdtTagHandler)new MyTagClass());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Docx4jProperties.setProperty((String)"docx4j.Convert.Out.HTML.OutputMethodXML", (Boolean)true);
        Docx4J.toHTML((HTMLSettings)htmlSettings, (OutputStream)os, (int)1);
        System.out.println(os.toString());
    }

    static class MyTagClass
    extends SdtTagHandler {
        MyTagClass() {
        }

        private Element createDiv(Document document, DocumentFragment docfrag, SdtPr sdtPr, HashMap<String, String> tagMap) throws ParserConfigurationException, IOException, SAXException {
            String idVal;
            Element xhtmlDiv = document.createElement("div");
            docfrag.appendChild(xhtmlDiv);
            String classVal = tagMap.get("class");
            if (classVal != null) {
                xhtmlDiv.setAttribute("class", classVal);
            }
            if ((idVal = tagMap.get("id")) != null) {
                xhtmlDiv.setAttribute("id", idVal);
            }
            return xhtmlDiv;
        }

        public Node toNode(WordprocessingMLPackage wmlPackage, SdtPr sdtPr, HashMap<String, String> tagMap, NodeIterator childResults) throws TransformerException {
            try {
                Document document = XmlUtils.getNewDocumentBuilder().newDocument();
                DocumentFragment docfrag = document.createDocumentFragment();
                if (tagMap.get("class") != null && "IGNORE".endsWith(tagMap.get("class"))) {
                    return this.attachContents(docfrag, docfrag, childResults);
                }
                if (tagMap.get("id") == null && tagMap.get("class") == null) {
                    return this.attachContents(docfrag, docfrag, childResults);
                }
                Element xhtmlDiv = this.createDiv(document, docfrag, sdtPr, tagMap);
                return this.attachContents(docfrag, xhtmlDiv, childResults);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new TransformerException(e);
            }
        }

        public Node toNode(WordprocessingMLPackage wmlPackage, SdtPr sdtPr, HashMap<String, String> tagMap, Node resultSoFar) throws TransformerException {
            try {
                Document document = XmlUtils.getNewDocumentBuilder().newDocument();
                DocumentFragment docfrag = document.createDocumentFragment();
                if (tagMap.get("class") != null && "IGNORE".endsWith(tagMap.get("class"))) {
                    return this.attachContents(docfrag, docfrag, resultSoFar);
                }
                if (tagMap.get("id") == null && tagMap.get("class") == null) {
                    return this.attachContents(docfrag, docfrag, resultSoFar);
                }
                Element xhtmlDiv = this.createDiv(document, docfrag, sdtPr, tagMap);
                return this.attachContents(docfrag, xhtmlDiv, resultSoFar);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new TransformerException(e);
            }
        }
    }
}

