/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.docx4j.Docx4jProperties;
import org.docx4j.Version;

public class MainDocumentPartFilterOuputStream
extends FilterOutputStream {
    boolean isNewPkg = true;
    boolean commentWritten = false;

    public MainDocumentPartFilterOuputStream(OutputStream out, boolean isNewPkg) {
        super(out);
        this.isNewPkg = isNewPkg;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.commentWritten) {
            super.write(b, off, len);
            return;
        }
        if (Docx4jProperties.getProperty("docx4j.jaxb.marshal.suppressVersionComment", false)) {
            this.commentWritten = true;
            super.write(b, off, len);
            return;
        }
        String text = new String(b, off, len);
        int pos = text.indexOf("<w:body>");
        if (pos < 0) {
            super.write(b, off, len);
            return;
        }
        int bodyEnd = pos + 8;
        String bodyString = text.substring(0, bodyEnd);
        this.out.write(bodyString.getBytes());
        String comment = "<!-- " + Version.getPoweredBy(this.isNewPkg) + " -->";
        this.out.write(comment.getBytes());
        this.out.write(text.substring(bodyEnd).getBytes());
        this.commentWritten = true;
    }
}

