/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts.apps;

import org.docx4j.fonts.fop.fonts.apps.AbstractFontReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TTFReader
extends AbstractFontReader {
    public static final String METRICS_VERSION_ATTR = "metrics-version";
    public static final int METRICS_VERSION = 2;

    public static void checkMetricsVersion(Attributes attr) throws SAXException {
        Object err = null;
        String str = attr.getValue(METRICS_VERSION_ATTR);
        if (str == null) {
            err = "Missing metrics-version attribute";
        } else {
            int version = 0;
            try {
                version = Integer.parseInt(str);
                if (version < 2) {
                    err = "Incompatible metrics-version value (" + version + ", should be 2)";
                }
            }
            catch (NumberFormatException e) {
                err = "Invalid metrics-version attribute value (" + str + ")";
            }
        }
        if (err != null) {
            throw new SAXException((String)err + " - please regenerate the font metrics file with a more recent version of FOP.");
        }
    }
}

