/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import jakarta.xml.bind.Binder;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import org.apache.commons.io.IOUtils;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.dml.chart.ObjectFactory;
import org.docx4j.dml.chartDrawing.CTDrawing;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.Docx4jUnmarshallerListener;
import org.docx4j.jaxb.JAXBAssociation;
import org.docx4j.jaxb.JAXBImplementation;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.jaxb.XPathBinderAssociationIsPartialException;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartTooLargeException;
import org.docx4j.openpackaging.io3.stores.PartStore;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.XPathEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public abstract class JaxbXmlPartXPathAware<E>
extends JaxbXmlPart<E>
implements XPathEnabled<E> {
    protected static Logger log = LoggerFactory.getLogger(JaxbXmlPartXPathAware.class);
    protected Binder<Node> binder;

    public JaxbXmlPartXPathAware(PartName partName) throws InvalidFormatException {
        super(partName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Binder<Node> getBinder() {
        if (this.jaxbElement == null) {
            PartStore partStore = this.getPackage().getSourcePartStore();
            InputStream is = null;
            try {
                String name = this.getPartName().getName();
                try {
                    this.setContentLengthAsLoaded(partStore.getPartSize(name.substring(1)));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                if (MAX_BYTES_Unmarshal_Error > -1L && this.getContentLengthAsLoaded() > MAX_BYTES_Unmarshal_Error) {
                    throw new PartTooLargeException(this.getPartName() + ", length " + this.getContentLengthAsLoaded() + " exceeds your configured maximum allowed size for unmarshal.");
                }
                is = partStore.loadPart(name.substring(1));
                if (is == null) {
                    log.warn(name + " missing from part store");
                } else {
                    log.debug("Lazily unmarshalling " + name);
                    this.unmarshal(is, true);
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            catch (JAXBException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Docx4JException e2) {
                log.error(e2.getMessage(), (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        } else if (this.binder == null) {
            try {
                log.debug("creating binder for " + this.getJaxbElement().getClass().getName());
                Document doc = XmlUtils.neww3cDomDocument();
                this.marshal(doc);
                this.unmarshal(doc.getDocumentElement());
            }
            catch (JAXBException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.binder;
    }

    @Override
    public void setJaxbElement(E jaxbElement) {
        super.setJaxbElement(jaxbElement);
        this.binder = null;
    }

    @Override
    public E createBinderAndJaxbElement(E source) throws JAXBException {
        log.debug("creating binder");
        Document doc = XmlUtils.marshaltoW3CDomDocument(source);
        this.unmarshal(doc.getDocumentElement());
        return (E)this.jaxbElement;
    }

    @Override
    public List<Object> getJAXBNodesViaXPath(String xpathExpr, boolean refreshXmlFirst) throws JAXBException, XPathBinderAssociationIsPartialException {
        Binder<Node> binder = this.getBinder();
        Object el = this.getJaxbElement();
        return XmlUtils.getJAXBNodesViaXPath(binder, el, xpathExpr, refreshXmlFirst);
    }

    @Override
    public List<Object> getJAXBNodesViaXPath(String xpathExpr, Object someJaxbElement, boolean refreshXmlFirst) throws JAXBException, XPathBinderAssociationIsPartialException {
        return XmlUtils.getJAXBNodesViaXPath(this.getBinder(), someJaxbElement, xpathExpr, refreshXmlFirst);
    }

    @Override
    public List<JAXBAssociation> getJAXBAssociationsForXPath(String xpathExpr, boolean refreshXmlFirst) throws JAXBException, XPathBinderAssociationIsPartialException {
        Binder<Node> binder = this.getBinder();
        return XmlUtils.getJAXBAssociationsForXPath(binder, this.getJaxbElement(), xpathExpr, refreshXmlFirst);
    }

    @Override
    public List<JAXBAssociation> getJAXBAssociationsForXPath(Object someJaxbElement, String xpathExpr, boolean refreshXmlFirst) throws JAXBException, XPathBinderAssociationIsPartialException {
        return XmlUtils.getJAXBAssociationsForXPath(this.getBinder(), someJaxbElement, xpathExpr, refreshXmlFirst);
    }

    private void unwrapUsually(Binder<Node> binder, Node doc) throws JAXBException {
        QName qname;
        Object tmp;
        this.jaxbElement = XmlUtils.unwrap(binder.unmarshal((Object)doc));
        if (this.jaxbElement instanceof CTDrawing && (tmp = binder.unmarshal((Object)doc)) instanceof JAXBElement && (qname = ((JAXBElement)tmp).getName()).equals(ObjectFactory._UserShapes_QNAME)) {
            this.jaxbElement = tmp;
        }
    }

    private void unwrapUsually(Object tmp) throws JAXBException {
        QName qname;
        if (tmp instanceof JAXBElement && (qname = ((JAXBElement)tmp).getName()).equals(ObjectFactory._UserShapes_QNAME)) {
            this.jaxbElement = tmp;
            return;
        }
        this.jaxbElement = XmlUtils.unwrap(tmp);
    }

    @Override
    public E unmarshal(InputStream is) throws JAXBException {
        return this.unmarshal(is, false);
    }

    private E unmarshal(InputStream is, boolean forceBinder) throws JAXBException {
        try {
            block32: {
                JaxbValidationEventHandler eventHandler = new JaxbValidationEventHandler();
                Document doc = null;
                try {
                    boolean wantBinder = forceBinder;
                    if (!forceBinder) {
                        wantBinder = this instanceof MainDocumentPart ? Docx4jProperties.getProperty("docx4j.openpackaging.parts.JaxbXmlPartXPathAware.binder.eager.MainDocumentPart", false) : Docx4jProperties.getProperty("docx4j.openpackaging.parts.JaxbXmlPartXPathAware.binder.eager.OtherParts", false);
                    }
                    if (wantBinder) {
                        block31: {
                            log.debug("For " + this.getClass().getName() + ", unmarshall via binder");
                            log.warn("Unmarshalling via binder, so no Docx4jUnmarshallerListener. McChoiceNamespace declarations will be affected.");
                            if (Context.jaxbImplementation == JAXBImplementation.ECLIPSELINK_MOXy) {
                                log.debug("MOXy: checking whether binder workaround is necessary");
                                String contents = IOUtils.toString((InputStream)is, (String)"UTF-8");
                                IOUtils.closeQuietly((InputStream)is);
                                try (ByteArrayInputStream is2 = new ByteArrayInputStream(contents.getBytes("UTF-8"));){
                                    if (contents.contains("AlternateContent")) {
                                        log.debug("MOXy: yes, performing workaround");
                                        try {
                                            Templates mcPreprocessorXslt = JaxbValidationEventHandler.getMcPreprocessor();
                                            DOMResult result = new DOMResult();
                                            XMLInputFactory xif = XMLInputFactory.newInstance();
                                            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                                            xif.setProperty("javax.xml.stream.supportDTD", false);
                                            XMLStreamReader xsr = xif.createXMLStreamReader(is2);
                                            XmlUtils.transform(new StAXSource(xsr), mcPreprocessorXslt, null, (Result)result);
                                            doc = (Document)result.getNode();
                                            break block31;
                                        }
                                        catch (Exception e) {
                                            throw new JAXBException("Preprocessing exception", (Throwable)e);
                                        }
                                    }
                                    log.debug("MOXy: no, looks ok");
                                }
                            }
                        }
                        if (doc == null) {
                            doc = XmlUtils.getNewDocumentBuilder().parse(is);
                        }
                        this.binder = this.jc.createBinder();
                        log.debug("info: " + this.binder.getClass().getName());
                        this.binder.setEventHandler((ValidationEventHandler)eventHandler);
                        this.unwrapUsually(this.binder, doc);
                        break block32;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("For " + this.getClass().getName() + ", unmarshall (no binder)");
                    }
                    XMLInputFactory xif = XMLInputFactory.newInstance();
                    xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                    xif.setProperty("javax.xml.stream.supportDTD", false);
                    XMLStreamReader xsr = xif.createXMLStreamReader(is);
                    Unmarshaller u = this.jc.createUnmarshaller();
                    u.setEventHandler((ValidationEventHandler)eventHandler);
                    Docx4jUnmarshallerListener docx4jUnmarshallerListener = new Docx4jUnmarshallerListener(this);
                    u.setListener((Unmarshaller.Listener)docx4jUnmarshallerListener);
                    log.debug("Unmarshalling " + this.partName.getName());
                    this.unwrapUsually(u.unmarshal(xsr));
                }
                catch (SAXParseException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
                catch (Exception ue) {
                    if (ue instanceof UnmarshalException) {
                        if (((UnmarshalException)((Object)ue)).getLinkedException() != null) {
                            log.warn(((UnmarshalException)((Object)ue)).getLinkedException().getMessage());
                            if (((UnmarshalException)((Object)ue)).getLinkedException().getMessage().contains("entity")) {
                                log.error(ue.getMessage(), (Throwable)ue);
                                throw ue;
                            }
                            if (((UnmarshalException)((Object)ue)).getLinkedException().getMessage().contains("EmptyPrefixedAttName?prefix=\"xmlns")) {
                                log.error(ue.getMessage(), (Throwable)ue);
                                if (is.markSupported()) {
                                    is.reset();
                                    String theString = IOUtils.toString((InputStream)is, (String)"UTF-8");
                                    String fixed = theString.replace("xmlns:ns0=\"\"", "");
                                    if (theString.equals(fixed)) {
                                        throw ue;
                                    }
                                    is = new ByteArrayInputStream(fixed.getBytes("UTF-8"));
                                    return this.unmarshal(is, forceBinder);
                                }
                                throw ue;
                            }
                        }
                    } else {
                        log.warn(ue.getMessage(), (Throwable)ue);
                    }
                    if (is.markSupported()) {
                        try {
                            is.reset();
                        }
                        catch (IOException ioe) {
                            log.error(ioe.getLocalizedMessage());
                            log.warn("problem in " + this.getPartName());
                            log.warn(ue.getMessage(), (Throwable)ue);
                            log.warn(".. and mark not supported");
                            log.warn(ioe.getLocalizedMessage());
                            throw ue;
                        }
                        log.info("encountered unexpected content in " + this.getPartName() + "; pre-processing");
                        doc = XmlUtils.getNewDocumentBuilder().parse(is);
                        DOMResult result = new DOMResult();
                        Templates mcPreprocessorXslt = JaxbValidationEventHandler.getMcPreprocessor();
                        XmlUtils.transform(doc, mcPreprocessorXslt, null, (Result)result);
                        doc = (Document)result.getNode();
                        try {
                            eventHandler.setContinue(true);
                            this.binder = this.jc.createBinder();
                            this.binder.setEventHandler((ValidationEventHandler)eventHandler);
                            this.jaxbElement = XmlUtils.unwrap(this.binder.unmarshal((Object)doc));
                        }
                        catch (ClassCastException cce) {
                            log.warn("Binder not available for this docx");
                            Unmarshaller u = this.jc.createUnmarshaller();
                            eventHandler.setContinue(true);
                            u.setEventHandler((ValidationEventHandler)eventHandler);
                            Docx4jUnmarshallerListener docx4jUnmarshallerListener = new Docx4jUnmarshallerListener(this);
                            u.setListener((Unmarshaller.Listener)docx4jUnmarshallerListener);
                            this.unwrapUsually(u.unmarshal((Node)doc));
                        }
                    }
                    log.warn("problem in " + this.getPartName());
                    log.warn(ue.getMessage(), (Throwable)ue);
                    log.warn(".. and mark not supported");
                    throw ue;
                }
            }
            return (E)this.jaxbElement;
        }
        catch (Exception e) {
            for (int i = 0; i < e.getStackTrace().length; ++i) {
                if (!e.getStackTrace()[i].getClassName().contains("DTD") && !e.getStackTrace()[i].getMethodName().contains("DTD")) continue;
                throw new JAXBException("DTD is prohibited", (Throwable)e);
            }
            throw new JAXBException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public E unmarshal(Element el) throws JAXBException {
        Document doc;
        log.debug("For " + this.getClass().getName() + ", unmarshall via binder");
        log.warn("Unmarshalling via binder, so no Docx4jUnmarshallerListener. McChoiceNamespace declarations will be affected.");
        if (Context.jaxbImplementation == JAXBImplementation.ECLIPSELINK_MOXy) {
            log.debug("MOXy: pre-emptively transforming");
            try {
                Templates mcPreprocessorXslt = JaxbValidationEventHandler.getMcPreprocessor();
                DOMResult result = new DOMResult();
                XmlUtils.transform(new DOMSource(el), mcPreprocessorXslt, null, (Result)result);
                doc = (Document)result.getNode();
                el = doc.getDocumentElement();
            }
            catch (Exception e) {
                throw new JAXBException("Preprocessing exception", (Throwable)e);
            }
        }
        this.binder = this.jc.createBinder();
        JaxbValidationEventHandler eventHandler = new JaxbValidationEventHandler();
        eventHandler.setContinue(false);
        this.binder.setEventHandler((ValidationEventHandler)eventHandler);
        try {
            this.unwrapUsually(this.binder, el);
        }
        catch (Exception ue) {
            if (!(ue instanceof UnmarshalException)) {
                log.warn(ue.getMessage(), (Throwable)ue);
                log.info(".. can recover if problem is w:tblW/@w:w");
            }
            log.info("encountered unexpected content; pre-processing");
            doc = null;
            try {
                doc = el instanceof Document ? (Document)((Object)el) : el.getOwnerDocument();
                eventHandler.setContinue(true);
                DOMResult result = new DOMResult();
                Templates mcPreprocessorXslt = JaxbValidationEventHandler.getMcPreprocessor();
                XmlUtils.transform(doc, mcPreprocessorXslt, null, (Result)result);
                doc = (Document)result.getNode();
                this.jaxbElement = XmlUtils.unwrap(this.binder.unmarshal((Object)doc));
            }
            catch (ClassCastException cce) {
                log.warn("Binder not available for this docx");
                Unmarshaller u = this.jc.createUnmarshaller();
                eventHandler.setContinue(true);
                u.setEventHandler((ValidationEventHandler)eventHandler);
                Docx4jUnmarshallerListener docx4jUnmarshallerListener = new Docx4jUnmarshallerListener(this);
                u.setListener((Unmarshaller.Listener)docx4jUnmarshallerListener);
                this.jaxbElement = XmlUtils.unwrap(u.unmarshal((Node)doc));
            }
            catch (Exception e) {
                throw new JAXBException("Preprocessing exception", (Throwable)e);
            }
        }
        return (E)this.jaxbElement;
    }
}

