/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.docx4j.Docx4jProperties;
import org.docx4j.TraversalUtil;
import org.docx4j.finders.RangeFinder;
import org.docx4j.model.datastorage.BindingHyperlinkResolver;
import org.docx4j.model.datastorage.BindingTraverserCommonImpl;
import org.docx4j.model.datastorage.BindingTraverserNonXSLT;
import org.docx4j.model.datastorage.BindingTraverserStAX;
import org.docx4j.model.datastorage.BindingTraverserXSLT;
import org.docx4j.model.datastorage.BookmarkHandlerStAX;
import org.docx4j.model.datastorage.DomToXPathMap;
import org.docx4j.model.datastorage.InputIntegrityException;
import org.docx4j.model.datastorage.ValueInserterPlainText;
import org.docx4j.model.datastorage.ValueInserterPlainTextImpl;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTDataBinding;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingHandler {
    private static Logger log = LoggerFactory.getLogger(BindingHandler.class);
    private static BindingHyperlinkResolver hyperlinkResolver;
    private static ValueInserterPlainText valueInserterPlainText;
    private DomToXPathMap domToXPathMap = null;
    private AtomicInteger bookmarkId = null;
    private WordprocessingMLPackage wordMLPackage;
    Map<String, Xpaths.Xpath> xpathsMap = null;
    public static final String CORE_PROPERTIES_STOREITEMID = "{6C3C8BC8-F283-45AE-878A-BAB7291924A1}";
    public static final String EXTENDED_PROPERTIES_STOREITEMID = "{6668398D-A668-4E3E-A5EB-62B293D839F1}";
    public static final String COVERPAGE_PROPERTIES_STOREITEMID = "{55AF091B-3C7A-41E3-B477-F2FDAA23CFDA}";

    public static void setHyperlinkStyle(String hyperlinkStyleID) {
        BindingHandler.getHyperlinkResolver().setHyperlinkStyle(hyperlinkStyleID);
    }

    public static String getHyperlinkStyleId() {
        return BindingHandler.getHyperlinkResolver().getHyperlinkStyleId();
    }

    public static BindingHyperlinkResolver getHyperlinkResolver() {
        if (hyperlinkResolver == null) {
            hyperlinkResolver = new BindingHyperlinkResolver();
        }
        return hyperlinkResolver;
    }

    public static void setHyperlinkResolver(BindingHyperlinkResolver hyperlinkResolver) {
        BindingHandler.hyperlinkResolver = hyperlinkResolver;
    }

    public static ValueInserterPlainText getValueInserterPlainText() {
        if (valueInserterPlainText == null) {
            valueInserterPlainText = new ValueInserterPlainTextImpl();
        }
        return valueInserterPlainText;
    }

    public static void setValueInserterPlainText(ValueInserterPlainText valueInserterPlainText) {
        BindingHandler.valueInserterPlainText = valueInserterPlainText;
    }

    public void setDomToXPathMap(DomToXPathMap domToXPathMap) {
        this.domToXPathMap = domToXPathMap;
    }

    public void setStartingIdForNewBookmarks(AtomicInteger bookmarkId) {
        this.bookmarkId = bookmarkId;
    }

    protected AtomicInteger initBookmarkIdStart() throws Docx4JException {
        if (this.bookmarkId != null) {
            return this.bookmarkId;
        }
        log.warn("Recalculating starting value for new bookmarks.  For efficiency, you should set this in your code.");
        int highestId = 0;
        if (this.wordMLPackage.getMainDocumentPart().isUnmarshalled()) {
            log.debug(" MDP already unmarshalled.");
            RangeFinder rt = new RangeFinder();
            new TraversalUtil(this.wordMLPackage.getMainDocumentPart().getContent(), rt);
            for (CTBookmark bm : rt.getStarts()) {
                BigInteger id = bm.getId();
                if (id == null || id.intValue() <= highestId) continue;
                highestId = id.intValue();
            }
        } else {
            log.debug(" MDP not unmarshalled so can usefully use StAX.");
            BookmarkHandlerStAX bh = new BookmarkHandlerStAX();
            try {
                this.wordMLPackage.getMainDocumentPart().pipe(bh, null);
            }
            catch (Exception e) {
                throw new Docx4JException(e.getMessage(), e);
            }
            highestId = bh.getHighestId();
        }
        return new AtomicInteger(highestId + 1);
    }

    private BindingHandler() {
    }

    public BindingHandler(WordprocessingMLPackage wordMLPackage) {
        this.wordMLPackage = wordMLPackage;
    }

    @Deprecated
    public static void applyBindings(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        BindingHandler bh = new BindingHandler(wordMLPackage);
        bh.applyBindings();
    }

    public void applyBindings() throws Docx4JException {
        BindingHandler.getHyperlinkResolver().activateHyperlinkStyle(this.wordMLPackage);
        this.applyBindings(this.wordMLPackage.getMainDocumentPart());
        RelationshipsPart rp = this.wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                this.applyBindings((HeaderPart)rp.getPart(r));
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            this.applyBindings((FooterPart)rp.getPart(r));
        }
    }

    public Map<String, Xpaths.Xpath> getXpathsMap() {
        return this.xpathsMap;
    }

    public void applyBindings(JaxbXmlPart part) throws Docx4JException {
        BindingHandler.getHyperlinkResolver().activateHyperlinkStyle(this.wordMLPackage);
        if (this.wordMLPackage.getMainDocumentPart().getXPathsPart() == null) {
            log.warn("OpenDoPE XPaths part missing");
            this.xpathsMap = new HashMap<String, Xpaths.Xpath>();
        } else {
            Xpaths xPaths = (Xpaths)this.wordMLPackage.getMainDocumentPart().getXPathsPart().getJaxbElement();
            this.xpathsMap = new HashMap<String, Xpaths.Xpath>(xPaths.getXpath().size());
            for (Xpaths.Xpath xp : xPaths.getXpath()) {
                if (this.xpathsMap.put(xp.getId(), xp) == null) continue;
                log.error("Duplicates in XPaths part: " + xp.getId());
            }
        }
        BindingTraverserCommonImpl traverser = null;
        if (part.isUnmarshalled()) {
            log.debug("Part already unmarshalled, so BindingTraverserStAX won't speed things up.");
        } else {
            log.info("Part not unmarshalled, so BindingTraverserStAX could speed things up.");
        }
        if (Docx4jProperties.getProperty("docx4j.model.datastorage.BindingHandler.Implementation", "BindingTraverserXSLT").equals("BindingTraverserNonXSLT")) {
            log.info("Using BindingTraverserNonXSLT, which is faster, but missing some features");
            traverser = new BindingTraverserNonXSLT();
        } else if (Docx4jProperties.getProperty("docx4j.model.datastorage.BindingHandler.Implementation", "BindingTraverserXSLT").equals("BindingTraverserStAX")) {
            log.info("Using BindingTraverserStAX");
            traverser = new BindingTraverserStAX();
        } else {
            log.info("Using BindingTraverserXSLT, which is slower, but fully featured");
            traverser = new BindingTraverserXSLT();
            ((BindingTraverserXSLT)traverser).setDomToXPathMap(this.domToXPathMap);
        }
        traverser.setStartingIdForNewBookmarks(this.initBookmarkIdStart());
        if (traverser instanceof BindingTraverserStAX) {
            ((BindingTraverserStAX)traverser).streamToBind(part, this.wordMLPackage, this.xpathsMap);
        } else if (part.isUnmarshalled()) {
            part.setJaxbElement(traverser.traverseToBind(part, this.wordMLPackage, this.xpathsMap));
        } else {
            traverser.traverseToBind(part, this.wordMLPackage, this.xpathsMap);
        }
        this.bookmarkId = traverser.getNextBookmarkId();
    }

    public static String xpathGetString(WordprocessingMLPackage pkg, Map<String, CustomXmlPart> customXmlDataStorageParts, CTDataBinding db) {
        return BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, db.getStoreItemID(), db.getXpath(), db.getPrefixMappings());
    }

    public static String xpathGetString(WordprocessingMLPackage pkg, Map<String, CustomXmlPart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings) {
        log.debug(xpath + " with " + prefixMappings);
        if (xpath.contains("preceding-sibling")) {
            xpath = xpath.replace("][1]", "]");
        }
        try {
            if (storeItemId.toUpperCase().equals(CORE_PROPERTIES_STOREITEMID)) {
                return pkg.getDocPropsCorePart().xpathGetString(xpath, prefixMappings);
            }
            if (storeItemId.toUpperCase().equals(EXTENDED_PROPERTIES_STOREITEMID)) {
                return pkg.getDocPropsExtendedPart().xpathGetString(xpath, prefixMappings);
            }
            CustomXmlPart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
            if (part == null) {
                throw new InputIntegrityException("Couldn't locate part by storeItemId " + storeItemId);
            }
            String r = part.cachedXPathGetString(xpath, prefixMappings);
            if (r == null) {
                log.error(xpath + " unexpectedly null!");
                return r;
            }
            if (r.equals("")) {
                log.debug("XML element is missing (or empty) for xpath: " + xpath);
                return r;
            }
            if (log.isDebugEnabled()) {
                log.debug(xpath + " yielded result '" + r + "'");
                return r;
            }
            return r;
        }
        catch (Docx4JException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new InputIntegrityException(e.getMessage());
        }
    }
}

