/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.PresentationML;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.NotImplementedException;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.dml.Theme;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.CommentAuthorsPart;
import org.docx4j.openpackaging.parts.PresentationML.JaxbPmlPart;
import org.docx4j.openpackaging.parts.PresentationML.NotesMasterPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideMasterPart;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.pptx4j.Pptx4jException;
import org.pptx4j.com.microsoft.schemas.office.powerpoint.x2010.main.CTSection;
import org.pptx4j.com.microsoft.schemas.office.powerpoint.x2010.main.CTSectionList;
import org.pptx4j.com.microsoft.schemas.office.powerpoint.x2010.main.CTSectionSlideIdListEntry;
import org.pptx4j.com.microsoft.schemas.office.powerpoint.x2012.main.CTExtendedGuideList;
import org.pptx4j.jaxb.Context;
import org.pptx4j.model.SlideSizesWellKnown;
import org.pptx4j.pml.CTExtension;
import org.pptx4j.pml.CTExtensionList;
import org.pptx4j.pml.CTNotesMasterIdList;
import org.pptx4j.pml.CTNotesMasterIdListEntry;
import org.pptx4j.pml.ObjectFactory;
import org.pptx4j.pml.Presentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MainPresentationPart
extends JaxbPmlPart<Presentation> {
    protected static Logger log = LoggerFactory.getLogger(MainPresentationPart.class);
    private static final String DEFAULT_SLIDE_SIZE = "<p:sldSz xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\" cx=\"9144000\" cy=\"6858000\" type=\"screen4x3\"/>";
    private static final String DEFAULT_NOTES_SIZE = "<p:notesSz xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\" cx=\"6858000\" cy=\"9144000\"/>";
    private CommentAuthorsPart commentAuthorsPart;
    private ThemePart themePart;
    private NotesMasterPart notesMasterPart;
    private static final String EXT_URI_FOR_SECTION_LST = "{521415D9-36F7-43E2-AB2F-B90AF26B5E84}";

    public MainPresentationPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public MainPresentationPart() throws InvalidFormatException {
        super(new PartName("/ppt/presentation.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
    }

    public boolean setPartShortcut(Part part) {
        if (part == null) {
            return false;
        }
        return this.setPartShortcut(part, part.getRelationshipType());
    }

    @Override
    public boolean setPartShortcut(Part part, String relationshipType) {
        if (relationshipType == null) {
            log.warn("trying to set part shortcut against a null relationship type.");
            return false;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/commentAuthors")) {
            this.commentAuthorsPart = (CommentAuthorsPart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme")) {
            this.themePart = (ThemePart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/notesMaster")) {
            this.notesMasterPart = (NotesMasterPart)part;
            return true;
        }
        return false;
    }

    public CommentAuthorsPart getCommentAuthorsPart() {
        return this.commentAuthorsPart;
    }

    public ThemePart getThemePart() {
        return this.themePart;
    }

    public NotesMasterPart getNotesMasterPart(boolean createIfAbsent) throws Pptx4jException {
        if (this.notesMasterPart == null && createIfAbsent) {
            Relationship ppRelNmp = null;
            ThemePart themePart2 = null;
            try {
                this.notesMasterPart = new NotesMasterPart();
                this.notesMasterPart.addDefaultContent();
                ppRelNmp = this.addTargetPart(this.notesMasterPart);
                ((Presentation)this.getJaxbElement()).setNotesMasterIdLst(this.createNotesMasterIdListPlusEntry(ppRelNmp.getId()));
                themePart2 = new ThemePart(new PartName("/ppt/theme/theme2.xml"));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
            if (this.getThemePart() == null) {
                throw new Pptx4jException("Missing theme part");
            }
            try {
                themePart2.setContents(XmlUtils.deepCopy((Theme)this.getThemePart().getContents(), Context.jcPML));
                this.notesMasterPart.addTargetPart((Part)themePart2, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
            }
            catch (Docx4JException e) {
                throw new Pptx4jException(e.getMessage(), e);
            }
        }
        return this.notesMasterPart;
    }

    private CTNotesMasterIdList createNotesMasterIdListPlusEntry(String relId) {
        ObjectFactory pmlObjectFactory = new ObjectFactory();
        CTNotesMasterIdList notesmasteridlist = pmlObjectFactory.createCTNotesMasterIdList();
        CTNotesMasterIdListEntry notesmasteridlistentry = pmlObjectFactory.createCTNotesMasterIdListEntry();
        notesmasteridlist.setNotesMasterId(notesmasteridlistentry);
        notesmasteridlistentry.setId(relId);
        return notesmasteridlist;
    }

    public static Presentation.SldSz createSlideSize(SlideSizesWellKnown sz, boolean landscape) {
        Presentation.SldSz sldSz = Context.getpmlObjectFactory().createPresentationSldSz();
        if (sz.equals((Object)SlideSizesWellKnown.LETTER)) {
            sldSz.setType("letter");
            if (landscape) {
                sldSz.setCx(9144000);
                sldSz.setCy(6858000);
            } else {
                sldSz.setCx(6858000);
                sldSz.setCy(9144000);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.A3)) {
            sldSz.setType("A3");
            if (landscape) {
                sldSz.setCx(12801600);
                sldSz.setCy(9601200);
            } else {
                sldSz.setCx(9601200);
                sldSz.setCy(12801600);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.A4)) {
            sldSz.setType("A4");
            if (landscape) {
                sldSz.setCx(9906000);
                sldSz.setCy(6858000);
            } else {
                sldSz.setCx(6858000);
                sldSz.setCy(9906000);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.SCREEN4x3)) {
            sldSz.setType("screen4x3");
            if (landscape) {
                sldSz.setCx(9144000);
                sldSz.setCy(6858000);
            } else {
                sldSz.setCx(6858000);
                sldSz.setCy(9144000);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.SCREEN16x9)) {
            sldSz.setType("screen16x9");
            if (landscape) {
                sldSz.setCx(9144000);
                sldSz.setCy(5143500);
            } else {
                sldSz.setCx(5143500);
                sldSz.setCy(9144000);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.SCREEN16x10)) {
            sldSz.setType("screen16x10");
            if (landscape) {
                sldSz.setCx(9144000);
                sldSz.setCy(5715000);
            } else {
                sldSz.setCx(5715000);
                sldSz.setCy(9144000);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.LEDGER)) {
            sldSz.setType("ledger");
            if (landscape) {
                sldSz.setCx(12179300);
                sldSz.setCy(9134475);
            } else {
                sldSz.setCx(9134475);
                sldSz.setCy(12179300);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.B4ISO)) {
            sldSz.setType("B4ISO");
            if (landscape) {
                sldSz.setCx(10826750);
                sldSz.setCy(8120063);
            } else {
                sldSz.setCx(8120063);
                sldSz.setCy(10826750);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.B5ISO)) {
            sldSz.setType("B5ISO");
            if (landscape) {
                sldSz.setCx(7169150);
                sldSz.setCy(5376863);
            } else {
                sldSz.setCx(5376863);
                sldSz.setCy(7169150);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.MM35)) {
            sldSz.setType("35mm");
            if (landscape) {
                sldSz.setCx(10287000);
                sldSz.setCy(6858000);
            } else {
                sldSz.setCx(6858000);
                sldSz.setCy(10287000);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.OVERHEAD)) {
            sldSz.setType("overhead");
            if (landscape) {
                sldSz.setCx(9144000);
                sldSz.setCy(6858000);
            } else {
                sldSz.setCx(6858000);
                sldSz.setCy(9144000);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.BANNER)) {
            sldSz.setType("banner");
            if (landscape) {
                sldSz.setCx(7315200);
                sldSz.setCy(914400);
            } else {
                sldSz.setCx(914400);
                sldSz.setCy(7315200);
            }
            return sldSz;
        }
        throw new NotImplementedException("No support for slide size " + sz.value());
    }

    public static Presentation createJaxbPresentationElement() throws JAXBException {
        return MainPresentationPart.createJaxbPresentationElement(null, true);
    }

    public static Presentation createJaxbPresentationElement(SlideSizesWellKnown sz, boolean landscape) throws JAXBException {
        ObjectFactory factory = Context.getpmlObjectFactory();
        Presentation presentation = factory.createPresentation();
        Presentation.SldMasterIdLst masterIds = factory.createPresentationSldMasterIdLst();
        Presentation.SldIdLst slideIds = factory.createPresentationSldIdLst();
        presentation.setSldMasterIdLst(masterIds);
        presentation.setSldIdLst(slideIds);
        presentation.setNotesSz((CTPositiveSize2D)XmlUtils.unmarshalString(DEFAULT_NOTES_SIZE, Context.jcPML, CTPositiveSize2D.class));
        if (sz == null) {
            presentation.setSldSz((Presentation.SldSz)XmlUtils.unmarshalString(DEFAULT_SLIDE_SIZE, Context.jcPML, Presentation.SldSz.class));
        } else {
            presentation.setSldSz(MainPresentationPart.createSlideSize(sz, landscape));
        }
        return presentation;
    }

    public Presentation.SldIdLst.SldId addSlideIdListEntry(SlidePart slidePart) throws InvalidFormatException {
        return this.addSlideIdListEntry(slidePart, RelationshipsPart.AddPartBehaviour.OVERWRITE_IF_NAME_EXISTS);
    }

    @Deprecated
    public Presentation.SldIdLst.SldId addSlideIdListEntry(SlidePart slidePart, RelationshipsPart.AddPartBehaviour mode) throws InvalidFormatException {
        Relationship rel = this.addTargetPart((Part)slidePart, mode);
        Presentation.SldIdLst.SldId entry = Context.getpmlObjectFactory().createPresentationSldIdLstSldId();
        entry.setId(this.getSlideId());
        entry.setRid(rel.getId());
        ((Presentation)this.getJaxbElement()).getSldIdLst().getSldId().add(entry);
        return entry;
    }

    public Presentation.SldMasterIdLst.SldMasterId addSlideMasterIdListEntry(SlideMasterPart slideMasterPart) throws InvalidFormatException {
        Relationship rel = this.addTargetPart(slideMasterPart);
        Presentation.SldMasterIdLst.SldMasterId entry = Context.getpmlObjectFactory().createPresentationSldMasterIdLstSldMasterId();
        entry.setId(new Long(this.getSlideLayoutOrMasterId()));
        entry.setRid(rel.getId());
        ((Presentation)this.getJaxbElement()).getSldMasterIdLst().getSldMasterId().add(entry);
        return entry;
    }

    public boolean addSlide(SlidePart slidePart) throws Pptx4jException {
        try {
            Relationship rel = this.addTargetPart((Part)slidePart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
            return ((Presentation)this.getJaxbElement()).getSldIdLst().getSldId().add(this.createSlideIdListEntry(rel));
        }
        catch (InvalidFormatException e) {
            throw new Pptx4jException(e.getMessage(), e);
        }
    }

    public void addSlide(int index, SlidePart slidePart) throws Pptx4jException {
        List sldIds = ((Presentation)this.getJaxbElement()).getSldIdLst().getSldId();
        int zeroBasedCount = sldIds.size();
        if (index < 0 || index > zeroBasedCount) {
            throw new Pptx4jException("Can't add slide at index " + index + ".  (There are " + sldIds.size() + " slides) ");
        }
        try {
            Relationship rel = this.addTargetPart((Part)slidePart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
            sldIds.add(index, this.createSlideIdListEntry(rel));
        }
        catch (InvalidFormatException e) {
            throw new Pptx4jException(e.getMessage(), e);
        }
    }

    private Presentation.SldIdLst.SldId createSlideIdListEntry(Relationship rel) throws InvalidFormatException {
        Presentation.SldIdLst.SldId entry = Context.getpmlObjectFactory().createPresentationSldIdLstSldId();
        entry.setId(this.getSlideId());
        entry.setRid(rel.getId());
        return entry;
    }

    public void removeSlide(int index) throws Pptx4jException {
        List sldIds = ((Presentation)this.getJaxbElement()).getSldIdLst().getSldId();
        int zeroBasedCount = sldIds.size() - 1;
        if (index < 0 || index > zeroBasedCount) {
            throw new Pptx4jException("No slide at index " + index + ".  (There are " + sldIds.size() + " slides) ");
        }
        Presentation.SldIdLst.SldId entry = (Presentation.SldIdLst.SldId)((Presentation)this.getJaxbElement()).getSldIdLst().getSldId().remove(index);
        Relationship rel = this.getRelationshipsPart().getRelationshipByID(entry.getRid());
        Part part = this.getRelationshipsPart().getPart(rel);
        this.getPackage().getParts().remove(part.getPartName());
        this.getRelationshipsPart().removeRelationship(rel);
    }

    public void removeSlide(Relationship rel) throws Pptx4jException {
        if (rel == null) {
            throw new Pptx4jException("Null relationship.");
        }
        int index = -1;
        int i = 0;
        for (Presentation.SldIdLst.SldId entry : ((Presentation)this.getJaxbElement()).getSldIdLst().getSldId()) {
            if (entry.getRid().equals(rel.getId())) {
                index = i;
                break;
            }
            ++i;
        }
        if (index <= -1) {
            throw new Pptx4jException("No slide is the target of that relationship.");
        }
        this.removeSlide(index);
    }

    public SlidePart getSlide(int index) throws Pptx4jException {
        this.ensureContent();
        this.ensureSldIdLst();
        List sldIds = ((Presentation)this.getJaxbElement()).getSldIdLst().getSldId();
        int zeroBasedCount = sldIds.size() - 1;
        if (index < 0 || index > zeroBasedCount) {
            throw new Pptx4jException("No slide at index " + index + ".  (There are " + sldIds.size() + " slides) ");
        }
        try {
            Presentation.SldIdLst.SldId entry = (Presentation.SldIdLst.SldId)((Presentation)this.getJaxbElement()).getSldIdLst().getSldId().get(index);
            return (SlidePart)this.getRelationshipsPart().getPart(entry.getRid());
        }
        catch (Exception e) {
            throw new Pptx4jException("Slide " + index + " not found", e);
        }
    }

    public List<SlidePart> getSlideParts() throws Pptx4jException {
        this.ensureContent();
        this.ensureSldIdLst();
        ArrayList<SlidePart> slideParts = new ArrayList<SlidePart>();
        for (Presentation.SldIdLst.SldId entry : ((Presentation)this.getJaxbElement()).getSldIdLst().getSldId()) {
            try {
                slideParts.add((SlidePart)this.getRelationshipsPart().getPart(entry.getRid()));
            }
            catch (Exception e) {
                throw new Pptx4jException("Slide " + entry.getRid() + " not found", e);
            }
        }
        return slideParts;
    }

    private void ensureContent() throws Pptx4jException {
        try {
            if (this.getContents() == null) {
                throw new Pptx4jException("MainPresentationPart has no content");
            }
        }
        catch (Docx4JException e) {
            throw new Pptx4jException(e.getMessage(), e);
        }
    }

    private void ensureSldIdLst() throws Pptx4jException {
        try {
            if (((Presentation)this.getContents()).getSldIdLst() == null) {
                throw new Pptx4jException("SldIdLst missing from MainPresentationPart");
            }
        }
        catch (Docx4JException e) {
            throw new Pptx4jException(e.getMessage(), e);
        }
    }

    public int getSlideCount() throws Pptx4jException {
        this.ensureContent();
        this.ensureSldIdLst();
        List sldIds = ((Presentation)this.getJaxbElement()).getSldIdLst().getSldId();
        return sldIds.size();
    }

    public CTExtension getExtContaining(Class containingClass) {
        CTExtensionList extLst = ((Presentation)this.getJaxbElement()).getExtLst();
        if (extLst == null) {
            return null;
        }
        for (CTExtension ext : extLst.getExt()) {
            Object o2;
            Object o;
            if (ext.getAny() == null || !((o = ext.getAny()) instanceof JAXBElement) || !(o2 = XmlUtils.unwrap(o)).getClass().getName().equals(containingClass.getName())) continue;
            return ext;
        }
        return null;
    }

    public boolean removeExt(Class containingClass) {
        CTExtension ext = this.getExtContaining(containingClass);
        if (ext != null) {
            return ((Presentation)this.getJaxbElement()).getExtLst().getExt().remove(ext);
        }
        return false;
    }

    public CTSectionList getSectionList(boolean createIfAbsent) {
        CTExtension ext = this.getExtContaining(CTSectionList.class);
        if (ext == null) {
            if (createIfAbsent) {
                CTExtensionList extLst = this.getExtensionList(true);
                ext = new CTExtension();
                ext.setUri(EXT_URI_FOR_SECTION_LST);
                extLst.getExt().add(ext);
            } else {
                return null;
            }
        }
        if (ext.getAny() != null) {
            Object o = ext.getAny();
            return (CTSectionList)XmlUtils.unwrap(o);
        }
        if (createIfAbsent) {
            CTSectionList ctSectionList = new CTSectionList();
            ext.setAny((Object)ctSectionList);
            return ctSectionList;
        }
        return null;
    }

    public CTExtendedGuideList getExtendedGuideList(boolean createIfAbsent) {
        CTExtension ext = this.getExtContaining(CTExtendedGuideList.class);
        if (ext == null) {
            if (createIfAbsent) {
                CTExtensionList extLst = this.getExtensionList(true);
                ext = new CTExtension();
                String newUUID = "{" + UUID.randomUUID().toString().toUpperCase() + "}";
                ext.setUri(newUUID);
                extLst.getExt().add(ext);
            } else {
                return null;
            }
        }
        if (ext.getAny() != null) {
            Object o = ext.getAny();
            return (CTExtendedGuideList)XmlUtils.unwrap(o);
        }
        if (createIfAbsent) {
            CTExtendedGuideList ctExtendedGuideList = new CTExtendedGuideList();
            ext.setAny((Object)ctExtendedGuideList);
            return ctExtendedGuideList;
        }
        return null;
    }

    public CTExtensionList getExtensionList(boolean createIfAbsent) {
        CTExtensionList extLst = ((Presentation)this.getJaxbElement()).getExtLst();
        if (extLst == null) {
            if (createIfAbsent) {
                extLst = new CTExtensionList();
                ((Presentation)this.getJaxbElement()).setExtLst(extLst);
                return extLst;
            }
            return null;
        }
        return extLst;
    }

    public CTSection getSection(SlidePart sp) {
        Relationship r = sp.getSourceRelationships().get(0);
        Presentation.SldIdLst.SldId sldId = this.getSldIdByRelId(r.getId());
        CTExtension ext = this.getExtContaining(CTSectionList.class);
        if (ext == null) {
            log.debug("Couldn't find ext containing sectionLst");
            return null;
        }
        if (ext.getAny() != null) {
            Object o = ext.getAny();
            CTSectionList sectLst = (CTSectionList)XmlUtils.unwrap(o);
            return this.getSection(sectLst, sldId.getId());
        }
        return null;
    }

    private CTSection getSection(CTSectionList sectLst, long sldId) {
        for (CTSection p14Section : sectLst.getSection()) {
            if (p14Section.getSldIdLst() == null) continue;
            for (CTSectionSlideIdListEntry p14SldId : p14Section.getSldIdLst().getSldId()) {
                if (p14SldId.getId() != sldId) continue;
                return p14Section;
            }
        }
        return null;
    }

    public Presentation.SldIdLst.SldId getSldIdByRelId(String relId) {
        for (Presentation.SldIdLst.SldId sldId : ((Presentation)this.getJaxbElement()).getSldIdLst().getSldId()) {
            if (!sldId.getRid().equals(relId)) continue;
            return sldId;
        }
        return null;
    }
}

