/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.utils;

import java.util.Arrays;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.utils.XMLStreamWriterWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLStreamWriterWrapperIndenting
extends XMLStreamWriterWrapper {
    protected static Logger log = LoggerFactory.getLogger(XMLStreamWriterWrapperIndenting.class);
    private int depth = 0;
    private static final Object SEEN_NOTHING = new Object();
    private static final Object SEEN_ELEMENT = new Object();
    private static final Object SEEN_DATA = new Object();
    private Object state = SEEN_NOTHING;
    private Stack<Object> stateStack = new Stack();

    public void indent() throws XMLStreamException {
        char[] indent = new char[this.depth * 2];
        Arrays.fill(indent, ' ');
        this.underlying.writeCharacters(indent, 0, indent.length);
    }

    private void onStartElement() throws XMLStreamException {
        this.stateStack.push(SEEN_ELEMENT);
        this.state = SEEN_NOTHING;
        this.underlying.writeCharacters("\n");
        this.indent();
        ++this.depth;
    }

    private void onEmptyElement() throws XMLStreamException {
        this.state = SEEN_ELEMENT;
        if (this.depth > 0) {
            this.underlying.writeCharacters("\n");
        }
        this.indent();
    }

    private void onEndElement() throws XMLStreamException {
        --this.depth;
        if (this.state == SEEN_ELEMENT) {
            super.writeCharacters("\n");
            this.indent();
        }
        this.state = this.stateStack.pop();
    }

    public XMLStreamWriterWrapperIndenting(JaxbXmlPart part, XMLStreamWriter underlying) {
        super(part, underlying);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onStartElement();
        super.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.onEmptyElement();
        super.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.onEndElement();
        super.writeEndElement();
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.underlying.writeCharacters("\n");
        this.indent();
        super.writeComment(data);
    }
}

