/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.fonts.CJKToEnglish;
import org.docx4j.fonts.RunFontSelector;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.McIgnorableNamespaceDeclarator;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.GlossaryDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.KeyMapCustomizationsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Body;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTEndnotes;
import org.docx4j.wml.CTFootnotes;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Document;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.Hdr;
import org.docx4j.wml.Lvl;
import org.docx4j.wml.Numbering;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.RStyle;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainDocumentPart
extends DocumentPart<Document>
implements ContentAccessor {
    private static Logger log = LoggerFactory.getLogger(MainDocumentPart.class);
    private PropertyResolver propertyResolver;
    private StyleTree styleTree;
    GlossaryDocumentPart glossaryDocumentPart;
    KeyMapCustomizationsPart keyMapCustomizationsPart;

    public MainDocumentPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public MainDocumentPart() throws InvalidFormatException {
        super(new PartName("/word/document.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
    }

    @Override
    protected void setMceIgnorable(McIgnorableNamespaceDeclarator namespacePrefixMapper) {
        namespacePrefixMapper.setMcIgnorable(((Document)this.getJaxbElement()).getIgnorable());
    }

    @Override
    public String getMceIgnorable() {
        return ((Document)this.getJaxbElement()).getIgnorable();
    }

    public List<Object> getContent() {
        if (this.getJaxbElement() == null) {
            this.setJaxbElement(Context.getWmlObjectFactory().createDocument());
        }
        if (((Document)this.getJaxbElement()).getBody() == null) {
            ((Document)this.getJaxbElement()).setBody(Context.getWmlObjectFactory().createBody());
        }
        return ((Document)this.getJaxbElement()).getContent();
    }

    public PropertyResolver getPropertyResolver() {
        return this.getPropertyResolver(true);
    }

    public PropertyResolver getPropertyResolver(boolean create) {
        if (create && this.propertyResolver == null) {
            try {
                this.propertyResolver = new PropertyResolver((WordprocessingMLPackage)this.pack);
            }
            catch (Docx4JException e) {
                e.printStackTrace();
            }
        }
        return this.propertyResolver;
    }

    public StyleTree getStyleTree() {
        return this.getStyleTree(false);
    }

    public StyleTree getStyleTree(boolean refresh) {
        if (refresh || this.styleTree == null) {
            log.debug("Preparing StyleTree");
            HashMap<String, Style> allStyles = new HashMap<String, Style>();
            Styles styles = (Styles)this.getStyleDefinitionsPart().getJaxbElement();
            for (Style s : styles.getStyle()) {
                allStyles.put(s.getStyleId(), s);
            }
            this.styleTree = new StyleTree(this.getStylesInUse(), allStyles, ((Styles)this.getStyleDefinitionsPart().getJaxbElement()).getDocDefaults(), this.getStyleDefinitionsPart().getDefaultParagraphStyle());
        }
        return this.styleTree;
    }

    public Set<String> fontsInUse() {
        log.debug("fontsInUse..");
        this.getPropertyResolver();
        HashSet<String> fontsDiscovered = new HashSet<String>();
        Document wmlDocumentEl = (Document)this.getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        List bodyChildren = body.getContent();
        FontDiscoveryCharacterVisitor visitor = new FontDiscoveryCharacterVisitor(fontsDiscovered);
        RunFontSelector runFontSelector = new RunFontSelector((WordprocessingMLPackage)this.pack, visitor, RunFontSelector.RunFontActionType.DISCOVERY);
        FontAndStyleFinder finder = new FontAndStyleFinder(runFontSelector, fontsDiscovered, null);
        finder.defaultCharacterStyle = this.getStyleDefinitionsPart().getDefaultCharacterStyle();
        finder.defaultParagraphStyle = this.getStyleDefinitionsPart().getDefaultParagraphStyle();
        finder.defaultTableStyle = this.getStyleDefinitionsPart().getDefaultTableStyle();
        finder.styleDefinitionsPart = this.getStyleDefinitionsPart();
        new TraversalUtil(bodyChildren, finder);
        fontsDiscovered.add(runFontSelector.getDefaultFont());
        RelationshipsPart rp = this.getRelationshipsPart();
        if (rp != null) {
            for (Object r : rp.getRelationships().getRelationship()) {
                Part part = rp.getPart((Relationship)r);
                if (part instanceof FooterPart) {
                    Ftr ftr = (Ftr)((FooterPart)part).getJaxbElement();
                    finder.walkJAXBElements(ftr);
                    continue;
                }
                if (!(part instanceof HeaderPart)) continue;
                Hdr hdr = (Hdr)((HeaderPart)part).getJaxbElement();
                finder.walkJAXBElements(hdr);
            }
        }
        if (this.getEndNotesPart() != null) {
            log.debug("Looking at endnotes");
            CTEndnotes endnotes = (CTEndnotes)this.getEndNotesPart().getJaxbElement();
            finder.walkJAXBElements(endnotes);
        }
        if (this.getFootnotesPart() != null) {
            log.debug("Looking at footnotes");
            CTFootnotes footnotes = (CTFootnotes)this.getFootnotesPart().getJaxbElement();
            finder.walkJAXBElements(footnotes);
        }
        if (this.getCommentsPart() != null) {
            log.debug("Looking at comments");
            Comments comments = (Comments)this.getCommentsPart().getJaxbElement();
            finder.walkJAXBElements(comments);
        }
        if (this.getNumberingDefinitionsPart() != null) {
            Numbering numbering = (Numbering)this.getNumberingDefinitionsPart().getJaxbElement();
            for (Numbering.AbstractNum abstractNumNode : numbering.getAbstractNum()) {
                for (Lvl lvl : abstractNumNode.getLvl()) {
                    String fontName;
                    if (lvl.getRPr() == null || lvl.getRPr().getRFonts() == null || (fontName = lvl.getRPr().getRFonts().getAscii()) == null) continue;
                    fontsDiscovered.add(fontName);
                    log.debug("Registered " + fontName + " for abstract list " + abstractNumNode.getAbstractNumId() + " lvl " + lvl.getIlvl());
                }
            }
        }
        if (log.isDebugEnabled()) {
            for (String fontName : fontsDiscovered) {
                log.debug(fontName);
            }
        }
        return fontsDiscovered;
    }

    public Set<String> getStylesInUse() {
        Document wmlDocumentEl = (Document)this.getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        List bodyChildren = body.getContent();
        HashSet<String> stylesInUse = new HashSet<String>();
        FontAndStyleFinder finder = new FontAndStyleFinder(null, null, stylesInUse);
        finder.defaultCharacterStyle = this.getStyleDefinitionsPart().getDefaultCharacterStyle();
        finder.defaultParagraphStyle = this.getStyleDefinitionsPart().getDefaultParagraphStyle();
        finder.defaultTableStyle = this.getStyleDefinitionsPart().getDefaultTableStyle();
        finder.styleDefinitionsPart = this.getStyleDefinitionsPart();
        new TraversalUtil(bodyChildren, finder);
        RelationshipsPart rp = this.getRelationshipsPart();
        if (rp != null) {
            for (Relationship r : rp.getRelationships().getRelationship()) {
                Part part = rp.getPart(r);
                if (part instanceof FooterPart) {
                    Ftr ftr = (Ftr)((FooterPart)part).getJaxbElement();
                    finder.walkJAXBElements(ftr);
                    continue;
                }
                if (!(part instanceof HeaderPart)) continue;
                Hdr hdr = (Hdr)((HeaderPart)part).getJaxbElement();
                finder.walkJAXBElements(hdr);
            }
        }
        if (this.getEndNotesPart() != null) {
            log.debug("Looking at endnotes");
            CTEndnotes endnotes = (CTEndnotes)this.getEndNotesPart().getJaxbElement();
            finder.walkJAXBElements(endnotes);
        }
        if (this.getFootnotesPart() != null) {
            log.debug("Looking at footnotes");
            CTFootnotes footnotes = (CTFootnotes)this.getFootnotesPart().getJaxbElement();
            finder.walkJAXBElements(footnotes);
        }
        if (this.getCommentsPart() != null) {
            log.debug("Looking at comments");
            Comments comments = (Comments)this.getCommentsPart().getJaxbElement();
            finder.walkJAXBElements(comments);
        }
        finder.finish();
        return stylesInUse;
    }

    public P addStyledParagraphOfText(String styleId, String text) {
        P p = this.createStyledParagraphOfText(styleId, text);
        this.addObject(p);
        return p;
    }

    public P createStyledParagraphOfText(String styleId, String text) {
        P p = this.createParagraphOfText(text);
        if (this.getPropertyResolver().activateStyle(styleId)) {
            ObjectFactory factory = Context.getWmlObjectFactory();
            PPr pPr = factory.createPPr();
            p.setPPr(pPr);
            PPrBase.PStyle pStyle = factory.createPPrBasePStyle();
            pPr.setPStyle(pStyle);
            pStyle.setVal(styleId);
        }
        return p;
    }

    public P addParagraphOfText(String simpleText) {
        P para = this.createParagraphOfText(simpleText);
        this.addObject(para);
        return para;
    }

    public P createParagraphOfText(String simpleText) {
        ObjectFactory factory = Context.getWmlObjectFactory();
        P para = factory.createP();
        if (simpleText != null) {
            String[] splits = simpleText.replaceAll("\r", "").split("\n");
            boolean afterNewline = false;
            R run = factory.createR();
            for (String s : splits) {
                if (afterNewline) {
                    Br br = factory.createBr();
                    run.getContent().add(br);
                }
                Text t = factory.createText();
                t.setValue(s);
                if (s.startsWith(" ")) {
                    t.setSpace("preserve");
                } else if (s.endsWith(" ")) {
                    t.setSpace("preserve");
                }
                run.getContent().add(t);
                afterNewline = true;
            }
            para.getContent().add(run);
        }
        return para;
    }

    public void addObject(Object o) {
        this.getContent().add(o);
        HashSet<String> stylesInUse = new HashSet<String>();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(o);
        if (this.styleDefinitionsPart == null) {
            log.info("Style definitions part was null!");
            return;
        }
        FontAndStyleFinder finder = new FontAndStyleFinder(null, null, stylesInUse);
        finder.defaultCharacterStyle = this.getStyleDefinitionsPart().getDefaultCharacterStyle();
        finder.defaultParagraphStyle = this.getStyleDefinitionsPart().getDefaultParagraphStyle();
        finder.styleDefinitionsPart = this.getStyleDefinitionsPart();
        finder.walkJAXBElements(list);
        finder.finish();
        for (String styleName : stylesInUse) {
            log.debug("Inspecting style: " + styleName);
            if (this.getPropertyResolver().activateStyle(styleName)) continue;
            log.info(styleName + " couldn't be activated!");
        }
    }

    public P addParagraph(String pXml) throws JAXBException {
        P para = (P)XmlUtils.unmarshalString(pXml);
        this.getContent().add(para);
        return para;
    }

    public static P.Hyperlink hyperlinkToBookmark(String bookmarkName, String linkText) {
        try {
            String hpl = "<w:hyperlink w:anchor=\"" + bookmarkName + "\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" w:history=\"1\" ><w:r><w:rPr><w:rStyle w:val=\"Hyperlink\" /></w:rPr><w:t>" + linkText + "</w:t></w:r></w:hyperlink>";
            return (P.Hyperlink)XmlUtils.unmarshalString(hpl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void attachTemplate(String templatePath) {
        DocumentSettingsPart dsp = null;
        try {
            dsp = this.getDocumentSettingsPart(true);
        }
        catch (InvalidFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        dsp.attachTemplate(templatePath);
    }

    public GlossaryDocumentPart getGlossaryDocumentPart() {
        return this.glossaryDocumentPart;
    }

    public KeyMapCustomizationsPart getKeyMapCustomizationsPart() {
        return this.keyMapCustomizationsPart;
    }

    @Override
    public boolean setPartShortcut(Part part, String relationshipType) {
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/glossaryDocument")) {
            this.glossaryDocumentPart = (GlossaryDocumentPart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.microsoft.com/office/2006/relationships/keyMapCustomizations")) {
            this.keyMapCustomizationsPart = (KeyMapCustomizationsPart)part;
            return true;
        }
        return super.setPartShortcut(part, relationshipType);
    }

    private class FontDiscoveryCharacterVisitor
    implements RunFontSelector.RunFontCharacterVisitor {
        private Set<String> fontsDiscovered;
        private boolean spanReusable = true;

        FontDiscoveryCharacterVisitor(Set<String> fontsDiscovered) {
            this.fontsDiscovered = fontsDiscovered;
        }

        @Override
        public void fontAction(String fontname) {
            if (fontname == null) {
                log.warn("Got null", new Throwable());
                return;
            }
            String englishFromCJK = CJKToEnglish.toEnglish(fontname);
            if (englishFromCJK == null) {
                this.fontsDiscovered.add(fontname);
            } else {
                this.fontsDiscovered.add(englishFromCJK);
            }
        }

        @Override
        public boolean isReusable() {
            return this.spanReusable;
        }

        @Override
        public void setMustCreateNewFlag(boolean val) {
            this.spanReusable = !val;
        }

        @Override
        public void setDocument(org.w3c.dom.Document document) {
        }

        @Override
        public void addCharacterToCurrent(char c) {
        }

        @Override
        public void addCodePointToCurrent(int cp) {
        }

        @Override
        public void finishPrevious() {
        }

        @Override
        public void createNew() {
        }

        @Override
        public void setRunFontSelector(RunFontSelector runFontSelector) {
        }

        @Override
        public Object getResult() {
            return null;
        }

        @Override
        public void setFallbackFont(String fontname) {
        }
    }

    private static class FontAndStyleFinder
    extends TraversalUtil.CallbackImpl {
        Set<String> fontsDiscovered;
        Set<String> stylesInUse;
        RunFontSelector runFontSelector;
        StyleDefinitionsPart styleDefinitionsPart;
        Style defaultParagraphStyle;
        Style defaultCharacterStyle;
        Style defaultTableStyle;
        private boolean defaultParagraphStyleUsed = false;
        private boolean defaultCharacterStyleUsed = false;
        private boolean defaultTableStyleUsed = false;
        private PPr pPr;
        private RPr rPr;

        FontAndStyleFinder(RunFontSelector runFontSelector, Set<String> fontsDiscovered, Set<String> stylesInUse) {
            this.runFontSelector = runFontSelector;
            this.fontsDiscovered = fontsDiscovered;
            this.stylesInUse = stylesInUse;
        }

        public void finish() {
            if (this.stylesInUse != null) {
                if (this.defaultParagraphStyleUsed && this.defaultParagraphStyle != null) {
                    this.stylesInUse.add(this.defaultParagraphStyle.getStyleId());
                    if (this.defaultParagraphStyle.getRPr() != null && this.defaultParagraphStyle.getRPr().getRStyle() != null) {
                        this.stylesInUse.add(this.defaultParagraphStyle.getRPr().getRStyle().getVal());
                    }
                }
                if (this.defaultCharacterStyleUsed && this.defaultCharacterStyle != null) {
                    this.stylesInUse.add(this.defaultCharacterStyle.getStyleId());
                }
                if (this.defaultTableStyleUsed && this.defaultTableStyle != null) {
                    this.stylesInUse.add(this.defaultTableStyle.getStyleId());
                }
            }
        }

        @Override
        public List<Object> apply(Object o) {
            RPr rPr;
            RStyle rStyle;
            Object o2;
            SdtPr sdtPr;
            if (o instanceof P) {
                this.pPr = ((P)o).getPPr();
                if (this.stylesInUse != null) {
                    boolean customPStyle = false;
                    if (this.pPr != null) {
                        if (this.pPr.getPStyle() != null) {
                            customPStyle = true;
                            this.stylesInUse.add(this.pPr.getPStyle().getVal());
                        }
                        if (this.pPr.getRPr() != null && this.pPr.getRPr().getRStyle() != null) {
                            this.stylesInUse.add(this.pPr.getRPr().getRStyle().getVal());
                        }
                    }
                    this.defaultParagraphStyleUsed = this.defaultParagraphStyleUsed || !customPStyle;
                }
            } else if (o instanceof R) {
                this.rPr = ((R)o).getRPr();
                if (this.stylesInUse != null && this.rPr != null) {
                    if (this.rPr.getRStyle() == null) {
                        this.defaultCharacterStyleUsed = true;
                    } else {
                        this.stylesInUse.add(this.rPr.getRStyle().getVal());
                    }
                }
            } else if (o instanceof Text) {
                if (this.runFontSelector != null) {
                    log.debug(((Text)o).getValue());
                    this.runFontSelector.fontSelector(this.pPr, this.rPr, (Text)o);
                }
            } else if (o instanceof R.Sym) {
                if (this.fontsDiscovered != null) {
                    R.Sym sym = (R.Sym)o;
                    this.fontsDiscovered.add(sym.getFont());
                }
            } else if (o instanceof Tbl) {
                Tbl tbl = (Tbl)o;
                if (this.stylesInUse != null) {
                    boolean customTblStyle = false;
                    if (tbl.getTblPr() != null && tbl.getTblPr().getTblStyle() != null) {
                        customTblStyle = true;
                        this.stylesInUse.add(tbl.getTblPr().getTblStyle().getVal());
                    }
                    this.defaultTableStyleUsed = this.defaultTableStyleUsed || !customTblStyle;
                }
            } else if (o instanceof SdtElement && (sdtPr = ((SdtElement)o).getSdtPr()) != null && (o2 = sdtPr.getByClass(RPr.class)) != null && (rStyle = (rPr = (RPr)o2).getRStyle()) != null && this.stylesInUse != null) {
                this.stylesInUse.add(rStyle.getVal());
                Style pStyle = this.styleDefinitionsPart.getLinkedStyle(rStyle.getVal());
                if (pStyle != null) {
                    this.stylesInUse.add(pStyle.getStyleId());
                }
            }
            return null;
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return !(o instanceof Br) && !(o instanceof R.Tab) && !(o instanceof R.LastRenderedPageBreak);
        }
    }
}

