/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.fields;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.fields.ComplexFieldLocator;
import org.docx4j.model.fields.FieldRef;
import org.docx4j.model.fields.FieldValueException;
import org.docx4j.model.fields.FieldsPreprocessor;
import org.docx4j.model.fields.FldSimpleModel;
import org.docx4j.model.fields.FormattingSwitchHelper;
import org.docx4j.model.fields.SimpleFieldLocator;
import org.docx4j.model.fields.docproperty.DocPropertyResolver;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.relationships.Relationships;
import org.docx4j.wml.CTSimpleField;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldUpdater {
    private static Logger log = LoggerFactory.getLogger(FieldUpdater.class);
    WordprocessingMLPackage wordMLPackage;
    DocPropertyResolver docPropertyResolver;
    StringBuilder report = null;

    public FieldUpdater(WordprocessingMLPackage wordMLPackage) {
        this.wordMLPackage = wordMLPackage;
        this.docPropertyResolver = new DocPropertyResolver(wordMLPackage);
    }

    public void update(boolean processHeadersAndFooters) throws Docx4JException {
        this.report = new StringBuilder();
        this.updatePart(this.wordMLPackage.getMainDocumentPart());
        if (processHeadersAndFooters) {
            RelationshipsPart rp = this.wordMLPackage.getMainDocumentPart().getRelationshipsPart();
            for (Relationship r : ((Relationships)rp.getJaxbElement()).getRelationship()) {
                if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header") && !r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
                JaxbXmlPart part = (JaxbXmlPart)rp.getPart(r);
                this.report.append("\n" + part.getPartName() + "\n");
                log.debug("\n" + part.getPartName() + "\n");
                this.updatePart(part);
            }
        }
        log.info(this.report.toString());
    }

    public void updatePart(JaxbXmlPart part) throws Docx4JException {
        this.updateSimple(part);
        this.updateComplex(part);
    }

    public void updateSimple(JaxbXmlPart part) throws Docx4JException {
        FldSimpleModel fsm = new FldSimpleModel();
        List contentList = ((ContentAccessor)part).getContent();
        WordprocessingMLPackage wmlPackage = (WordprocessingMLPackage)part.getPackage();
        SimpleFieldLocator fl = new SimpleFieldLocator();
        new TraversalUtil(contentList, fl);
        this.report.append("\n\nSimple Fields in " + part.getPartName() + "\n");
        this.report.append("============= \n");
        this.report.append("Found " + fl.simpleFields.size() + " simple fields \n ");
        for (CTSimpleField simpleField : fl.simpleFields) {
            if ("DOCPROPERTY".equals(FormattingSwitchHelper.getFldSimpleName(simpleField.getInstr()))) {
                String val;
                try {
                    fsm.build(simpleField.getInstr());
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
                String key = fsm.getFldParameters().get(0);
                try {
                    val = this.docPropertyResolver.getValue(key);
                }
                catch (FieldValueException e) {
                    this.report.append(simpleField.getInstr() + "\n");
                    this.report.append(key + " -> NOT FOUND! \n");
                    continue;
                }
                if (val == null) {
                    this.report.append(simpleField.getInstr() + "\n");
                    this.report.append(key + " -> NOT FOUND! \n");
                    continue;
                }
                val = FormattingSwitchHelper.applyFormattingSwitch(wmlPackage, fsm, val);
                this.report.append(simpleField.getInstr() + "\n");
                this.report.append("--> " + val + "\n");
                R r = null;
                if (simpleField.getInstr().toUpperCase().contains("MERGEFORMAT")) {
                    r = this.getFirstRun(simpleField.getContent());
                }
                if (r == null) {
                    r = Context.getWmlObjectFactory().createR();
                } else {
                    r.getContent().clear();
                }
                simpleField.getContent().clear();
                simpleField.getContent().add(r);
                Text t = Context.getWmlObjectFactory().createText();
                t.setValue(val);
                r.getContent().add(t);
                continue;
            }
            this.report.append("Ignoring " + simpleField.getInstr() + "\n");
        }
    }

    private R getFirstRun(List<Object> content) {
        for (Object o : content) {
            if (!(o instanceof R)) continue;
            return (R)o;
        }
        return null;
    }

    public void updateComplex(JaxbXmlPart part) throws Docx4JException {
        FldSimpleModel fsm = new FldSimpleModel();
        List contentList = ((ContentAccessor)part).getContent();
        WordprocessingMLPackage wmlPackage = (WordprocessingMLPackage)part.getPackage();
        ComplexFieldLocator fl = new ComplexFieldLocator();
        new TraversalUtil(contentList, fl);
        this.report.append("\n Complex Fields in " + part.getPartName() + "\n");
        this.report.append("============== \n");
        this.report.append("Found " + fl.getStarts().size() + " fields \n");
        ArrayList<FieldRef> fieldRefs = new ArrayList<FieldRef>();
        for (P p : fl.getStarts()) {
            P newP;
            int index;
            if (p.getParent() instanceof ContentAccessor) {
                index = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
                newP = FieldsPreprocessor.canonicalise(p, fieldRefs);
                ((ContentAccessor)p.getParent()).getContent().set(index, newP);
                continue;
            }
            if (p.getParent() instanceof List) {
                index = ((List)p.getParent()).indexOf(p);
                newP = FieldsPreprocessor.canonicalise(p, fieldRefs);
                ((List)p.getParent()).set(index, newP);
                continue;
            }
            throw new Docx4JException("Unexpected parent: " + p.getParent().getClass().getName());
        }
        for (FieldRef fr : fieldRefs) {
            if ("DOCPROPERTY".equals(fr.getFldName())) {
                String instr = this.extractInstr(fr.getInstructions());
                try {
                    fsm.build(instr);
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
                String key = fsm.getFldParameters().get(0);
                String val = this.docPropertyResolver.getValue(key);
                try {
                    val = this.docPropertyResolver.getValue(key);
                }
                catch (FieldValueException e) {
                    this.report.append(instr + "\n");
                    this.report.append(key + " -> NOT FOUND! \n");
                    continue;
                }
                if (val == null) {
                    this.report.append(instr + "\n");
                    this.report.append(key + " -> NOT FOUND! \n");
                    continue;
                }
                val = FormattingSwitchHelper.applyFormattingSwitch(wmlPackage, fsm, val);
                this.report.append(instr + "\n");
                this.report.append("--> " + val + "\n");
                fr.setResult(val);
                continue;
            }
            this.report.append("Ignoring " + fr.getFldName() + "\n");
        }
    }

    private String extractInstr(List<Object> instructions) {
        if (instructions.size() != 1) {
            log.error("TODO DOCPROPERTY field contained complex instruction");
            return null;
        }
        Object o = XmlUtils.unwrap(instructions.get(0));
        if (o instanceof Text) {
            return ((Text)o).getValue();
        }
        if (log.isErrorEnabled()) {
            log.error("TODO: extract field name from " + o.getClass().getName());
            log.error(XmlUtils.marshaltoString(instructions.get(0), true, true));
        }
        return null;
    }

    public static void main(String[] args) throws Docx4JException {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(System.getProperty("user.dir") + "/aq1.docx"));
        FieldUpdater fu = new FieldUpdater(wordMLPackage);
        fu.update(true);
        System.out.println(XmlUtils.marshaltoString(wordMLPackage.getMainDocumentPart().getJaxbElement(), true, true));
    }
}

