/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.sdt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryString {
    private static Logger log = LoggerFactory.getLogger(QueryString.class);

    public static String create(Map<String, String> map) {
        StringBuffer sb = new StringBuffer();
        Iterator<String> iterator = map.keySet().iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (pos > 0) {
                sb.append("&");
            }
            sb.append(key + "=" + map.get(key));
            ++pos;
        }
        return sb.toString();
    }

    public static HashMap<String, String> parseQueryString(String s) {
        return QueryString.parseQueryString(s, false);
    }

    public static HashMap<String, String> parseQueryString(String s, boolean lax) {
        log.debug("Query string: " + s);
        Object valArray = null;
        if (s == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                if (lax) {
                    log.debug("Suspect parameter: " + pair);
                    map.put(pair, pair);
                    continue;
                }
                log.error("Suspect parameter: " + pair);
                throw new IllegalArgumentException();
            }
            String key = QueryString.parseName(pair.substring(0, pos));
            String val = pair.substring(pos + 1, pair.length());
            map.put(key, val);
        }
        return map;
    }

    private static String parseName(String s) {
        StringBuffer sb = new StringBuffer();
        sb.setLength(0);
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block7;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        String rest = s.substring(i);
                        sb.append(rest);
                        if (rest.length() != 2) continue block7;
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

