/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.images;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.docx4j.model.images.AbstractWordXmlPicture;
import org.docx4j.model.images.ConversionImageHandler;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.relationships.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConversionImageHandler
implements ConversionImageHandler {
    protected static Logger log = LoggerFactory.getLogger(AbstractConversionImageHandler.class);
    protected String uuid = UUID.randomUUID().toString();
    protected Map<String, String> handledImagesMap = new TreeMap<String, String>();
    protected String imageDirPath = null;
    protected boolean includeUUID = true;

    protected AbstractConversionImageHandler(String imageDirPath, boolean includeUUID) {
        this.imageDirPath = imageDirPath == null ? System.getProperty("java.io.tmpdir") : imageDirPath;
        this.includeUUID = includeUUID;
    }

    @Override
    public String handleImage(AbstractWordXmlPicture picture, Relationship relationship, BinaryPart part) throws Docx4JException {
        String key = this.createKey(relationship, part);
        String uri = null;
        if (this.handledImagesMap.containsKey(key)) {
            uri = this.handledImagesMap.get(key);
        } else {
            uri = this.doHandleImage(picture, relationship, part);
            this.handledImagesMap.put(key, uri);
        }
        return uri;
    }

    protected String createKey(Relationship relationship, BinaryPart part) {
        return relationship.getTarget();
    }

    protected String doHandleImage(AbstractWordXmlPicture picture, Relationship relationship, BinaryPart part) throws Docx4JException {
        String uri = null;
        uri = this.isInternalImage(picture, relationship, part) ? this.handleInternalImage(picture, relationship, part) : this.handleExternalImage(picture, relationship, part);
        return uri;
    }

    protected boolean isInternalImage(AbstractWordXmlPicture picture, Relationship relationship, BinaryPart part) throws Docx4JException {
        return part != null && (part.getExternalTarget() == null || part.getBuffer() != null);
    }

    protected String handleInternalImage(AbstractWordXmlPicture picture, Relationship relationship, BinaryPart binaryPart) throws Docx4JException {
        byte[] bytes = this.getImageData(binaryPart);
        String uri = null;
        uri = this.imageDirPath.equals("") ? this.createEncodedImage(binaryPart, bytes) : this.createStoredImage(binaryPart, bytes);
        return uri;
    }

    protected abstract String createStoredImage(BinaryPart var1, byte[] var2) throws Docx4JException;

    protected String createEncodedImage(BinaryPart binaryPart, byte[] bytes) throws Docx4JException {
        String uri = null;
        byte[] encoded = Base64.encodeBase64((byte[])bytes, (boolean)true);
        try {
            uri = "data:" + binaryPart.getContentType() + ";base64," + new String(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException uue) {
            uri = "data:" + binaryPart.getContentType() + ";base64," + new String(encoded);
        }
        return uri;
    }

    protected String setupImageName(BinaryPart binaryPart) {
        String filename = this.getImageName(binaryPart);
        filename = this.includeUUID ? this.uuid + filename : filename;
        return filename;
    }

    protected String getImageName(BinaryPart binaryPart) {
        String partname = null;
        int p = -1;
        if (binaryPart.getExternalTarget() != null) {
            partname = binaryPart.getExternalTarget().getValue();
            p = partname.lastIndexOf(92);
            if (p == -1) {
                p = partname.lastIndexOf(47);
            }
        } else {
            partname = binaryPart.getPartName().toString();
            p = partname.lastIndexOf(47);
        }
        return p > -1 ? partname.substring(p + 1) : partname;
    }

    protected byte[] getImageData(BinaryPart binaryPart) {
        return binaryPart.getBytes();
    }

    protected String handleExternalImage(AbstractWordXmlPicture picture, Relationship relationship, BinaryPart part) {
        return relationship.getTarget();
    }

    public void clear() {
        this.uuid = UUID.randomUUID().toString();
        this.handledImagesMap.clear();
    }
}

