/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.ppp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jvnet.jaxb2_commons.ppp.Child;

public class ParentTrackingArrayList<T extends Child>
extends ArrayList<T> {
    private static final long serialVersionUID = 1L;
    private Object parent;

    public ParentTrackingArrayList(Object parent, Class<? extends List<?>> listClass) {
        this.parent = parent;
    }

    public ParentTrackingArrayList(Object parent, Collection<? extends T> c) {
        super(c);
        for (Child element : this) {
            element.setParent(parent);
        }
    }

    public ParentTrackingArrayList(Object parent, int initialCapacity) {
        super(initialCapacity);
        this.parent = parent;
    }

    @Override
    public void add(int index, T element) {
        element.setParent(this.parent);
        super.add(index, element);
    }

    @Override
    public boolean add(T o) {
        o.setParent(this.parent);
        return super.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (Child element : c) {
            element.setParent(this.parent);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        for (Child element : c) {
            element.setParent(this.parent);
        }
        return super.addAll(index, c);
    }

    @Override
    public void clear() {
        for (Child element : this) {
            element.setParent(null);
        }
        super.clear();
    }

    @Override
    public T remove(int index) {
        Child element = (Child)super.remove(index);
        element.setParent(null);
        return (T)element;
    }

    @Override
    public boolean remove(Object o) {
        Child element = (Child)super.get(super.indexOf(o));
        element.setParent(null);
        return super.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Child element : this) {
            if (!c.contains(element)) continue;
            element.setParent(null);
        }
        return super.removeAll(c);
    }

    @Override
    public T set(int index, T element) {
        element.setParent(this.parent);
        return (T)((Child)super.set(index, element));
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        for (int index = fromIndex; index < toIndex; ++index) {
            ((Child)this.get(index)).setParent(null);
        }
        super.removeRange(fromIndex, toIndex);
    }
}

