/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import org.drools.PackageIntegrationException;
import org.drools.RuleBase;
import org.drools.reteoo.RuleBaseImpl;

public class RuleBaseFactory {
    private static RuleBaseFactory INSTANCE = new RuleBaseFactory();

    private RuleBaseFactory() {
    }

    public static RuleBaseFactory getInstance() {
        return INSTANCE;
    }

    public static RuleBase newRuleBase() {
        return RuleBaseFactory.newRuleBase(1);
    }

    public static RuleBase newRuleBase(int type) {
        switch (type) {
            case 1: {
                return new RuleBaseImpl();
            }
            case 2: {
                try {
                    return new org.drools.leaps.RuleBaseImpl();
                }
                catch (PackageIntegrationException e) {
                    throw new IllegalStateException("Unable to create Leaps engine. Error: " + e.getMessage());
                }
            }
        }
        throw new IllegalArgumentException("Unknown engine type: " + type);
    }
}

