/*
 * Decompiled with CFR 0.152.
 */
package org.drools.asm.attrs;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.drools.asm.Attribute;
import org.drools.asm.ByteVector;
import org.drools.asm.ClassReader;
import org.drools.asm.ClassWriter;
import org.drools.asm.Label;
import org.drools.asm.attrs.StackMapFrame;
import org.drools.asm.attrs.StackMapType;

public class StackMapAttribute
extends Attribute {
    static final int MAX_SIZE = 65535;
    public List frames = new ArrayList();

    public StackMapAttribute() {
        super("StackMap");
    }

    public StackMapAttribute(List frames) {
        this();
        this.frames = frames;
    }

    public List getFrames() {
        return this.frames;
    }

    public StackMapFrame getFrame(Label label) {
        for (int i = 0; i < this.frames.size(); ++i) {
            StackMapFrame frame = (StackMapFrame)this.frames.get(i);
            if (frame.label != label) continue;
            return frame;
        }
        return null;
    }

    public boolean isUnknown() {
        return false;
    }

    public boolean isCodeAttribute() {
        return true;
    }

    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        StackMapAttribute attr = new StackMapAttribute();
        boolean isExtCodeSize = cr.readInt(codeOff + 4) > 65535;
        boolean isExtLocals = cr.readUnsignedShort(codeOff + 2) > 65535;
        boolean isExtStack = cr.readUnsignedShort(codeOff) > 65535;
        int size = 0;
        if (isExtCodeSize) {
            size = cr.readInt(off);
            off += 4;
        } else {
            size = cr.readUnsignedShort(off);
            off += 2;
        }
        for (int i = 0; i < size; ++i) {
            int offset;
            if (isExtCodeSize) {
                offset = cr.readInt(off);
                off += 4;
            } else {
                offset = cr.readUnsignedShort(off);
                off += 2;
            }
            Label label = this.getLabel(offset, labels);
            ArrayList locals = new ArrayList();
            ArrayList stack = new ArrayList();
            off = this.readTypeInfo(cr, off, locals, labels, buf, isExtLocals, isExtCodeSize);
            off = this.readTypeInfo(cr, off, stack, labels, buf, isExtStack, isExtCodeSize);
            attr.frames.add(new StackMapFrame(label, locals, stack));
        }
        return attr;
    }

    private int readTypeInfo(ClassReader cr, int off, List info, Label[] labels, char[] buf, boolean isExt, boolean isExtCode) {
        int n = 0;
        if (isExt) {
            n = cr.readInt(off);
            off += 4;
        } else {
            n = cr.readUnsignedShort(off);
            off += 2;
        }
        block4: for (int j = 0; j < n; ++j) {
            int itemType = cr.readByte(off++);
            StackMapType typeInfo = StackMapType.getTypeInfo(itemType);
            info.add(typeInfo);
            switch (itemType) {
                case 7: {
                    typeInfo.setObject(cr.readClass(off, buf));
                    off += 2;
                    continue block4;
                }
                case 8: {
                    int offset;
                    if (isExtCode) {
                        offset = cr.readInt(off);
                        off += 4;
                    } else {
                        offset = cr.readUnsignedShort(off);
                        off += 2;
                    }
                    typeInfo.setLabel(this.getLabel(offset, labels));
                }
            }
        }
        return off;
    }

    private void writeTypeInfo(ByteVector bv, ClassWriter cw, List info, int max) {
        if (max > 65535) {
            bv.putInt(info.size());
        } else {
            bv.putShort(info.size());
        }
        block4: for (int j = 0; j < info.size(); ++j) {
            StackMapType typeInfo = (StackMapType)info.get(j);
            bv.putByte(typeInfo.getType());
            switch (typeInfo.getType()) {
                case 7: {
                    bv.putShort(cw.newClass(typeInfo.getObject()));
                    continue block4;
                }
                case 8: {
                    bv.putShort(typeInfo.getLabel().getOffset());
                }
            }
        }
    }

    private Label getLabel(int offset, Label[] labels) {
        Label l = labels[offset];
        if (l != null) {
            return l;
        }
        labels[offset] = new Label();
        return labels[offset];
    }

    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        ByteVector bv = new ByteVector();
        if (code != null && code.length > 65535) {
            bv.putInt(this.frames.size());
        } else {
            bv.putShort(this.frames.size());
        }
        for (int i = 0; i < this.frames.size(); ++i) {
            this.writeFrame((StackMapFrame)this.frames.get(i), cw, maxStack, maxLocals, bv);
        }
        return bv;
    }

    protected Label[] getLabels() {
        HashSet labels = new HashSet();
        for (int i = 0; i < this.frames.size(); ++i) {
            this.getFrameLabels((StackMapFrame)this.frames.get(i), labels);
        }
        return ((AbstractCollection)labels).toArray(new Label[labels.size()]);
    }

    private void writeFrame(StackMapFrame frame, ClassWriter cw, int maxStack, int maxLocals, ByteVector bv) {
        bv.putShort(frame.label.getOffset());
        this.writeTypeInfo(bv, cw, frame.locals, maxLocals);
        this.writeTypeInfo(bv, cw, frame.stack, maxStack);
    }

    private void getFrameLabels(StackMapFrame frame, Set labels) {
        labels.add(frame.label);
        this.getTypeInfoLabels(labels, frame.locals);
        this.getTypeInfoLabels(labels, frame.stack);
    }

    private void getTypeInfoLabels(Set labels, List info) {
        Iterator it = info.iterator();
        while (it.hasNext()) {
            StackMapType typeInfo = (StackMapType)it.next();
            if (typeInfo.getType() != 8) continue;
            labels.add(typeInfo.getLabel());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StackMap[");
        for (int i = 0; i < this.frames.size(); ++i) {
            sb.append('\n').append('[').append(this.frames.get(i)).append(']');
        }
        sb.append("\n]");
        return sb.toString();
    }
}

