/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import org.drools.RuntimeDroolsException;
import org.drools.base.ClassFieldExtractorFactory;
import org.drools.base.ClassObjectType;
import org.drools.spi.FieldExtractor;
import org.drools.spi.ObjectType;
import org.drools.util.asm.ClassFieldInspector;

public abstract class BaseClassFieldExtractor
implements FieldExtractor {
    private final ClassObjectType objectType;
    private final int index;
    private final Class fieldType;

    public BaseClassFieldExtractor(Class clazz, String fieldName) {
        try {
            ClassFieldInspector inspector = new ClassFieldInspector(clazz);
            this.index = (Integer)inspector.getFieldNames().get(fieldName);
            this.fieldType = (Class)inspector.getFieldTypes().get(fieldName);
            this.objectType = ClassFieldExtractorFactory.getClassObjectType(this.fieldType);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public int getIndex() {
        return this.index;
    }

    protected Class getFieldType() {
        return this.fieldType;
    }

    public abstract Object getValue(Object var1);

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BaseClassFieldExtractor)) {
            return false;
        }
        BaseClassFieldExtractor extr = (BaseClassFieldExtractor)other;
        return this.objectType.equals(extr.objectType) && this.index == extr.index;
    }

    public int hashCode() {
        return this.objectType.hashCode() * 17 + this.index;
    }
}

