/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class DoubleFactory {
    public static Evaluator getDoubleEvaluator(int operator) {
        switch (operator) {
            case 1: {
                return DoubleEqualEvaluator.INSTANCE;
            }
            case 10: {
                return DoubleNotEqualEvaluator.INSTANCE;
            }
            case 20: {
                return DoubleLessEvaluator.INSTANCE;
            }
            case 30: {
                return DoubleLessOrEqualEvaluator.INSTANCE;
            }
            case 40: {
                return DoubleGreaterEvaluator.INSTANCE;
            }
            case 50: {
                return DoubleGreaterOrEqualEvaluator.INSTANCE;
            }
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for DoubleEvaluator");
    }

    static class DoubleGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final Evaluator INSTANCE = new DoubleGreaterOrEqualEvaluator();

        private DoubleGreaterOrEqualEvaluator() {
            super(160, 50);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).doubleValue() >= ((Number)object2).doubleValue();
        }

        public String toString() {
            return "Double >=";
        }
    }

    static class DoubleGreaterEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new DoubleGreaterEvaluator();

        private DoubleGreaterEvaluator() {
            super(160, 40);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).doubleValue() > ((Number)object2).doubleValue();
        }

        public String toString() {
            return "Double >";
        }
    }

    static class DoubleLessOrEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new DoubleLessOrEqualEvaluator();

        private DoubleLessOrEqualEvaluator() {
            super(160, 30);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).doubleValue() <= ((Number)object2).doubleValue();
        }

        public String toString() {
            return "Double <=";
        }
    }

    static class DoubleLessEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new DoubleLessEvaluator();

        private DoubleLessEvaluator() {
            super(160, 20);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).doubleValue() < ((Number)object2).doubleValue();
        }

        public String toString() {
            return "Double <";
        }
    }

    static class DoubleNotEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new DoubleNotEqualEvaluator();

        private DoubleNotEqualEvaluator() {
            super(160, 10);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 != null;
            }
            return !((Number)object1).equals(object2);
        }

        public String toString() {
            return "Double !=";
        }
    }

    static class DoubleEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new DoubleEqualEvaluator();

        private DoubleEqualEvaluator() {
            super(160, 1);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            return ((Number)object1).equals(object2);
        }

        public String toString() {
            return "Double ==";
        }
    }
}

