/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class FloatFactory {
    public static Evaluator getFloatEvaluator(int operator) {
        switch (operator) {
            case 1: {
                return FloatEqualEvaluator.INSTANCE;
            }
            case 10: {
                return FloatNotEqualEvaluator.INSTANCE;
            }
            case 20: {
                return FloatLessEvaluator.INSTANCE;
            }
            case 30: {
                return FloatLessOrEqualEvaluator.INSTANCE;
            }
            case 40: {
                return FloatGreaterEvaluator.INSTANCE;
            }
            case 50: {
                return FloatGreaterOrEqualEvaluator.INSTANCE;
            }
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for FloatEvaluator");
    }

    static class FloatGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final Evaluator INSTANCE = new FloatGreaterOrEqualEvaluator();

        private FloatGreaterOrEqualEvaluator() {
            super(150, 50);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).floatValue() >= ((Number)object2).floatValue();
        }

        public String toString() {
            return "Float >=";
        }
    }

    static class FloatGreaterEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new FloatGreaterEvaluator();

        private FloatGreaterEvaluator() {
            super(150, 40);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).floatValue() > ((Number)object2).floatValue();
        }

        public String toString() {
            return "Float >";
        }
    }

    static class FloatLessOrEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new FloatLessOrEqualEvaluator();

        private FloatLessOrEqualEvaluator() {
            super(150, 30);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).floatValue() <= ((Number)object2).floatValue();
        }

        public String toString() {
            return "Float <=";
        }
    }

    static class FloatLessEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new FloatLessEvaluator();

        private FloatLessEvaluator() {
            super(150, 20);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).floatValue() < ((Number)object2).floatValue();
        }

        public String toString() {
            return "Float <";
        }
    }

    static class FloatNotEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new FloatNotEqualEvaluator();

        private FloatNotEqualEvaluator() {
            super(150, 10);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 != null;
            }
            return !((Number)object1).equals(object2);
        }

        public String toString() {
            return "Float !=";
        }
    }

    static class FloatEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new FloatEqualEvaluator();

        private FloatEqualEvaluator() {
            super(150, 1);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            return ((Number)object1).equals(object2);
        }

        public String toString() {
            return "Float ==";
        }
    }
}

