/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class LongFactory {
    public static Evaluator getLongEvaluator(int operator) {
        switch (operator) {
            case 1: {
                return LongEqualEvaluator.INSTANCE;
            }
            case 10: {
                return LongNotEqualEvaluator.INSTANCE;
            }
            case 20: {
                return LongLessEvaluator.INSTANCE;
            }
            case 30: {
                return LongLessOrEqualEvaluator.INSTANCE;
            }
            case 40: {
                return LongGreaterEvaluator.INSTANCE;
            }
            case 50: {
                return LongGreaterOrEqualEvaluator.INSTANCE;
            }
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for LongEvaluator");
    }

    static class LongGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final Evaluator INSTANCE = new LongGreaterOrEqualEvaluator();

        private LongGreaterOrEqualEvaluator() {
            super(140, 50);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).longValue() >= ((Number)object2).longValue();
        }

        public String toString() {
            return "Long >=";
        }
    }

    static class LongGreaterEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new LongGreaterEvaluator();

        private LongGreaterEvaluator() {
            super(140, 40);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).longValue() > ((Number)object2).longValue();
        }

        public String toString() {
            return "Long >";
        }
    }

    static class LongLessOrEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new LongLessOrEqualEvaluator();

        private LongLessOrEqualEvaluator() {
            super(140, 30);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).longValue() <= ((Number)object2).longValue();
        }

        public String toString() {
            return "Long <=";
        }
    }

    static class LongLessEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new LongLessEvaluator();

        private LongLessEvaluator() {
            super(140, 20);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).longValue() < ((Number)object2).longValue();
        }

        public String toString() {
            return "Long <";
        }
    }

    static class LongNotEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new LongNotEqualEvaluator();

        private LongNotEqualEvaluator() {
            super(140, 10);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 != null;
            }
            return !((Number)object1).equals(object2);
        }

        public String toString() {
            return "Long !=";
        }
    }

    static class LongEqualEvaluator
    extends BaseEvaluator {
        public static final Evaluator INSTANCE = new LongEqualEvaluator();

        private LongEqualEvaluator() {
            super(140, 1);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            return ((Number)object1).equals(object2);
        }

        public String toString() {
            return "Long ==";
        }
    }
}

