/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.base.DefaultKnowledgeHelper;
import org.drools.common.ActivationGroupImpl;
import org.drools.common.ActivationGroupNode;
import org.drools.common.AgendaGroupImpl;
import org.drools.common.AgendaItem;
import org.drools.common.EventSupport;
import org.drools.common.ScheduledAgendaItem;
import org.drools.common.Scheduler;
import org.drools.spi.Activation;
import org.drools.spi.ActivationGroup;
import org.drools.spi.AgendaFilter;
import org.drools.spi.AgendaGroup;
import org.drools.spi.ConsequenceException;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListNode;
import org.drools.util.Queueable;

public class Agenda
implements Serializable {
    private final WorkingMemory workingMemory;
    private LinkedList scheduledActivations;
    private final Map agendaGroups;
    private final Map activationGroups;
    private final java.util.LinkedList focusStack;
    private AgendaGroupImpl currentModule;
    private AgendaGroup main;

    public Agenda(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        this.agendaGroups = new HashMap();
        this.activationGroups = new HashMap();
        this.focusStack = new java.util.LinkedList();
        this.main = new AgendaGroupImpl("MAIN");
        this.agendaGroups.put("MAIN", this.main);
        this.focusStack.add(this.main);
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public void scheduleItem(ScheduledAgendaItem item) {
        Scheduler.getInstance().scheduleAgendaItem(item);
        if (this.scheduledActivations == null) {
            this.scheduledActivations = new LinkedList();
        }
        this.scheduledActivations.add(item);
    }

    public void removeScheduleItem(ScheduledAgendaItem item) {
        this.scheduledActivations.remove(item);
        item.cancel();
    }

    public LinkedList getScheduledItems() {
        return this.scheduledActivations;
    }

    public void addAgendaGroup(AgendaGroup agendaGroup) {
        this.agendaGroups.put(agendaGroup.getName(), agendaGroup);
    }

    public boolean setFocus(AgendaGroup agendaGroup) {
        if (this.focusStack.getLast() != agendaGroup) {
            this.focusStack.add(agendaGroup);
            return true;
        }
        return false;
    }

    public void setFocus(String name) {
        AgendaGroup agendaGroup = (AgendaGroup)this.agendaGroups.get(name);
        if (agendaGroup == null) {
            agendaGroup = new AgendaGroupImpl(name);
            this.workingMemory.getAgenda().addAgendaGroup(agendaGroup);
        }
        this.setFocus(agendaGroup);
    }

    public AgendaGroup getFocus() {
        return (AgendaGroup)this.focusStack.getLast();
    }

    public AgendaGroup getNextFocus() {
        boolean empty;
        AgendaGroupImpl agendaGroup = null;
        while ((empty = (agendaGroup = (AgendaGroupImpl)this.focusStack.getLast()).isEmpty()) && this.focusStack.size() > 1) {
            this.focusStack.removeLast();
        }
        agendaGroup = empty ? null : agendaGroup;
        return agendaGroup;
    }

    public void setCurrentAgendaGroup(AgendaGroup agendaGroup) {
        this.currentModule = (AgendaGroupImpl)agendaGroup;
    }

    public AgendaGroup getCurrentAgendaGroup() {
        return this.currentModule;
    }

    public AgendaGroup getAgendaGroup(String name) {
        return (AgendaGroup)this.agendaGroups.get(name);
    }

    public AgendaGroup[] getAgendaGroups() {
        return this.agendaGroups.values().toArray(new AgendaGroup[this.agendaGroups.size()]);
    }

    public AgendaGroup[] getStack() {
        return this.focusStack.toArray(new AgendaGroup[this.focusStack.size()]);
    }

    public ActivationGroup getActivationGroup(String name) {
        ActivationGroupImpl activationGroup = (ActivationGroupImpl)this.activationGroups.get(name);
        if (activationGroup == null) {
            activationGroup = new ActivationGroupImpl(name);
            this.activationGroups.put(name, activationGroup);
        }
        return activationGroup;
    }

    public int focusStackSize() {
        int size = 0;
        Iterator iterator = this.focusStack.iterator();
        while (iterator.hasNext()) {
            AgendaGroupImpl group = (AgendaGroupImpl)iterator.next();
            size += group.size();
        }
        return size;
    }

    public int agendaSize() {
        int size = 0;
        Iterator iterator = this.agendaGroups.values().iterator();
        while (iterator.hasNext()) {
            AgendaGroupImpl group = (AgendaGroupImpl)iterator.next();
            size += group.size();
        }
        return size;
    }

    public Activation[] getActivations() {
        ArrayList<Activation> list = new ArrayList<Activation>();
        Iterator it = this.agendaGroups.values().iterator();
        while (it.hasNext()) {
            AgendaGroup group = (AgendaGroup)it.next();
            list.addAll(Arrays.asList(group.getActivations()));
        }
        return list.toArray(new Activation[list.size()]);
    }

    public Activation[] getScheduledActivations() {
        ArrayList<LinkedListNode> list = new ArrayList<LinkedListNode>(this.scheduledActivations.size());
        for (LinkedListNode node = this.scheduledActivations.getFirst(); node != null; node = node.getNext()) {
            list.add(node);
        }
        return list.toArray(new Activation[list.size()]);
    }

    public void clearAgenda() {
        Iterator agendaGroupIterator = this.agendaGroups.values().iterator();
        while (agendaGroupIterator.hasNext()) {
            AgendaGroupImpl group = (AgendaGroupImpl)agendaGroupIterator.next();
            this.clearAgendaGroup(group);
        }
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        if (this.scheduledActivations != null && !this.scheduledActivations.isEmpty()) {
            ScheduledAgendaItem item = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            while (item != null) {
                item.remove();
                eventsupport.getAgendaEventSupport().fireActivationCancelled(item);
                item = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            }
        }
    }

    public void clearAgendaGroup(String name) {
        AgendaGroupImpl agendaGroup = (AgendaGroupImpl)this.agendaGroups.get(name);
        if (agendaGroup != null) {
            this.clearAgendaGroup(agendaGroup);
        }
    }

    public void clearAgendaGroup(AgendaGroupImpl agendaGroup) {
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        Queueable[] queueable = agendaGroup.getQueueable();
        int length = queueable.length;
        for (int i = 0; i < length; ++i) {
            AgendaItem item = (AgendaItem)queueable[i];
            if (item == null) continue;
            item.setActivated(false);
            if (item.getActivationGroupNode() != null) {
                item.getActivationGroupNode().getActivationGroup().removeActivation(item);
            }
            eventsupport.getAgendaEventSupport().fireActivationCancelled(item);
        }
        agendaGroup.clear();
    }

    public void clearActivationGroup(String name) {
        ActivationGroup activationGroup = (ActivationGroup)this.activationGroups.get(name);
        if (activationGroup != null) {
            this.clearActivationGroup(activationGroup);
        }
    }

    public void clearActivationGroup(ActivationGroup activationGroup) {
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        Iterator it = activationGroup.iterator();
        while (it.hasNext()) {
            Activation activation = ((ActivationGroupNode)it.next()).getActivation();
            activation.setActivationGroupNode(null);
            if (!activation.isActivated()) continue;
            activation.setActivated(false);
            activation.remove();
            eventsupport.getAgendaEventSupport().fireActivationCancelled(activation);
        }
        activationGroup.clear();
    }

    public boolean fireNextItem(AgendaFilter filter) throws ConsequenceException {
        AgendaGroupImpl group = (AgendaGroupImpl)this.getNextFocus();
        if (group == null) {
            return false;
        }
        AgendaItem item = (AgendaItem)group.getNext();
        if (item == null) {
            return false;
        }
        if (filter == null || filter.accept(item)) {
            this.fireActivation(item);
        }
        return true;
    }

    public synchronized void fireActivation(Activation activation) throws ConsequenceException {
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        eventsupport.getAgendaEventSupport().fireBeforeActivationFired(activation);
        if (activation.getActivationGroupNode() != null) {
            ActivationGroup activationGroup = activation.getActivationGroupNode().getActivationGroup();
            activationGroup.removeActivation(activation);
            this.clearActivationGroup(activationGroup);
        }
        activation.setActivated(false);
        try {
            DefaultKnowledgeHelper knowledgeHelper = new DefaultKnowledgeHelper(activation, this.workingMemory);
            activation.getRule().getConsequence().evaluate(knowledgeHelper, this.workingMemory);
        }
        catch (Exception e) {
            throw new ConsequenceException(e, activation.getRule());
        }
        eventsupport.getAgendaEventSupport().fireAfterActivationFired(activation);
    }
}

