/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.util.Iterator;
import java.util.LinkedList;
import org.drools.common.PropagationContextImpl;
import org.drools.leaps.ConflictResolver;
import org.drools.leaps.FactHandleImpl;
import org.drools.leaps.Handle;
import org.drools.leaps.LeapsTuple;
import org.drools.leaps.RuleHandle;
import org.drools.leaps.RuleTable;
import org.drools.leaps.Token;
import org.drools.leaps.WorkingMemoryImpl;
import org.drools.leaps.util.Table;
import org.drools.leaps.util.TableIterator;

class FactTable
extends Table {
    private final RuleTable rules;
    private boolean reseededStack = false;
    private LinkedList tuples;

    public FactTable(ConflictResolver conflictResolver) {
        super(conflictResolver.getFactConflictResolver());
        this.rules = new RuleTable(conflictResolver.getRuleConflictResolver());
        this.tuples = new LinkedList();
    }

    public void addRule(WorkingMemoryImpl workingMemory, RuleHandle ruleHandle) {
        if (!this.rules.contains(ruleHandle)) {
            this.rules.add(ruleHandle);
            this.checkAndAddFactsToStack(workingMemory);
        }
    }

    public void removeRule(RuleHandle ruleHandle) {
        this.rules.remove(ruleHandle);
        LinkedList<LeapsTuple> list = new LinkedList<LeapsTuple>();
        Iterator it = this.getTuplesIterator();
        while (it.hasNext()) {
            LeapsTuple tuple = (LeapsTuple)it.next();
            if (ruleHandle.getLeapsRule().getRule() == tuple.getLeapsRule().getRule()) continue;
            list.add(tuple);
        }
        this.tuples = list;
    }

    private void checkAndAddFactsToStack(WorkingMemoryImpl workingMemory) {
        if (this.reseededStack) {
            this.setReseededStack(false);
            PropagationContextImpl context = new PropagationContextImpl(workingMemory.nextPropagationIdCounter(), 0, null, null);
            FactHandleImpl startFactHandle = new FactHandleImpl(workingMemory.getIdLastFireAllAt(), null);
            TableIterator it = this.tailIterator(startFactHandle, startFactHandle);
            while (it.hasNext()) {
                FactHandleImpl handle = (FactHandleImpl)it.next();
                workingMemory.pushTokenOnStack(handle, new Token(workingMemory, handle, context));
            }
        }
    }

    public void setReseededStack(boolean reseeded) {
        this.reseededStack = reseeded;
    }

    public Iterator getRulesIterator() {
        return this.rules.iterator();
    }

    public String toString() {
        Handle handle;
        StringBuffer ret = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            handle = (FactHandleImpl)it.next();
            ret.append("\n" + handle + "[" + handle.getObject() + "]");
        }
        ret.append("\nTuples :");
        it = this.tuples.iterator();
        while (it.hasNext()) {
            ret.append("\n" + it.next());
        }
        ret.append("\nRules :");
        it = this.rules.iterator();
        while (it.hasNext()) {
            handle = (RuleHandle)it.next();
            ret.append("\n\t" + ((RuleHandle)handle).getLeapsRule().getRule().getName() + "[dominant - " + ((RuleHandle)handle).getDominantPosition() + "]");
        }
        return ret.toString();
    }

    protected Iterator getTuplesIterator() {
        return this.tuples.iterator();
    }

    protected void addTuple(LeapsTuple tuple) {
        this.tuples.add(tuple);
    }
}

