/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.io.Serializable;
import org.drools.FactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.leaps.FactHandleImpl;
import org.drools.leaps.LeapsRule;
import org.drools.rule.Declaration;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;

class LeapsTuple
implements Tuple,
Serializable {
    private static final long serialVersionUID = 1L;
    private PropagationContext context;
    private boolean readyForActivation;
    private final FactHandleImpl[] factHandles;
    private FactHandleImpl[] blockingNotFactHandles = null;
    private FactHandleImpl[] existsFactHandles = null;
    private Activation activation;
    private final LeapsRule leapsRule;

    LeapsTuple(FactHandleImpl[] factHandles, LeapsRule leapsRule, PropagationContext context) {
        this.factHandles = factHandles;
        this.leapsRule = leapsRule;
        this.context = context;
        if (this.leapsRule != null) {
            int i;
            if (this.leapsRule.containsNotColumns()) {
                this.blockingNotFactHandles = new FactHandleImpl[this.leapsRule.getNotColumnConstraints().length];
                for (i = 0; i < this.blockingNotFactHandles.length; ++i) {
                    this.blockingNotFactHandles[i] = null;
                }
            }
            if (this.leapsRule.containsExistsColumns()) {
                this.existsFactHandles = new FactHandleImpl[this.leapsRule.getExistsColumnConstraints().length];
                for (i = 0; i < this.existsFactHandles.length; ++i) {
                    this.existsFactHandles[i] = null;
                }
            }
        }
        this.readyForActivation = this.leapsRule == null || !this.leapsRule.containsExistsColumns();
    }

    protected LeapsRule getLeapsRule() {
        return this.leapsRule;
    }

    public boolean dependsOn(FactHandle handle) {
        int length = this.factHandles.length;
        for (int i = 0; i < length; ++i) {
            if (!handle.equals(this.factHandles[i])) continue;
            return true;
        }
        return false;
    }

    public InternalFactHandle get(int col) {
        return this.factHandles[col];
    }

    public InternalFactHandle get(Declaration declaration) {
        return this.get(declaration.getColumn());
    }

    public InternalFactHandle[] getFactHandles() {
        return this.factHandles;
    }

    public void setActivation(Activation activation) {
        this.activation = activation;
    }

    protected boolean isActivationNull() {
        return this.activation == null;
    }

    protected Activation getActivation() {
        return this.activation;
    }

    public long getRecency() {
        return 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof LeapsTuple)) {
            return false;
        }
        InternalFactHandle[] thatFactHandles = ((LeapsTuple)object).getFactHandles();
        if (thatFactHandles.length != this.factHandles.length) {
            return false;
        }
        int length = this.factHandles.length;
        for (int i = 0; i < length; ++i) {
            if (this.factHandles[i].equals(thatFactHandles[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isReadyForActivation() {
        return this.readyForActivation;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer("LeapsTuple [" + this.leapsRule.getRule().getName() + "] ");
        int length = this.factHandles.length;
        for (i = 0; i < length; ++i) {
            buffer.append((i == 0 ? "" : ", ") + this.factHandles[i]);
        }
        if (this.existsFactHandles != null) {
            buffer.append("\nExists fact handles by position");
            length = this.existsFactHandles.length;
            for (i = 0; i < length; ++i) {
                buffer.append("\nposition " + i).append(this.existsFactHandles[i]);
            }
        }
        if (this.blockingNotFactHandles != null) {
            buffer.append("\nblockingNot fact handles by position");
            length = this.blockingNotFactHandles.length;
            for (i = 0; i < length; ++i) {
                buffer.append("\nposition " + i).append(this.blockingNotFactHandles[i]);
            }
        }
        return buffer.toString();
    }

    protected void setBlockingNotFactHandle(FactHandleImpl factHandle, int index) {
        this.readyForActivation = false;
        this.blockingNotFactHandles[index] = factHandle;
    }

    protected boolean isBlockingNotFactHandle(int index) {
        return this.blockingNotFactHandles[index] != null;
    }

    protected void removeBlockingNotFactHandle(int index) {
        this.blockingNotFactHandles[index] = null;
        this.setReadyForActivation();
    }

    protected void setExistsFactHandle(FactHandleImpl factHandle, int index) {
        this.existsFactHandles[index] = factHandle;
        this.setReadyForActivation();
    }

    protected boolean isExistsFactHandle(int index) {
        return this.existsFactHandles[index] != null;
    }

    protected void removeExistsFactHandle(int index) {
        this.existsFactHandles[index] = null;
        this.setReadyForActivation();
    }

    private void setReadyForActivation() {
        int i;
        int length;
        this.readyForActivation = true;
        if (this.blockingNotFactHandles != null) {
            length = this.blockingNotFactHandles.length;
            for (i = 0; i < length; ++i) {
                if (this.blockingNotFactHandles[i] == null) continue;
                this.readyForActivation = false;
                return;
            }
        }
        if (this.existsFactHandles != null) {
            length = this.existsFactHandles.length;
            for (i = 0; i < length; ++i) {
                if (this.existsFactHandles[i] != null) continue;
                this.readyForActivation = false;
                return;
            }
        }
    }

    protected PropagationContext getContext() {
        return this.context;
    }

    protected void setContext(PropagationContext context) {
        this.context = context;
    }
}

