/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.io.IOException;
import java.io.ObjectInput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.FactException;
import org.drools.PackageIntegrationException;
import org.drools.WorkingMemory;
import org.drools.common.AbstractRuleBase;
import org.drools.leaps.Builder;
import org.drools.leaps.HandleFactory;
import org.drools.leaps.WorkingMemoryImpl;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Rule;
import org.drools.spi.FactHandleFactory;

public class RuleBaseImpl
extends AbstractRuleBase {
    private static final long serialVersionUID = 1487738104393155409L;
    private Map leapsRules = new HashMap();

    public RuleBaseImpl() throws PackageIntegrationException {
        this(new HandleFactory());
    }

    public RuleBaseImpl(FactHandleFactory factHandleFactory) {
        super(factHandleFactory);
    }

    public WorkingMemory newWorkingMemory() {
        return this.newWorkingMemory(true);
    }

    public WorkingMemory newWorkingMemory(boolean keepReference) {
        WorkingMemoryImpl workingMemory = new WorkingMemoryImpl(this);
        Iterator it = this.leapsRules.values().iterator();
        while (it.hasNext()) {
            workingMemory.addLeapsRules((List)it.next());
        }
        super.addWorkingMemory(workingMemory, keepReference);
        return workingMemory;
    }

    public void addRule(Rule rule) throws FactException, InvalidPatternException {
        super.addRule(rule);
        List rules = Builder.processRule(rule);
        this.leapsRules.put(rule, rules);
        Iterator it = this.getWorkingMemories().iterator();
        while (it.hasNext()) {
            ((WorkingMemoryImpl)it.next()).addLeapsRules(rules);
        }
        it = this.getWorkingMemories().iterator();
        while (it.hasNext()) {
            WorkingMemoryImpl workingMemory = (WorkingMemoryImpl)it.next();
            workingMemory.fireAllRules();
        }
    }

    public void removeRule(Rule rule) {
        Iterator it = this.getWorkingMemories().iterator();
        while (it.hasNext()) {
            ((WorkingMemoryImpl)it.next()).removeRule((List)this.leapsRules.remove(rule));
        }
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        super.readExternal(stream);
        for (int i = 0; i < this.getPackages().length; ++i) {
            Rule[] rules = this.getPackages()[i].getRules();
            for (int j = 0; j < rules.length; ++j) {
                this.addRule(rules[j]);
            }
        }
    }
}

