/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.NoSuchFactObjectException;
import org.drools.QueryResults;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.Agenda;
import org.drools.common.AgendaGroupImpl;
import org.drools.common.AgendaItem;
import org.drools.common.EventSupport;
import org.drools.common.InternalFactHandle;
import org.drools.common.PropagationContextImpl;
import org.drools.common.ScheduledAgendaItem;
import org.drools.leaps.ColumnConstraints;
import org.drools.leaps.FactHandleImpl;
import org.drools.leaps.FactHandleTupleAssembly;
import org.drools.leaps.FactTable;
import org.drools.leaps.HandleFactory;
import org.drools.leaps.LeapsAgenda;
import org.drools.leaps.LeapsQueryResults;
import org.drools.leaps.LeapsRule;
import org.drools.leaps.LeapsTuple;
import org.drools.leaps.NoMatchesFoundException;
import org.drools.leaps.RuleBaseImpl;
import org.drools.leaps.RuleHandle;
import org.drools.leaps.Token;
import org.drools.leaps.TokenEvaluator;
import org.drools.leaps.conflict.DefaultConflictResolver;
import org.drools.leaps.util.TableIterator;
import org.drools.leaps.util.TokenStack;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.AgendaFilter;
import org.drools.spi.AgendaGroup;
import org.drools.spi.Duration;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;
import org.drools.util.IdentityMap;
import org.drools.util.IteratorChain;

class WorkingMemoryImpl
extends AbstractWorkingMemory
implements EventSupport,
PropertyChangeListener {
    private static final long serialVersionUID = -2524904474925421759L;
    protected final Agenda agenda;
    private final Map queryResults;
    private final IdentityMap leapsRulesToHandlesMap = new IdentityMap();
    private final IdentityMap rulesActivationsMap = new IdentityMap();
    private long idLastFireAllAt = -1L;
    private final TokenStack mainStack = new TokenStack();
    private final Map factTables = new Map(){
        private LinkedList tables = new LinkedList();
        private HashMap map = new HashMap();

        public int size() {
            return this.tables.size();
        }

        public void clear() {
            this.tables.clear();
            this.map.clear();
        }

        public boolean isEmpty() {
            return this.tables.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        public Collection values() {
            return this.tables;
        }

        public void putAll(Map t) {
            this.tables.addAll(t.values());
            this.map.putAll(t);
        }

        public Set entrySet() {
            return this.map.entrySet();
        }

        public Set keySet() {
            return this.map.keySet();
        }

        public Object get(Object key) {
            return this.map.get(key);
        }

        public Object remove(Object key) {
            Object ret = this.map.remove(key);
            this.tables.remove(ret);
            return ret;
        }

        public Object put(Object key, Object value) {
            this.tables.add(value);
            this.map.put(key, value);
            return value;
        }
    };

    public WorkingMemoryImpl(RuleBaseImpl ruleBase) {
        super(ruleBase, ruleBase.newFactHandleFactory());
        this.agenda = new LeapsAgenda(this);
        this.agenda.setFocus("MAIN");
        this.queryResults = new HashMap();
    }

    FactHandle newFactHandle(Object object) {
        return ((HandleFactory)this.handleFactory).newFactHandle(object);
    }

    public void setGlobal(String name, Object value) {
        Map applicationDataDefintions = ((RuleBaseImpl)this.ruleBase).getGlobals();
        Class type = (Class)applicationDataDefintions.get(name);
        if (type == null) {
            throw new RuntimeException("Unexpected global [" + name + "]");
        }
        if (!type.isInstance(value)) {
            throw new RuntimeException("Illegal class for global. Expected [" + type.getName() + "], " + "found [" + value.getClass().getName() + "].");
        }
        this.getGlobals().put(name, value);
    }

    public void clearAgenda() {
        this.agenda.clearAgenda();
    }

    public void clearAgendaGroup(String group) {
        this.agenda.clearAgendaGroup(group);
    }

    public Object getObject(FactHandle handle) {
        return ((FactHandleImpl)handle).getObject();
    }

    public List getObjects(Class objectClass) {
        LinkedList<Object> list = new LinkedList<Object>();
        TableIterator it = this.getFactTable(objectClass).iterator();
        while (it.hasNext()) {
            list.add(((FactHandleImpl)it.next()).getObject());
        }
        return list;
    }

    public boolean containsObject(FactHandle handle) {
        return ((FactHandleImpl)handle).getObject() != null;
    }

    public FactHandle assertObject(Object object) throws FactException {
        return this.assertObject(object, false, false, null, null);
    }

    public FactHandle assertLogicalObject(Object object) throws FactException {
        return this.assertObject(object, false, true, null, null);
    }

    public FactHandle assertObject(Object object, boolean dynamic) throws FactException {
        return this.assertObject(object, dynamic, false, null, null);
    }

    public FactHandle assertLogicalObject(Object object, boolean dynamic) throws FactException {
        return this.assertObject(object, dynamic, true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FactHandle assertObject(Object object, boolean dynamic, boolean logical, Rule rule, Activation activation) throws FactException {
        FactHandleImpl handle;
        this.getLock().lock();
        try {
            handle = (FactHandleImpl)this.identityMap.get(object);
            AbstractWorkingMemory.FactStatus logicalState = (AbstractWorkingMemory.FactStatus)this.equalsMap.get(object);
            if (logicalState == null) {
                logicalState = AbstractWorkingMemory.STATUS_NEW;
            }
            if (logical && logicalState.getStatus() == "STATED") {
                FactHandle factHandle = null;
                return factHandle;
            }
            if (logical && logicalState.getStatus() == "JUSTIFIED") {
                this.addLogicalDependency(logicalState.getHandle(), activation, activation.getPropagationContext(), rule);
                InternalFactHandle internalFactHandle = logicalState.getHandle();
                return internalFactHandle;
            }
            if (handle != null && !logical && logicalState.getStatus() == "STATED") {
                FactHandleImpl factHandleImpl = handle;
                return factHandleImpl;
            }
            if (!logical) {
                if (logicalState.getStatus() == "JUSTIFIED") {
                    handle = (FactHandleImpl)logicalState.getHandle();
                    this.removeLogicalDependencies(handle);
                } else {
                    handle = (FactHandleImpl)this.newFactHandle(object);
                }
                this.putObject(handle, object);
                if (logicalState != AbstractWorkingMemory.STATUS_NEW) {
                    logicalState.setStatus("STATED");
                    logicalState.incCounter();
                } else {
                    this.equalsMap.put(object, new AbstractWorkingMemory.FactStatus("STATED", 1));
                }
                if (dynamic) {
                    this.addPropertyChangeListener(object);
                }
            } else {
                handle = (FactHandleImpl)logicalState.getHandle();
                if (handle == null) {
                    handle = (FactHandleImpl)this.newFactHandle(object);
                    this.putObject(handle, object);
                    this.equalsMap.put(object, new AbstractWorkingMemory.FactStatus("JUSTIFIED", handle));
                }
                this.addLogicalDependency(handle, activation, activation.getPropagationContext(), rule);
            }
            PropagationContextImpl context = new PropagationContextImpl(this.nextPropagationIdCounter(), 0, rule, activation);
            this.pushTokenOnStack(handle, new Token(this, handle, context));
            this.workingMemoryEventSupport.fireObjectAsserted(context, handle, object);
            Class<?> objectClass = object.getClass();
            Iterator tables = this.getFactTablesList(objectClass).iterator();
            while (tables.hasNext()) {
                FactTable factTable = (FactTable)tables.next();
                factTable.add(handle);
                Iterator tuples = factTable.getTuplesIterator();
                while (tuples.hasNext()) {
                    ColumnConstraints constraint;
                    int i;
                    int length;
                    LeapsTuple tuple = (LeapsTuple)tuples.next();
                    boolean tupleWasReadyForActivation = tuple.isReadyForActivation();
                    if (!tuple.isActivationNull()) {
                        ColumnConstraints[] not = tuple.getLeapsRule().getNotColumnConstraints();
                        length = not.length;
                        for (i = 0; i < length; ++i) {
                            constraint = not[i];
                            if (tuple.isBlockingNotFactHandle(i) || !constraint.getClassType().isAssignableFrom(objectClass) || !constraint.isAllowed(handle, tuple, this)) continue;
                            tuple.setBlockingNotFactHandle(handle, i);
                            handle.addNotTuple(tuple, i);
                        }
                        if (tuple.isReadyForActivation()) continue;
                        if (tuple.getLeapsRule().getRule() instanceof Query) {
                            this.removeFromQueryResults(tuple.getLeapsRule().getRule().getName(), tuple);
                            continue;
                        }
                        this.invalidateActivation(tuple);
                        continue;
                    }
                    ColumnConstraints[] exists = tuple.getLeapsRule().getExistsColumnConstraints();
                    length = exists.length;
                    for (i = 0; i < length; ++i) {
                        constraint = exists[i];
                        if (tuple.isExistsFactHandle(i) || !constraint.getClassType().isAssignableFrom(objectClass) || !constraint.isAllowed(handle, tuple, this)) continue;
                        tuple.setExistsFactHandle(handle, i);
                        handle.addExistsTuple(tuple, i);
                    }
                    if (!tuple.isReadyForActivation() || tupleWasReadyForActivation) continue;
                    tuple.setContext(new PropagationContextImpl(this.nextPropagationIdCounter(), 0, tuple.getLeapsRule().getRule(), null));
                    this.assertTuple(tuple);
                }
            }
            this.propagateQueuedActions();
        }
        finally {
            this.getLock().unlock();
        }
        return handle;
    }

    void putObject(FactHandle handle, Object object) {
        this.identityMap.put(object, handle);
    }

    Object removeObject(FactHandle handle) {
        this.identityMap.remove(((FactHandleImpl)handle).getObject());
        return ((FactHandleImpl)handle).getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retractObject(FactHandle handle, boolean removeLogical, boolean updateEqualsMap, Rule rule, Activation activation) throws FactException {
        this.getLock().lock();
        try {
            LeapsTuple tuple;
            FactHandleTupleAssembly assembly;
            AbstractWorkingMemory.FactStatus status;
            this.removePropertyChangeListener(handle);
            Object oldObject = this.removeObject(handle);
            if (removeLogical) {
                this.removeLogicalDependencies(handle);
            }
            if ((removeLogical || updateEqualsMap) && (status = (AbstractWorkingMemory.FactStatus)this.equalsMap.get(oldObject)) != null) {
                status.decCounter();
                if (status.getCounter() <= 0) {
                    this.equalsMap.remove(oldObject);
                }
            }
            Iterator it = this.getFactTablesList(((FactHandleImpl)handle).getObject().getClass()).iterator();
            while (it.hasNext()) {
                ((FactTable)it.next()).remove(handle);
            }
            Iterator tuples = ((FactHandleImpl)handle).getActivatedTuples();
            while (tuples != null && tuples.hasNext()) {
                LeapsTuple tuple2 = (LeapsTuple)tuples.next();
                if (tuple2.getLeapsRule().getRule() instanceof Query) {
                    this.removeFromQueryResults(tuple2.getLeapsRule().getRule().getName(), tuple2);
                    continue;
                }
                this.invalidateActivation(tuple2);
            }
            IdentityMap tuplesNotReadyForActivation = new IdentityMap();
            Iterator it2 = ((FactHandleImpl)handle).getNotTupleAssemblies();
            if (it2 != null) {
                while (it2.hasNext()) {
                    assembly = (FactHandleTupleAssembly)it2.next();
                    tuple = assembly.getTuple();
                    if (!tuple.isReadyForActivation()) {
                        tuplesNotReadyForActivation.put(tuple, tuple);
                    }
                    tuple.removeBlockingNotFactHandle(assembly.getIndex());
                    TokenEvaluator.evaluateNotCondition(new FactHandleImpl(((FactHandleImpl)handle).getId() + 1L, null), assembly.getIndex(), tuple, this);
                }
            }
            if ((it2 = ((FactHandleImpl)handle).getExistsTupleAssemblies()) != null) {
                while (it2.hasNext()) {
                    assembly = (FactHandleTupleAssembly)it2.next();
                    tuple = assembly.getTuple();
                    if (!tuple.isReadyForActivation()) {
                        tuplesNotReadyForActivation.put(tuple, tuple);
                    }
                    tuple.removeExistsFactHandle(assembly.getIndex());
                    TokenEvaluator.evaluateExistsCondition(new FactHandleImpl(((FactHandleImpl)handle).getId() + 1L, null), assembly.getIndex(), tuple, this);
                }
            }
            IteratorChain chain = new IteratorChain();
            it2 = ((FactHandleImpl)handle).getNotTupleAssemblies();
            if (it2 != null) {
                chain.addIterator(it2);
            }
            if ((it2 = ((FactHandleImpl)handle).getExistsTupleAssemblies()) != null) {
                chain.addIterator(it2);
            }
            while (chain.hasNext()) {
                tuple = ((FactHandleTupleAssembly)chain.next()).getTuple();
                if (tuple.isReadyForActivation() && tuple.isActivationNull() && tuplesNotReadyForActivation.containsKey(tuple)) {
                    tuple.setContext(new PropagationContextImpl(this.nextPropagationIdCounter(), 0, tuple.getLeapsRule().getRule(), null));
                    this.assertTuple(tuple);
                    continue;
                }
                if (tuple.getLeapsRule().getRule() instanceof Query) {
                    this.removeFromQueryResults(tuple.getLeapsRule().getRule().getName(), tuple);
                    continue;
                }
                this.invalidateActivation(tuple);
            }
            this.removeTokenFromStack((FactHandleImpl)handle);
            PropagationContextImpl context = new PropagationContextImpl(this.nextPropagationIdCounter(), 1, rule, activation);
            this.workingMemoryEventSupport.fireObjectRetracted(context, handle, oldObject);
            this.propagateQueuedActions();
        }
        finally {
            this.getLock().unlock();
        }
    }

    private final void invalidateActivation(LeapsTuple tuple) {
        Activation activation = tuple.getActivation();
        if (!tuple.isReadyForActivation() && !tuple.isActivationNull()) {
            if (activation.isActivated()) {
                activation.remove();
                this.getAgendaEventSupport().fireActivationCancelled(activation);
            }
            tuple.setActivation(null);
        }
        if (activation != null) {
            this.removeLogicalDependencies(activation, tuple.getContext(), tuple.getLeapsRule().getRule());
        }
    }

    public void addLogicalDependency(FactHandle handle, Activation activation, PropagationContext context, Rule rule) throws FactException {
        super.addLogicalDependency(handle, activation, context, rule);
        LinkedList<Activation> activations = (LinkedList<Activation>)this.rulesActivationsMap.get(rule);
        if (activations == null) {
            activations = new LinkedList<Activation>();
            this.rulesActivationsMap.put(rule, activations);
        }
        activations.add(activation);
    }

    public void removeLogicalDependencies(Activation activation, PropagationContext context, Rule rule) throws FactException {
        super.removeLogicalDependencies(activation, context, rule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyObject(FactHandle handle, Object object, Rule rule, Activation activation) throws FactException {
        this.getLock().lock();
        try {
            this.retractObject(handle);
            Object originalObject = this.removeObject(handle);
            if (originalObject == null) {
                throw new NoSuchFactObjectException(handle);
            }
            FactHandleImpl handleImpl = (FactHandleImpl)this.assertObject(object, false, false, rule, activation);
            if (this.justified.get(handleImpl.getId()) != null) {
                this.equalsMap.remove(originalObject);
                this.equalsMap.put(object, new AbstractWorkingMemory.FactStatus("JUSTIFIED", handleImpl));
            }
            this.workingMemoryEventSupport.fireObjectModified(new PropagationContextImpl(this.nextPropagationIdCounter(), 2, rule, activation), handle, ((FactHandleImpl)handle).getObject(), object);
            this.propagateQueuedActions();
        }
        finally {
            this.getLock().unlock();
        }
    }

    protected final List getFactTablesList(Class c) {
        ArrayList<FactTable> list = new ArrayList<FactTable>();
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            list.add(this.getFactTable(interfaces[i]));
        }
        for (Class bufClass = c; bufClass != null; bufClass = bufClass.getSuperclass()) {
            list.add(this.getFactTable(bufClass));
        }
        return list;
    }

    protected final void pushTokenOnStack(FactHandleImpl factHandle, Token token) {
        this.mainStack.push(token);
    }

    protected final void removeTokenFromStack(FactHandleImpl factHandle) {
        this.mainStack.remove(factHandle.getId());
    }

    protected final Token peekTokenOnTop() {
        return (Token)this.mainStack.peek();
    }

    protected FactTable getFactTable(Class c) {
        FactTable table;
        if (this.factTables.containsKey(c)) {
            table = (FactTable)this.factTables.get(c);
        } else {
            table = new FactTable(DefaultConflictResolver.getInstance());
            this.factTables.put(c, table);
            Iterator iter = this.leapsRulesToHandlesMap.keySet().iterator();
            while (iter.hasNext()) {
                LeapsRule leapsRule = (LeapsRule)iter.next();
                if (leapsRule.getNumberOfColumns() <= 0) continue;
                List rulesHandles = (List)this.leapsRulesToHandlesMap.get(leapsRule);
                Iterator handles = rulesHandles.iterator();
                while (handles.hasNext()) {
                    RuleHandle handle = (RuleHandle)handles.next();
                    if (!leapsRule.getColumnClassObjectTypeAtPosition(handle.getDominantPosition()).isAssignableFrom(c)) continue;
                    table.addRule(this, handle);
                }
            }
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addLeapsRules(List rules) {
        this.getLock().lock();
        try {
            Iterator it = rules.iterator();
            while (it.hasNext()) {
                LeapsRule rule = (LeapsRule)it.next();
                if (rule.getNumberOfColumns() > 0) {
                    ArrayList<RuleHandle> ruleHandlesList = new ArrayList<RuleHandle>();
                    for (int i = 0; i < rule.getNumberOfColumns(); ++i) {
                        RuleHandle ruleHandle = new RuleHandle(((HandleFactory)this.handleFactory).getNextId(), rule, i);
                        this.getFactTable(rule.getColumnClassObjectTypeAtPosition(i)).addRule(this, ruleHandle);
                        ruleHandlesList.add(ruleHandle);
                    }
                    this.leapsRulesToHandlesMap.put(rule, ruleHandlesList);
                    continue;
                }
                PropagationContextImpl context = new PropagationContextImpl(this.nextPropagationIdCounter(), 0, null, null);
                TokenEvaluator.processAfterAllPositiveConstraintOk(new LeapsTuple(new FactHandleImpl[0], rule, context), rule, this);
            }
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRule(List rules) {
        this.getLock().lock();
        try {
            Iterator it = rules.iterator();
            while (it.hasNext()) {
                LeapsRule leapsRule = (LeapsRule)it.next();
                if (leapsRule.getNumberOfColumns() <= 0) continue;
                ArrayList ruleHandlesList = (ArrayList)this.leapsRulesToHandlesMap.remove(leapsRule);
                for (int i = 0; i < ruleHandlesList.size(); ++i) {
                    RuleHandle ruleHandle = (RuleHandle)ruleHandlesList.get(i);
                    this.getFactTable(leapsRule.getColumnClassObjectTypeAtPosition(i)).removeRule(ruleHandle);
                }
            }
            Rule rule = ((LeapsRule)rules.get(0)).getRule();
            List activations = (List)this.rulesActivationsMap.remove(rule);
            if (activations != null) {
                Iterator activationsIt = activations.iterator();
                while (activationsIt.hasNext()) {
                    Activation activation = (Activation)activationsIt.next();
                    ((LeapsTuple)activation.getTuple()).setActivation(null);
                    this.removeLogicalDependencies(activation, activation.getPropagationContext(), rule);
                }
            }
            this.propagateQueuedActions();
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void fireAllRules(AgendaFilter agendaFilter) throws FactException {
        if (!this.firing) {
            try {
                this.firing = true;
                boolean nothingToProcess = false;
                while (!nothingToProcess) {
                    while (!this.mainStack.empty()) {
                        Token token = this.peekTokenOnTop();
                        boolean done = false;
                        while (!done) {
                            if (!token.isResume()) {
                                if (token.hasNextRuleHandle()) {
                                    token.nextRuleHandle();
                                } else {
                                    this.removeTokenFromStack(token.getDominantFactHandle());
                                    done = true;
                                }
                            }
                            if (!done) {
                                try {
                                    TokenEvaluator.evaluate(token);
                                    if (token.getDominantFactHandle() != null) {
                                        token.setResume(true);
                                        done = true;
                                    }
                                }
                                catch (NoMatchesFoundException ex) {
                                    token.setResume(false);
                                }
                            }
                            while (this.agenda.fireNextItem(agendaFilter)) {
                            }
                        }
                    }
                    while (this.agenda.fireNextItem(agendaFilter)) {
                    }
                    if (!this.mainStack.empty()) continue;
                    nothingToProcess = true;
                }
                this.idLastFireAllAt = ((HandleFactory)this.handleFactory).getNextId();
                Iterator it = this.factTables.values().iterator();
                while (it.hasNext()) {
                    ((FactTable)it.next()).setReseededStack(true);
                }
            }
            finally {
                this.firing = false;
            }
        }
    }

    protected final long getIdLastFireAllAt() {
        return this.idLastFireAllAt;
    }

    public String toString() {
        String ret = "";
        ret = ret + "\n" + "Working memory";
        ret = ret + "\n" + "Fact Tables by types:";
        Iterator it = this.factTables.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            ret = ret + "\n" + "******************   " + key;
            ret = ret + ((FactTable)this.factTables.get(key)).toString();
        }
        ret = ret + "\n" + "Stack:";
        it = this.mainStack.iterator();
        while (it.hasNext()) {
            ret = ret + "\n" + "\t" + it.next();
        }
        return ret;
    }

    public final void assertTuple(LeapsTuple tuple) {
        PropagationContext context = tuple.getContext();
        Rule rule = tuple.getLeapsRule().getRule();
        if (rule.getNoLoop() && rule.equals(context.getRuleOrigin())) {
            return;
        }
        Duration dur = rule.getDuration();
        if (dur != null && dur.getDuration(tuple) > 0L) {
            ScheduledAgendaItem agendaItem = new ScheduledAgendaItem(context.getPropagationNumber(), tuple, this.agenda, context, rule);
            this.agenda.scheduleItem(agendaItem);
            tuple.setActivation(agendaItem);
            agendaItem.setActivated(true);
            this.getAgendaEventSupport().fireActivationCreated(agendaItem);
        } else {
            LeapsRule leapsRule = tuple.getLeapsRule();
            AgendaGroupImpl agendaGroup = leapsRule.getAgendaGroup();
            if (agendaGroup == null) {
                agendaGroup = rule.getAgendaGroup() == null || rule.getAgendaGroup().equals("") || rule.getAgendaGroup().equals("MAIN") ? (AgendaGroupImpl)this.agenda.getAgendaGroup("MAIN") : (AgendaGroupImpl)this.agenda.getAgendaGroup(rule.getAgendaGroup());
                if (agendaGroup == null) {
                    agendaGroup = new AgendaGroupImpl(rule.getAgendaGroup());
                    this.getAgenda().addAgendaGroup(agendaGroup);
                }
                leapsRule.setAgendaGroup(agendaGroup);
            }
            if (rule.getAutoFocus()) {
                this.agenda.setFocus(agendaGroup);
            }
            AgendaItem agendaItem = new AgendaItem(context.getPropagationNumber(), tuple, context, rule);
            agendaGroup.add(agendaItem);
            tuple.setActivation(agendaItem);
            agendaItem.setActivated(true);
            this.getAgendaEventSupport().fireActivationCreated(agendaItem);
            FactHandleImpl[] factHandles = (FactHandleImpl[])tuple.getFactHandles();
            for (int i = 0; i < factHandles.length; ++i) {
                factHandles[i].addActivatedTuple(tuple);
            }
        }
    }

    protected long nextPropagationIdCounter() {
        return ++this.propagationIdCounter;
    }

    public void dispose() {
        ((RuleBaseImpl)this.ruleBase).disposeWorkingMemory(this);
    }

    public QueryResults getQueryResults(String queryName) {
        IdentityMap map = (IdentityMap)this.queryResults.get(queryName);
        if (map == null) {
            return null;
        }
        LinkedList list = new LinkedList();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        if (!list.isEmpty()) {
            Query queryRule = (Query)((LeapsTuple)list.get(0)).getLeapsRule().getRule();
            return new LeapsQueryResults(list, queryRule, this);
        }
        return null;
    }

    void addToQueryResults(String query, Tuple tuple) {
        IdentityMap map = (IdentityMap)this.queryResults.get(query);
        if (map == null) {
            map = new IdentityMap();
            this.queryResults.put(query, map);
        }
        map.put(tuple, tuple);
    }

    void removeFromQueryResults(String query, Tuple tuple) {
        IdentityMap map = (IdentityMap)this.queryResults.get(query);
        if (map != null) {
            map.remove(tuple);
        }
    }

    public AgendaGroup getFocus() {
        return this.agenda.getFocus();
    }

    public void setFocus(String focus) {
        this.agenda.setFocus(focus);
    }

    public void setFocus(AgendaGroup focus) {
        this.agenda.setFocus(focus);
    }

    public Agenda getAgenda() {
        return this.agenda;
    }
}

