/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps.util;

import java.util.NoSuchElementException;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.leaps.ColumnConstraints;
import org.drools.leaps.util.TableIterator;
import org.drools.leaps.util.TableRecord;

public class ConstrainedFactTableIterator
implements TableIterator {
    private boolean finishInitialPass = false;
    final WorkingMemory workingMemory;
    final ColumnConstraints constraints;
    private int size = 0;
    private TableRecord firstRecord;
    private TableRecord lastRecord;
    private TableRecord currentRecord;
    private TableRecord nextRecord;
    private TableRecord currentTableRecord;
    private TableRecord lastTableRecord;

    protected ConstrainedFactTableIterator(WorkingMemory workingMemory, ColumnConstraints constraints, TableRecord startRecord, TableRecord currentRecord, TableRecord lastRecord) {
        this.workingMemory = workingMemory;
        this.constraints = constraints;
        this.lastTableRecord = lastRecord;
        this.currentTableRecord = startRecord;
        boolean done = false;
        boolean reachCurrentRecord = false;
        while (!done && this.currentTableRecord != null && !this.finishInitialPass) {
            if (!reachCurrentRecord && this.currentTableRecord == currentRecord) {
                reachCurrentRecord = true;
                continue;
            }
            if (this.constraints.isAllowedAlpha((InternalFactHandle)this.currentTableRecord.object, null, this.workingMemory)) {
                this.add(this.currentTableRecord.object);
            }
            if (reachCurrentRecord && !this.isEmpty()) {
                done = true;
            }
            if (this.currentTableRecord == this.lastTableRecord) {
                this.finishInitialPass = true;
            }
            this.currentTableRecord = this.currentTableRecord.right;
        }
        this.nextRecord = this.lastRecord;
    }

    private void add(Object object) {
        TableRecord record = new TableRecord(object);
        if (this.firstRecord == null) {
            this.firstRecord = record;
            this.lastRecord = record;
        } else {
            this.lastRecord.right = record;
            record.left = this.lastRecord;
            this.lastRecord = record;
        }
        ++this.size;
    }

    public boolean isEmpty() {
        return this.firstRecord == null;
    }

    public void reset() {
        this.currentRecord = null;
        this.nextRecord = this.firstRecord;
    }

    public Object next() {
        this.currentRecord = this.nextRecord;
        if (this.currentRecord == null) {
            throw new NoSuchElementException("No more elements to return");
        }
        this.nextRecord = this.currentRecord.right;
        return this.currentRecord.object;
    }

    public Object current() {
        return this.currentRecord.object;
    }

    public Object peekNext() {
        return this.nextRecord.object;
    }

    public void remove() {
    }

    public boolean hasNext() {
        if (!this.finishInitialPass) {
            if (this.nextRecord == null) {
                boolean found = false;
                while (!found && this.currentTableRecord != null) {
                    if (this.constraints.isAllowedAlpha((InternalFactHandle)this.currentTableRecord.object, null, this.workingMemory)) {
                        this.add(this.currentTableRecord.object);
                        found = true;
                    }
                    if (this.currentTableRecord == this.lastTableRecord) {
                        this.finishInitialPass = true;
                    }
                    this.currentTableRecord = this.currentTableRecord.right;
                }
                if (found) {
                    this.nextRecord = this.lastRecord;
                }
                return found;
            }
            return true;
        }
        return this.nextRecord != null;
    }
}

