/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps.util;

import java.util.EmptyStackException;
import java.util.Iterator;
import org.drools.leaps.Token;
import org.drools.leaps.util.TableRecord;
import org.drools.util.PrimitiveLongMap;

public class TokenStack {
    protected TableRecord tailRecord = null;
    private PrimitiveLongMap map = new PrimitiveLongMap();

    public boolean empty() {
        return this.tailRecord == null;
    }

    public Object peek() {
        if (this.tailRecord != null) {
            return this.tailRecord.object;
        }
        throw new EmptyStackException();
    }

    public Object pop() {
        if (this.tailRecord != null) {
            Object ret = this.tailRecord.object;
            TableRecord buf = this.tailRecord;
            this.tailRecord = buf.left;
            if (buf.left != null) {
                this.tailRecord.right = null;
            }
            buf.left = null;
            this.map.remove(((Token)ret).getDominantFactHandle().getId());
            return ret;
        }
        throw new EmptyStackException();
    }

    public void remove(long factId) {
        TableRecord record;
        if (this.tailRecord != null && (record = (TableRecord)this.map.remove(factId)) != null) {
            if (record == this.tailRecord) {
                this.tailRecord = record.left;
            }
            if (record.left != null) {
                record.left.right = record.right;
            }
            if (record.right != null) {
                record.right.left = record.left;
            }
            record.left = null;
            record.right = null;
        }
    }

    public Object push(Object item) {
        TableRecord record = new TableRecord(item);
        if (this.tailRecord != null) {
            this.tailRecord.right = record;
            record.left = this.tailRecord;
        }
        this.tailRecord = record;
        this.map.put(((Token)item).getDominantFactHandle().getId(), record);
        return item;
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator it;
            {
                this.it = TokenStack.this.map.values().iterator();
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public void remove() {
            }

            public Object next() {
                return this.it.next();
            }
        };
    }
}

