/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.ClassFieldExtractor;
import org.drools.base.ClassObjectType;
import org.drools.base.EvaluatorFactory;
import org.drools.base.FieldFactory;
import org.drools.common.BetaNodeBinder;
import org.drools.common.InstanceEqualsConstraint;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.EvalConditionNode;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.NotNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.QueryTerminalNode;
import org.drools.reteoo.Rete;
import org.drools.reteoo.RightInputAdapterNode;
import org.drools.reteoo.RuleBaseImpl;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.rule.And;
import org.drools.rule.Column;
import org.drools.rule.Declaration;
import org.drools.rule.EvalCondition;
import org.drools.rule.Exists;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Not;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldConstraint;
import org.drools.spi.FieldValue;
import org.drools.spi.ObjectTypeResolver;

class ReteooBuilder
implements Serializable {
    private transient RuleBaseImpl ruleBase;
    private transient Rete rete;
    private transient WorkingMemoryImpl[] workingMemories;
    private final ObjectTypeResolver resolver;
    private final Map attachedNodes;
    private TupleSource tupleSource;
    private ObjectSource objectSource;
    private Map declarations;
    private int id;
    private Map rules;
    private Map objectType;
    private int currentOffsetAdjustment;
    static /* synthetic */ Class class$org$drools$InitialFact;
    static /* synthetic */ Class class$org$drools$base$DroolsQuery;

    ReteooBuilder(RuleBaseImpl ruleBase, ObjectTypeResolver resolver) {
        this.ruleBase = ruleBase;
        this.rete = this.ruleBase.getRete();
        this.resolver = resolver;
        this.attachedNodes = new HashMap();
        this.rules = new HashMap();
        this.id = 1;
    }

    void setRuleBase(RuleBaseImpl ruleBase) {
        this.ruleBase = ruleBase;
    }

    void setRete(Rete rete) {
    }

    void addRule(Rule rule) throws InvalidPatternException {
        this.workingMemories = this.ruleBase.getWorkingMemories().toArray(new WorkingMemoryImpl[this.ruleBase.getWorkingMemories().size()]);
        this.currentOffsetAdjustment = 0;
        ArrayList<BaseNode> nodes = new ArrayList<BaseNode>();
        And[] and = rule.getTransformedLhs();
        for (int i = 0; i < and.length; ++i) {
            if (!this.hasColumns(and[i])) {
                this.addInitialFactMatch(and[i]);
            }
            this.addRule(and[i], rule);
            BaseNode node = null;
            if (!(rule instanceof Query)) {
                if (rule.getConsequence() == null) {
                    throw new InvalidPatternException("Rule '" + rule.getName() + "' has no Consequence");
                }
                node = new TerminalNode(this.id++, this.tupleSource, rule);
            } else {
                if (rule.getConsequence() != null) {
                    throw new InvalidPatternException("Query '" + rule.getName() + "' should have no Consequence");
                }
                node = new QueryTerminalNode(this.id++, this.tupleSource, rule);
            }
            nodes.add(node);
            if (this.workingMemories.length == 0) {
                node.attach();
                continue;
            }
            node.attach(this.workingMemories);
        }
        this.rules.put(rule, nodes.toArray(new BaseNode[nodes.size()]));
    }

    private boolean hasColumns(GroupElement ge) {
        Iterator it = ge.getChildren().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (!(object instanceof Column) && (!(object instanceof GroupElement) || !this.hasColumns((GroupElement)object))) continue;
            return true;
        }
        return false;
    }

    private void addInitialFactMatch(And and) {
        And temp = null;
        if (!and.getChildren().isEmpty()) {
            temp = (And)and.clone();
            and.getChildren().clear();
        }
        Column column = new Column(0, new ClassObjectType(class$org$drools$InitialFact == null ? (class$org$drools$InitialFact = ReteooBuilder.class$("org.drools.InitialFact")) : class$org$drools$InitialFact));
        and.addChild(column);
        if (temp != null) {
            and.getChildren().addAll(temp.getChildren());
        }
    }

    private void addRule(And and, Rule rule) throws InvalidPatternException {
        this.objectSource = null;
        this.tupleSource = null;
        this.declarations = new HashMap();
        this.objectType = new LinkedHashMap();
        if (rule instanceof Query) {
            this.attachQuery(rule.getName());
        }
        Iterator it = and.getChildren().iterator();
        while (it.hasNext()) {
            BetaNodeBinder binder;
            Column column;
            Object object = it.next();
            if (object instanceof EvalCondition) {
                EvalCondition eval = (EvalCondition)object;
                this.checkUnboundDeclarations(eval.getRequiredDeclarations());
                this.tupleSource = this.attachNode(new EvalConditionNode(this.id++, this.tupleSource, eval));
                continue;
            }
            if (object instanceof Column) {
                column = (Column)object;
                binder = this.attachColumn((Column)object, and, true);
                if (this.tupleSource == null) {
                    this.tupleSource = this.attachNode(new LeftInputAdapterNode(this.id++, this.objectSource, binder));
                    this.objectSource = null;
                }
            } else {
                GroupElement ce = (GroupElement)object;
                while (!(ce.getChildren().get(0) instanceof Column)) {
                    ce = (GroupElement)ce.getChildren().get(0);
                }
                column = (Column)ce.getChildren().get(0);
                if (this.tupleSource == null) {
                    this.currentOffsetAdjustment = 1;
                    ObjectSource objectSource = this.attachNode(new ObjectTypeNode(this.id++, new ClassObjectType(class$org$drools$InitialFact == null ? ReteooBuilder.class$("org.drools.InitialFact") : class$org$drools$InitialFact), this.rete));
                    this.tupleSource = this.attachNode(new LeftInputAdapterNode(this.id++, objectSource));
                }
                binder = this.attachColumn(column, and, false);
            }
            if (object instanceof Not) {
                this.attachNot(this.tupleSource, (Not)object, this.objectSource, binder, column);
                continue;
            }
            if (object instanceof Exists) {
                this.attachExists(this.tupleSource, (Exists)object, this.objectSource, binder, column);
                continue;
            }
            if (this.objectSource == null) continue;
            this.tupleSource = this.attachNode(new JoinNode(this.id++, this.tupleSource, this.objectSource, binder));
        }
    }

    public BaseNode[] getTerminalNodes(Rule rule) {
        return (BaseNode[])this.rules.remove(rule);
    }

    private void attachQuery(String queryName) {
        ClassObjectType queryObjectType = new ClassObjectType(class$org$drools$base$DroolsQuery == null ? (class$org$drools$base$DroolsQuery = ReteooBuilder.class$("org.drools.base.DroolsQuery")) : class$org$drools$base$DroolsQuery);
        ObjectTypeNode queryObjectTypeNode = new ObjectTypeNode(this.id++, queryObjectType, this.rete);
        queryObjectTypeNode.attach();
        ClassFieldExtractor extractor = new ClassFieldExtractor(class$org$drools$base$DroolsQuery == null ? (class$org$drools$base$DroolsQuery = ReteooBuilder.class$("org.drools.base.DroolsQuery")) : class$org$drools$base$DroolsQuery, "name");
        FieldValue field = FieldFactory.getFieldValue(queryName, 180);
        Evaluator evaluator = EvaluatorFactory.getEvaluator(180, 1);
        LiteralConstraint constraint = new LiteralConstraint(field, extractor, evaluator);
        AlphaNode alphaNode = new AlphaNode(this.id++, constraint, queryObjectTypeNode);
        alphaNode.attach();
        LeftInputAdapterNode liaNode = new LeftInputAdapterNode(this.id++, alphaNode);
        liaNode.attach();
        this.tupleSource = liaNode;
    }

    private BetaNodeBinder attachColumn(Column column, GroupElement parent, boolean removeIdentities) throws InvalidPatternException {
        List predicates;
        column.adjustOffset(this.currentOffsetAdjustment);
        if (column.getDeclaration() != null) {
            Declaration declaration = column.getDeclaration();
            this.declarations.put(declaration.getIdentifier(), declaration);
        }
        BetaNodeBinder binder = !(predicates = this.attachAlphaNodes(column, removeIdentities)).isEmpty() ? new BetaNodeBinder(predicates.toArray(new FieldConstraint[predicates.size()])) : new BetaNodeBinder();
        return binder;
    }

    public List attachAlphaNodes(Column column, boolean removeIdentities) throws InvalidPatternException {
        Iterator<Object> it;
        List constraints = column.getConstraints();
        Class thisClass = ((ClassObjectType)column.getObjectType()).getClassType();
        this.objectSource = this.attachNode(new ObjectTypeNode(this.id++, column.getObjectType(), this.rete));
        ArrayList<FieldConstraint> predicateConstraints = new ArrayList<FieldConstraint>();
        if (removeIdentities) {
            it = this.objectType.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                Class previousClass = ((ClassObjectType)entry.getKey()).getClassType();
                if (!thisClass.isAssignableFrom(previousClass)) continue;
                predicateConstraints.add(new InstanceEqualsConstraint((Integer)entry.getValue()));
            }
            this.objectType.put(column.getObjectType(), new Integer(column.getFactIndex()));
        }
        it = constraints.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof Declaration) {
                Declaration declaration = (Declaration)object;
                this.declarations.put(declaration.getIdentifier(), declaration);
                continue;
            }
            FieldConstraint fieldConstraint = (FieldConstraint)object;
            if (fieldConstraint instanceof LiteralConstraint) {
                this.objectSource = this.attachNode(new AlphaNode(this.id++, fieldConstraint, this.objectSource));
                continue;
            }
            this.checkUnboundDeclarations(fieldConstraint.getRequiredDeclarations());
            predicateConstraints.add(fieldConstraint);
        }
        return predicateConstraints;
    }

    private void attachNot(TupleSource tupleSource, Not not, ObjectSource ObjectSource2, BetaNodeBinder binder, Column column) {
        NotNode notNode = (NotNode)this.attachNode(new NotNode(this.id++, tupleSource, ObjectSource2, binder));
        if (not.getChild() instanceof Not) {
            RightInputAdapterNode adapter = (RightInputAdapterNode)this.attachNode(new RightInputAdapterNode(this.id++, column.getFactIndex(), notNode));
            this.attachNot(tupleSource, (Not)not.getChild(), adapter, new BetaNodeBinder(), column);
        } else if (not.getChild() instanceof Exists) {
            RightInputAdapterNode adapter = (RightInputAdapterNode)this.attachNode(new RightInputAdapterNode(this.id++, column.getFactIndex(), notNode));
            this.attachExists(tupleSource, (Exists)not.getChild(), adapter, new BetaNodeBinder(), column);
        } else {
            this.tupleSource = notNode;
        }
    }

    private void attachExists(TupleSource tupleSource, Exists exists, ObjectSource ObjectSource2, BetaNodeBinder binder, Column column) {
        NotNode notNode = (NotNode)this.attachNode(new NotNode(this.id++, tupleSource, ObjectSource2, binder));
        RightInputAdapterNode adapter = (RightInputAdapterNode)this.attachNode(new RightInputAdapterNode(this.id++, column.getFactIndex(), notNode));
        notNode = (NotNode)this.attachNode(new NotNode(this.id++, tupleSource, adapter, new BetaNodeBinder()));
        if (exists.getChild() instanceof Not) {
            adapter = (RightInputAdapterNode)this.attachNode(new RightInputAdapterNode(this.id++, column.getFactIndex(), notNode));
            this.attachNot(tupleSource, (Not)exists.getChild(), adapter, new BetaNodeBinder(), column);
        } else if (exists.getChild() instanceof Exists) {
            adapter = (RightInputAdapterNode)this.attachNode(new RightInputAdapterNode(this.id++, column.getFactIndex(), notNode));
            this.attachExists(tupleSource, (Exists)exists.getChild(), adapter, new BetaNodeBinder(), column);
        } else {
            this.tupleSource = notNode;
        }
    }

    private TupleSource attachNode(TupleSource candidate) {
        TupleSource node = (TupleSource)this.attachedNodes.get(candidate);
        if (node == null) {
            if (this.workingMemories.length == 0) {
                candidate.attach();
            } else {
                candidate.attach(this.workingMemories);
            }
            this.attachedNodes.put(candidate, candidate);
            node = candidate;
        } else {
            node.addShare();
            --this.id;
        }
        return node;
    }

    private ObjectSource attachNode(ObjectSource candidate) {
        ObjectSource node = (ObjectSource)this.attachedNodes.get(candidate);
        if (node == null) {
            if (this.workingMemories.length == 0) {
                candidate.attach();
            } else {
                candidate.attach(this.workingMemories);
            }
            this.attachedNodes.put(candidate, candidate);
            node = candidate;
        } else {
            --this.id;
        }
        return node;
    }

    public void removeRule(Rule rule) {
        this.workingMemories = this.ruleBase.getWorkingMemories().toArray(new WorkingMemoryImpl[this.ruleBase.getWorkingMemories().size()]);
        Object object = this.rules.get(rule);
        BaseNode[] nodes = (BaseNode[])object;
        int length = nodes.length;
        for (int i = 0; i < length; ++i) {
            BaseNode node = nodes[i];
            node.remove(null, this.workingMemories);
        }
    }

    private void checkUnboundDeclarations(Declaration[] declarations) throws InvalidPatternException {
        ArrayList<String> list = new ArrayList<String>();
        int length = declarations.length;
        for (int i = 0; i < length; ++i) {
            if (this.declarations.get(declarations[i].getIdentifier()) != null) continue;
            list.add(declarations[i].getIdentifier());
        }
        if (list.size() != 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(list.get(0));
            int size = list.size();
            for (int i = 1; i < size; ++i) {
                buffer.append(", " + list.get(i));
            }
            throw new InvalidPatternException("Required Declarations not bound: '" + buffer);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

