/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import org.drools.FactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.reteoo.FactHandleImpl;
import org.drools.reteoo.FactHandleList;

class TupleKey
implements Serializable {
    public static final TupleKey EMPTY_KEY = new TupleKey();
    private final FactHandleList handles;
    private long recency = 0L;

    private TupleKey() {
        this.handles = FactHandleList.EMPTY_LIST;
    }

    public TupleKey(TupleKey key) {
        this.handles = key.handles;
        this.recency = key.recency;
    }

    public TupleKey(FactHandleImpl handle) {
        this.handles = new FactHandleList(handle);
        this.recency = handle.getRecency();
    }

    public TupleKey(TupleKey left, FactHandleImpl handle) {
        this.handles = new FactHandleList(left.handles, handle);
        this.recency = left.recency + handle.getRecency();
    }

    public String toString() {
        return "[TupleKey: recency=" + this.recency + " handles=" + this.handles + "]";
    }

    public InternalFactHandle get(int index) {
        return this.handles.get(index);
    }

    public boolean containsFactHandle(FactHandle handle) {
        return this.handles.contains(handle);
    }

    public boolean containsAll(TupleKey that) {
        return this.handles.containsAll(that.handles);
    }

    InternalFactHandle[] getFactHandles() {
        return this.handles.getHandles();
    }

    public int size() {
        return this.handles.size();
    }

    public long getRecency() {
        return this.recency;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.handles.equals(((TupleKey)object).handles);
    }

    public int hashCode() {
        return this.handles.hashCode();
    }
}

