/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.NoSuchFactHandleException;
import org.drools.NoSuchFactObjectException;
import org.drools.QueryResults;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.base.DroolsQuery;
import org.drools.common.Agenda;
import org.drools.common.EventSupport;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemoryActions;
import org.drools.common.LogicalDependency;
import org.drools.common.PropagationContextImpl;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaEventSupport;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.event.WorkingMemoryEventSupport;
import org.drools.reteoo.FactHandleImpl;
import org.drools.reteoo.NodeMemory;
import org.drools.reteoo.QueryTerminalNode;
import org.drools.reteoo.RuleBaseImpl;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.AgendaFilter;
import org.drools.spi.AgendaGroup;
import org.drools.spi.AsyncExceptionHandler;
import org.drools.spi.FactHandleFactory;
import org.drools.spi.PropagationContext;
import org.drools.util.IdentityMap;
import org.drools.util.LinkedList;
import org.drools.util.PrimitiveLongMap;
import org.drools.util.PrimitiveLongStack;
import org.drools.util.concurrent.locks.Lock;
import org.drools.util.concurrent.locks.ReentrantLock;

public class WorkingMemoryImpl
implements WorkingMemory,
InternalWorkingMemoryActions,
EventSupport,
PropertyChangeListener {
    private static final Class[] ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES = new Class[]{class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = WorkingMemoryImpl.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener};
    private final Object[] addRemovePropertyChangeListenerArgs = new Object[]{this};
    private final PrimitiveLongMap nodeMemories = new PrimitiveLongMap(32, 8);
    private final Map globals = new HashMap();
    private final Map identityMap = new IdentityMap();
    private final Map equalsMap = new HashMap();
    private final PrimitiveLongMap justified = new PrimitiveLongMap(8, 32);
    private final PrimitiveLongStack factHandlePool = new PrimitiveLongStack();
    private Map queryResults = Collections.EMPTY_MAP;
    private static final String STATED = "STATED";
    private static final String JUSTIFIED = "JUSTIFIED";
    private static final String NEW = "NEW";
    private static final FactStatus STATUS_NEW = new FactStatus("NEW", 0);
    private final WorkingMemoryEventSupport workingMemoryEventSupport = new WorkingMemoryEventSupport(this);
    private final AgendaEventSupport agendaEventSupport = new AgendaEventSupport(this);
    private ReentrantLock lock = new ReentrantLock();
    private final RuleBaseImpl ruleBase;
    private final FactHandleFactory handleFactory;
    private final Agenda agenda;
    private boolean firing;
    private long propagationIdCounter;
    private List factQueue = new ArrayList();
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public WorkingMemoryImpl(RuleBaseImpl ruleBase) {
        this.ruleBase = ruleBase;
        this.agenda = new Agenda(this);
        this.handleFactory = this.ruleBase.newFactHandleFactory();
    }

    public void addEventListener(WorkingMemoryEventListener listener) {
        this.workingMemoryEventSupport.addEventListener(listener);
    }

    public void removeEventListener(WorkingMemoryEventListener listener) {
        this.workingMemoryEventSupport.removeEventListener(listener);
    }

    public List getWorkingMemoryEventListeners() {
        return this.workingMemoryEventSupport.getEventListeners();
    }

    public void addEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.addEventListener(listener);
    }

    public void removeEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.removeEventListener(listener);
    }

    public List getAgendaEventListeners() {
        return this.agendaEventSupport.getEventListeners();
    }

    FactHandle newFactHandle() {
        if (!this.factHandlePool.isEmpty()) {
            return this.handleFactory.newFactHandle(this.factHandlePool.pop());
        }
        return this.handleFactory.newFactHandle();
    }

    public Map getGlobals() {
        return this.globals;
    }

    public void setGlobal(String name, Object value) {
        Map globalDefintions = this.ruleBase.getGlobals();
        Class type = (Class)globalDefintions.get(name);
        if (type == null) {
            throw new RuntimeException("Unexpected global [" + name + "]");
        }
        if (!type.isInstance(value)) {
            throw new RuntimeException("Illegal class for global. Expected [" + type.getName() + "], " + "found [" + value.getClass().getName() + "].");
        }
        this.globals.put(name, value);
    }

    public Object getGlobal(String name) {
        Object object = this.globals.get(name);
        return object;
    }

    public Agenda getAgenda() {
        return this.agenda;
    }

    public void clearAgenda() {
        this.agenda.clearAgenda();
    }

    public void clearAgendaGroup(String group) {
        this.agenda.clearAgendaGroup(group);
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void fireAllRules() throws FactException {
        this.fireAllRules(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fireAllRules(AgendaFilter agendaFilter) throws FactException {
        if (!this.firing) {
            try {
                this.firing = true;
                while (this.agenda.fireNextItem(agendaFilter)) {
                }
            }
            finally {
                this.firing = false;
            }
        }
    }

    public Object getObject(FactHandle handle) {
        InternalFactHandle handleImpl = (InternalFactHandle)handle;
        return handleImpl.getObject();
    }

    public FactHandle getFactHandle(Object object) {
        FactHandle factHandle = (FactHandle)this.identityMap.get(object);
        if (factHandle == null) {
            throw new NoSuchFactHandleException(object);
        }
        return factHandle;
    }

    public List getFactHandles() {
        return new ArrayList(this.identityMap.values());
    }

    Map getFactHandleMap() {
        return Collections.unmodifiableMap(this.identityMap);
    }

    public List getObjects() {
        return new ArrayList(this.identityMap.keySet());
    }

    public List getObjects(Class objectClass) {
        java.util.LinkedList matching = new java.util.LinkedList();
        Iterator objIter = this.identityMap.keySet().iterator();
        while (objIter.hasNext()) {
            Object obj = objIter.next();
            if (!objectClass.isInstance(obj)) continue;
            matching.add(obj);
        }
        return matching;
    }

    public QueryResults getQueryResults(String query) {
        FactHandle handle = this.assertObject(new DroolsQuery(query));
        QueryTerminalNode node = (QueryTerminalNode)this.queryResults.remove(query);
        if (node == null) {
            this.retractObject(handle);
            return null;
        }
        List list = (List)this.nodeMemories.remove(node.getId());
        this.retractObject(handle);
        if (list == null) {
            return null;
        }
        return new QueryResults(list, (Query)node.getRule(), this);
    }

    void setQueryResults(String query, QueryTerminalNode node) {
        if (this.queryResults == Collections.EMPTY_MAP) {
            this.queryResults = new HashMap();
        }
        this.queryResults.put(query, node);
    }

    public AgendaGroup getFocus() {
        return this.agenda.getFocus();
    }

    public void setFocus(String focus) {
        this.agenda.setFocus(focus);
    }

    public void setFocus(AgendaGroup focus) {
        this.agenda.setFocus(focus);
    }

    public boolean containsObject(FactHandle handle) {
        return this.identityMap.containsKey(this.getObject(handle));
    }

    public FactHandle assertObject(Object object) throws FactException {
        return this.assertObject(object, false, false, null, null);
    }

    public FactHandle assertLogicalObject(Object object) throws FactException {
        return this.assertObject(object, false, true, null, null);
    }

    public FactHandle assertObject(Object object, boolean dynamic) throws FactException {
        return this.assertObject(object, dynamic, false, null, null);
    }

    public FactHandle assertLogicalObject(Object object, boolean dynamic) throws FactException {
        return this.assertObject(object, dynamic, true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FactHandle assertObject(Object object, boolean dynamic, boolean logical, Rule rule, Activation activation) throws FactException {
        FactHandleImpl handle = null;
        this.lock.lock();
        try {
            handle = (FactHandleImpl)this.identityMap.get(object);
            FactStatus logicalState = (FactStatus)this.equalsMap.get(object);
            if (logicalState == null) {
                logicalState = STATUS_NEW;
            }
            if (logical && logicalState.getStatus() == STATED) {
                FactHandle factHandle = null;
                return factHandle;
            }
            if (logical && logicalState.getStatus() == JUSTIFIED) {
                this.addLogicalDependency(logicalState.getHandle(), activation, activation.getPropagationContext(), rule);
                FactHandleImpl factHandleImpl = logicalState.getHandle();
                return factHandleImpl;
            }
            if (handle != null && !logical && logicalState.getStatus() == STATED) {
                FactHandleImpl factHandleImpl = handle;
                return factHandleImpl;
            }
            if (!logical) {
                if (logicalState.getStatus() == JUSTIFIED) {
                    handle = logicalState.getHandle();
                    this.removeLogicalDependencies(handle);
                } else {
                    handle = (FactHandleImpl)this.newFactHandle();
                }
                this.putObject(handle, object);
                if (logicalState != STATUS_NEW) {
                    logicalState.setStatus(STATED);
                    logicalState.incCounter();
                } else {
                    this.equalsMap.put(object, new FactStatus(STATED, 1));
                }
                if (dynamic) {
                    this.addPropertyChangeListener(object);
                }
            } else {
                handle = logicalState.getHandle();
                if (handle == null) {
                    handle = (FactHandleImpl)this.newFactHandle();
                    this.putObject(handle, object);
                    this.equalsMap.put(object, new FactStatus(JUSTIFIED, handle));
                }
                this.addLogicalDependency(handle, activation, activation.getPropagationContext(), rule);
            }
            handle.setObject(object);
            PropagationContextImpl propagationContext = new PropagationContextImpl(this.propagationIdCounter++, 0, rule, activation);
            this.ruleBase.assertObject(handle, object, propagationContext, this);
            this.workingMemoryEventSupport.fireObjectAsserted(propagationContext, handle, object);
            if (!this.factQueue.isEmpty()) {
                this.propagateQueuedActions();
            }
        }
        finally {
            this.lock.unlock();
        }
        return handle;
    }

    private void addPropertyChangeListener(Object object) {
        try {
            Method method = object.getClass().getMethod("addPropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
            method.invoke(object, this.addRemovePropertyChangeListenerArgs);
        }
        catch (NoSuchMethodException e) {
            System.err.println("Warning: Method addPropertyChangeListener not found on the class " + object.getClass() + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalArgumentException e) {
            System.err.println("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " does not take" + " a simple PropertyChangeListener argument" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalAccessException e) {
            System.err.println("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " is not public" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (InvocationTargetException e) {
            System.err.println("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " threw an InvocationTargetException" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            System.err.println("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a" + " addPropertyChangeListener method" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
    }

    private void removePropertyChangeListener(FactHandle handle) throws NoSuchFactObjectException {
        Object object = null;
        try {
            object = this.getObject(handle);
            Method mehod = handle.getClass().getMethod("removePropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
            mehod.invoke((Object)handle, this.addRemovePropertyChangeListenerArgs);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            System.err.println("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " does not take" + " a simple PropertyChangeListener argument" + " so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object");
        }
        catch (IllegalAccessException e) {
            System.err.println("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " is not public" + " so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object");
        }
        catch (InvocationTargetException e) {
            System.err.println("Warning: The removePropertyChangeL istener method on the class " + object.getClass() + " threw an InvocationTargetException" + " so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            System.err.println("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a" + " removePropertyChangeListener method" + " so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
    }

    void putObject(FactHandle handle, Object object) {
        this.identityMap.put(object, handle);
        ((FactHandleImpl)handle).setObject(object);
    }

    Object removeObject(FactHandle handle) {
        Object object = this.getObject(handle);
        this.identityMap.remove(object);
        return object;
    }

    public void retractObject(FactHandle handle) throws FactException {
        this.retractObject(handle, true, true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retractObject(FactHandle handle, boolean removeLogical, boolean updateEqualsMap, Rule rule, Activation activation) throws FactException {
        this.lock.lock();
        try {
            FactStatus status;
            this.removePropertyChangeListener(handle);
            PropagationContextImpl propagationContext = new PropagationContextImpl(this.propagationIdCounter++, 1, rule, activation);
            this.ruleBase.retractObject(handle, propagationContext, this);
            Object oldObject = this.removeObject(handle);
            if (removeLogical) {
                this.removeLogicalDependencies(handle);
            }
            if ((removeLogical || updateEqualsMap) && (status = (FactStatus)this.equalsMap.get(oldObject)) != null) {
                status.decCounter();
                if (status.getCounter() <= 0) {
                    this.equalsMap.remove(oldObject);
                }
            }
            this.factHandlePool.push(((FactHandleImpl)handle).getId());
            this.workingMemoryEventSupport.fireObjectRetracted(propagationContext, handle, oldObject);
            ((FactHandleImpl)handle).invalidate();
            if (!this.factQueue.isEmpty()) {
                this.propagateQueuedActions();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void modifyObject(FactHandle handle, Object object) throws FactException {
        this.modifyObject(handle, object, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyObject(FactHandle handle, Object object, Rule rule, Activation activation) throws FactException {
        this.lock.lock();
        try {
            Object originalObject = this.removeObject(handle);
            if (originalObject == null) {
                throw new NoSuchFactObjectException(handle);
            }
            this.handleFactory.increaseFactHandleRecency(handle);
            this.putObject(handle, object);
            FactHandleImpl handleImpl = (FactHandleImpl)handle;
            if (this.justified.get(handleImpl.getId()) != null) {
                this.equalsMap.remove(originalObject);
                this.equalsMap.put(object, new FactStatus(JUSTIFIED, handleImpl));
            }
            PropagationContextImpl propagationContext = new PropagationContextImpl(this.propagationIdCounter++, 2, rule, activation);
            this.ruleBase.modifyObject(handle, propagationContext, this);
            this.workingMemoryEventSupport.fireObjectModified(propagationContext, handle, originalObject, object);
            if (!this.factQueue.isEmpty()) {
                this.propagateQueuedActions();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void propagateQueuedActions() {
        Iterator it = this.factQueue.iterator();
        while (it.hasNext()) {
            WorkingMemoryAction action = (WorkingMemoryAction)it.next();
            it.remove();
            action.propagate();
        }
    }

    public Object getNodeMemory(NodeMemory node) {
        Object memory = this.nodeMemories.get(node.getId());
        if (memory == null) {
            memory = node.createMemory();
            this.nodeMemories.put(node.getId(), memory);
        }
        return memory;
    }

    public void clearNodeMemory(NodeMemory node) {
        this.nodeMemories.remove(node.getId());
    }

    public WorkingMemoryEventSupport getWorkingMemoryEventSupport() {
        return this.workingMemoryEventSupport;
    }

    public AgendaEventSupport getAgendaEventSupport() {
        return this.agendaEventSupport;
    }

    public void setAsyncExceptionHandler(AsyncExceptionHandler handler) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object object = event.getSource();
        try {
            this.modifyObject(this.getFactHandle(object), object);
        }
        catch (NoSuchFactHandleException e) {
        }
        catch (FactException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void removeLogicalDependencies(Activation activation, PropagationContext context, Rule rule) throws FactException {
        LinkedList list = activation.getLogicalDependencies();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (LogicalDependency node = (LogicalDependency)list.getFirst(); node != null; node = (LogicalDependency)node.getNext()) {
            FactHandleImpl handle = (FactHandleImpl)node.getFactHandle();
            Set set = (Set)this.justified.get(handle.getId());
            set.remove(node);
            if (!set.isEmpty()) continue;
            this.justified.remove(handle.getId());
            this.factQueue.add(new WorkingMemoryRetractAction(handle, false, true, context.getRuleOrigin(), context.getActivationOrigin()));
        }
    }

    public void removeLogicalDependencies(FactHandle handle) throws FactException {
        Set set = (Set)this.justified.remove(((FactHandleImpl)handle).getId());
        if (set != null && !set.isEmpty()) {
            Iterator it = set.iterator();
            while (it.hasNext()) {
                LogicalDependency node = (LogicalDependency)it.next();
                node.getJustifier().getLogicalDependencies().remove(node);
            }
        }
    }

    public void addLogicalDependency(FactHandle handle, Activation activation, PropagationContext context, Rule rule) throws FactException {
        LogicalDependency node = new LogicalDependency(activation, handle);
        activation.addLogicalDependency(node);
        HashSet<LogicalDependency> set = (HashSet<LogicalDependency>)this.justified.get(((FactHandleImpl)handle).getId());
        if (set == null) {
            set = new HashSet<LogicalDependency>();
            this.justified.put(((FactHandleImpl)handle).getId(), set);
        }
        set.add(node);
    }

    public PrimitiveLongMap getJustified() {
        return this.justified;
    }

    public long getNextPropagationIdCounter() {
        return this.propagationIdCounter++;
    }

    public void dispose() {
        this.ruleBase.disposeWorkingMemory(this);
    }

    public Lock getLock() {
        return this.lock;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FactStatus {
        private int counter;
        private String status;
        private FactHandleImpl handle;

        public FactStatus() {
            this(WorkingMemoryImpl.STATED, 1);
        }

        public FactStatus(String status) {
            this(status, 1);
        }

        public FactStatus(String status, FactHandleImpl handle) {
            this.status = status;
            this.handle = handle;
        }

        public FactStatus(String status, int counter) {
            this.status = status;
            this.counter = counter;
        }

        public int getCounter() {
            return this.counter;
        }

        public void setCounter(int counter) {
            this.counter = counter;
        }

        public int incCounter() {
            return ++this.counter;
        }

        public int decCounter() {
            return --this.counter;
        }

        public FactHandleImpl getHandle() {
            return this.handle;
        }

        public void setHandle(FactHandleImpl handle) {
            this.handle = handle;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String toString() {
            return "FactStatus( " + this.status + ", handle=" + this.handle + ", counter=" + this.counter + ")";
        }
    }

    private class WorkingMemoryRetractAction
    implements WorkingMemoryAction {
        private InternalFactHandle factHandle;
        private boolean removeLogical;
        private boolean updateEqualsMap;
        private Rule ruleOrigin;
        private Activation activationOrigin;

        public WorkingMemoryRetractAction(InternalFactHandle factHandle, boolean removeLogical, boolean updateEqualsMap, Rule ruleOrigin, Activation activationOrigin) {
            this.factHandle = factHandle;
            this.removeLogical = removeLogical;
            this.updateEqualsMap = updateEqualsMap;
            this.ruleOrigin = ruleOrigin;
            this.activationOrigin = activationOrigin;
        }

        public void propagate() {
            WorkingMemoryImpl.this.retractObject(this.factHandle, this.removeLogical, this.updateEqualsMap, this.ruleOrigin, this.activationOrigin);
        }
    }

    private static interface WorkingMemoryAction {
        public void propagate();
    }
}

