/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.drools.rule.And;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Or;

class LogicTransformer {
    private final Map duplicateTransformations = new HashMap();
    private final Map orTransformations = new HashMap();
    private static LogicTransformer INSTANCE = null;
    static /* synthetic */ Class class$org$drools$rule$And;
    static /* synthetic */ Class class$org$drools$rule$Or;
    static /* synthetic */ Class class$org$drools$rule$Exists;
    static /* synthetic */ Class class$org$drools$rule$Not;

    static LogicTransformer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LogicTransformer();
        }
        return INSTANCE;
    }

    LogicTransformer() {
        this.initialize();
    }

    private void initialize() {
        this.addTransformationPair(class$org$drools$rule$And == null ? (class$org$drools$rule$And = LogicTransformer.class$("org.drools.rule.And")) : class$org$drools$rule$And, class$org$drools$rule$And == null ? (class$org$drools$rule$And = LogicTransformer.class$("org.drools.rule.And")) : class$org$drools$rule$And);
        this.addTransformationPair(class$org$drools$rule$Or == null ? (class$org$drools$rule$Or = LogicTransformer.class$("org.drools.rule.Or")) : class$org$drools$rule$Or, class$org$drools$rule$Or == null ? (class$org$drools$rule$Or = LogicTransformer.class$("org.drools.rule.Or")) : class$org$drools$rule$Or);
        this.addTransformationPair(class$org$drools$rule$Exists == null ? (class$org$drools$rule$Exists = LogicTransformer.class$("org.drools.rule.Exists")) : class$org$drools$rule$Exists, class$org$drools$rule$Exists == null ? (class$org$drools$rule$Exists = LogicTransformer.class$("org.drools.rule.Exists")) : class$org$drools$rule$Exists);
        this.addTransformationPair(class$org$drools$rule$Not == null ? (class$org$drools$rule$Not = LogicTransformer.class$("org.drools.rule.Not")) : class$org$drools$rule$Not, class$org$drools$rule$Or == null ? (class$org$drools$rule$Or = LogicTransformer.class$("org.drools.rule.Or")) : class$org$drools$rule$Or, new NotOrTransformation());
        this.addTransformationPair(class$org$drools$rule$Exists == null ? (class$org$drools$rule$Exists = LogicTransformer.class$("org.drools.rule.Exists")) : class$org$drools$rule$Exists, class$org$drools$rule$Or == null ? (class$org$drools$rule$Or = LogicTransformer.class$("org.drools.rule.Or")) : class$org$drools$rule$Or, new ExistOrTransformation());
        this.addTransformationPair(class$org$drools$rule$And == null ? (class$org$drools$rule$And = LogicTransformer.class$("org.drools.rule.And")) : class$org$drools$rule$And, class$org$drools$rule$Or == null ? (class$org$drools$rule$Or = LogicTransformer.class$("org.drools.rule.Or")) : class$org$drools$rule$Or, new AndOrTransformation());
    }

    private void addTransformationPair(Class parent, Class child) {
        Map map = this.duplicateTransformations;
        HashSet<Class> childSet = (HashSet<Class>)map.get(child);
        if (childSet == null) {
            childSet = new HashSet<Class>();
            map.put(parent, childSet);
        }
        childSet.add(child);
    }

    private void addTransformationPair(Class parent, Class child, Object method) {
        Map map = this.orTransformations;
        HashMap<Class, Object> childMap = (HashMap<Class, Object>)map.get(parent);
        if (childMap == null) {
            childMap = new HashMap<Class, Object>();
            map.put(parent, childMap);
        }
        childMap.put(child, method);
    }

    And[] transform(And and) throws InvalidPatternException {
        And cloned = (And)and.clone();
        this.processTree(cloned);
        GroupElement or = null;
        Iterator it = cloned.getChildren().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (!(object instanceof Or)) continue;
            or = (Or)this.applyOrTransformation(cloned, (GroupElement)object);
            break;
        }
        And[] ands = null;
        if (or == null) {
            ands = new And[]{cloned};
        } else {
            ands = new And[or.getChildren().size()];
            int i = 0;
            Iterator it2 = or.getChildren().iterator();
            while (it2.hasNext()) {
                Object object = it2.next();
                if (object.getClass() == (class$org$drools$rule$And == null ? LogicTransformer.class$("org.drools.rule.And") : class$org$drools$rule$And)) {
                    ands[i] = (And)object;
                } else {
                    And newAnd = new And();
                    newAnd.addChild(and);
                    ands[i] = newAnd;
                }
                ++i;
            }
        }
        return ands;
    }

    void processTree(GroupElement ce) throws InvalidPatternException {
        ArrayList<GroupElement> newChildren = new ArrayList<GroupElement>();
        Iterator it = ce.getChildren().iterator();
        block0: while (it.hasNext()) {
            Object object = it.next();
            if (!(object instanceof GroupElement)) continue;
            GroupElement parent = (GroupElement)object;
            this.processTree(parent);
            this.checkForAndRemoveDuplicates(parent);
            Iterator orIter = parent.getChildren().iterator();
            while (orIter.hasNext()) {
                Object object2 = orIter.next();
                if (!(object2 instanceof Or)) continue;
                newChildren.add(this.applyOrTransformation(parent, (GroupElement)object2));
                it.remove();
                continue block0;
            }
        }
        ce.getChildren().addAll(newChildren);
    }

    boolean removeDuplicate(GroupElement parent, GroupElement child) {
        if (this.duplicateTransformations.get(parent.getClass()) != null) {
            return ((HashSet)this.duplicateTransformations.get(parent.getClass())).contains(child.getClass());
        }
        return false;
    }

    void checkForAndRemoveDuplicates(GroupElement parent) {
        ArrayList newChildren = new ArrayList();
        Iterator it = parent.getChildren().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (!parent.getClass().isInstance(object) || !this.removeDuplicate(parent, (GroupElement)object)) continue;
            GroupElement child = (GroupElement)object;
            Iterator childIter = child.getChildren().iterator();
            while (childIter.hasNext()) {
                newChildren.add(childIter.next());
            }
            it.remove();
        }
        parent.getChildren().addAll(newChildren);
    }

    GroupElement applyOrTransformation(GroupElement parent, GroupElement child) throws InvalidPatternException {
        Transformation transformation = null;
        HashMap map = (HashMap)this.orTransformations.get(parent.getClass());
        if (map != null) {
            transformation = (Transformation)map.get(child.getClass());
        }
        if (transformation == null) {
            throw new RuntimeException("applyOrTransformation could not find transformation for parent '" + parent.getClass().getName() + "' and child '" + child.getClass().getName() + "'");
        }
        return transformation.transform(parent);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class NotOrTransformation
    implements Transformation {
        public GroupElement transform(GroupElement not) throws InvalidPatternException {
            throw new InvalidPatternException("You cannot nest an OR within an Not");
        }
    }

    class ExistOrTransformation
    implements Transformation {
        ExistOrTransformation() {
        }

        public GroupElement transform(GroupElement exist) throws InvalidPatternException {
            throw new InvalidPatternException("You cannot nest an OR within an Exists");
        }
    }

    class AndOrTransformation
    implements Transformation {
        AndOrTransformation() {
        }

        public GroupElement transform(GroupElement and) throws InvalidPatternException {
            Or or = new Or();
            this.determinePermutations(0, (And)and, null, or);
            return or;
        }

        private void determinePermutations(int currentLevel, And and, And combination, Or or) {
            Object entry = and.getChildren().get(currentLevel);
            if (entry instanceof Or) {
                Or childOr = (Or)entry;
                Iterator it = childOr.getChildren().iterator();
                while (it.hasNext()) {
                    And temp = new And();
                    if (currentLevel == 0) {
                        combination = new And();
                    } else {
                        temp.getChildren().addAll(combination.getChildren());
                    }
                    Object object = it.next();
                    if (object instanceof And) {
                        And childAnd = (And)object;
                        Iterator childIter = childAnd.getChildren().iterator();
                        while (childIter.hasNext()) {
                            temp.addChild(childIter.next());
                        }
                    } else {
                        temp.addChild(object);
                    }
                    if (currentLevel < and.getChildren().size() - 1) {
                        this.determinePermutations(currentLevel + 1, and, temp, or);
                        continue;
                    }
                    or.addChild(temp);
                }
            } else {
                And temp = new And();
                if (currentLevel == 0) {
                    combination = new And();
                } else {
                    temp.getChildren().addAll(combination.getChildren());
                }
                temp.addChild(entry);
                if (currentLevel < and.getChildren().size() - 1) {
                    this.determinePermutations(currentLevel + 1, and, temp, or);
                } else {
                    or.addChild(temp);
                }
            }
        }
    }

    static interface Transformation {
        public GroupElement transform(GroupElement var1) throws InvalidPatternException;
    }
}

