/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import org.drools.RuntimeDroolsException;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.rule.Declaration;
import org.drools.spi.FieldConstraint;
import org.drools.spi.PredicateExpression;
import org.drools.spi.Tuple;

public class PredicateConstraint
implements FieldConstraint {
    private PredicateExpression expression;
    private final Declaration declaration;
    private final Declaration[] requiredDeclarations;
    private static final Declaration[] EMPTY_DECLARATIONS = new Declaration[0];

    public PredicateConstraint(PredicateExpression evaluator, Declaration declaration) {
        this(evaluator, declaration, null);
    }

    public PredicateConstraint(Declaration declaration, Declaration[] requiredDeclarations) {
        this(null, declaration, requiredDeclarations);
    }

    public PredicateConstraint(PredicateExpression expression, Declaration declaration, Declaration[] requiredDeclarations) {
        this.expression = expression;
        this.declaration = declaration;
        this.requiredDeclarations = requiredDeclarations == null ? EMPTY_DECLARATIONS : requiredDeclarations;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public void setPredicateExpression(PredicateExpression expression) {
        this.expression = expression;
    }

    public PredicateExpression getPredicateExpression() {
        return this.expression;
    }

    public boolean isAllowed(InternalFactHandle handle, Tuple tuple, WorkingMemory workingMemory) {
        try {
            return this.expression.evaluate(tuple, handle, this.declaration, this.requiredDeclarations, workingMemory);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof PredicateConstraint)) {
            return false;
        }
        PredicateConstraint other = (PredicateConstraint)object;
        return this.expression.equals(other.expression);
    }
}

