/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import org.drools.RuntimeDroolsException;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.rule.Declaration;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldConstraint;
import org.drools.spi.FieldExtractor;
import org.drools.spi.ReturnValueExpression;
import org.drools.spi.Tuple;

public class ReturnValueConstraint
implements FieldConstraint {
    private final FieldExtractor fieldExtractor;
    private ReturnValueExpression expression;
    private final Declaration[] requiredDeclarations;
    private final Evaluator evaluator;
    private static final Declaration[] noRequiredDeclarations = new Declaration[0];

    public ReturnValueConstraint(FieldExtractor fieldExtractor, Declaration[] declarations, Evaluator evaluator) {
        this(fieldExtractor, null, declarations, evaluator);
    }

    public ReturnValueConstraint(FieldExtractor fieldExtractor, ReturnValueExpression returnValueExpression, Declaration[] declarations, Evaluator evaluator) {
        this.fieldExtractor = fieldExtractor;
        this.expression = returnValueExpression;
        this.requiredDeclarations = declarations != null ? declarations : noRequiredDeclarations;
        this.evaluator = evaluator;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public void setReturnValueExpression(ReturnValueExpression expression) {
        this.expression = expression;
    }

    public ReturnValueExpression getExpression() {
        return this.expression;
    }

    public boolean isAllowed(InternalFactHandle handle, Tuple tuple, WorkingMemory workingMemory) {
        try {
            return this.evaluator.evaluate(this.fieldExtractor.getValue(handle.getObject()), this.expression.evaluate(tuple, this.requiredDeclarations, workingMemory));
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof ReturnValueConstraint)) {
            return false;
        }
        ReturnValueConstraint other = (ReturnValueConstraint)object;
        return this.expression.equals(other.expression);
    }
}

