/*
 * Decompiled with CFR 0.152.
 */
package org.drools.visualize;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.drools.visualize.RowList;

public class ReteooLayoutSolver {
    private Vertex root;
    private RowList rowList;

    public ReteooLayoutSolver(Vertex root) {
        this.root = root;
        this.solve();
    }

    protected void solve() {
        this.rowList = new RowList();
        this.rowList.add(0, this.root);
        HashSet<Vertex> seenVertices = new HashSet<Vertex>();
        seenVertices.add(this.root);
        for (int curRow = 0; curRow < this.rowList.getDepth(); ++curRow) {
            List rowVertices = this.rowList.get(curRow).getVertices();
            Iterator rowVertexIter = rowVertices.iterator();
            while (rowVertexIter.hasNext()) {
                Vertex rowVertex = (Vertex)rowVertexIter.next();
                Set edges = rowVertex.getOutEdges();
                Iterator edgeIter = edges.iterator();
                while (edgeIter.hasNext()) {
                    Edge edge = (Edge)edgeIter.next();
                    Vertex destVertex = edge.getOpposite(rowVertex);
                    if (seenVertices.contains(destVertex)) continue;
                    this.rowList.add(curRow + 1, destVertex);
                    seenVertices.add(destVertex);
                }
                seenVertices.add(rowVertex);
            }
        }
        this.rowList.optimize();
        this.rowList.dump();
    }

    public RowList getRowList() {
        return this.rowList;
    }
}

