/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.extractors;

import java.lang.reflect.Method;
import org.drools.base.ValueType;
import org.drools.common.InternalWorkingMemory;
import org.drools.spi.Extractor;
import org.drools.util.ClassUtils;

public class ArrayExtractor
implements Extractor {
    private final Extractor arrayExtractor;
    private final int index;
    private final Class type;

    public ArrayExtractor(Extractor arrayExtractor, int index, Class type) {
        this.arrayExtractor = arrayExtractor;
        this.index = index;
        this.type = type;
    }

    public Class getExtractToClass() {
        return this.type;
    }

    public String getExtractToClassName() {
        return ClassUtils.canonicalName(this.type);
    }

    public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
        Object[] array = (Object[])this.arrayExtractor.getValue(workingMemory, object);
        return (Boolean)array[this.index];
    }

    public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
        Object[] array = (Object[])this.arrayExtractor.getValue(workingMemory, object);
        return (Byte)array[this.index];
    }

    public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
        Object[] array = (Object[])this.arrayExtractor.getValue(workingMemory, object);
        return ((Character)array[this.index]).charValue();
    }

    public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
        Object[] array = (Object[])this.arrayExtractor.getValue(workingMemory, object);
        return (Double)array[this.index];
    }

    public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
        Object[] array = (Object[])this.arrayExtractor.getValue(workingMemory, object);
        return ((Float)array[this.index]).floatValue();
    }

    public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
        Object[] array = (Object[])this.arrayExtractor.getValue(workingMemory, object);
        return (Integer)array[this.index];
    }

    public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
        Object[] array = (Object[])this.arrayExtractor.getValue(workingMemory, object);
        return (Long)array[this.index];
    }

    public Method getNativeReadMethod() {
        throw new UnsupportedOperationException("cannot call a method on an array extractor");
    }

    public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
        Object[] array = (Object[])this.arrayExtractor.getValue(workingMemory, object);
        return (Short)array[this.index];
    }

    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        Object[] array = (Object[])this.arrayExtractor.getValue(workingMemory, object);
        return array[this.index];
    }

    public ValueType getValueType() {
        return ValueType.OBJECT_TYPE;
    }

    public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
        Object[] array = (Object[])this.arrayExtractor.getValue(workingMemory, object);
        return array[this.index] == null;
    }

    public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
        Object[] array = (Object[])this.arrayExtractor.getValue(workingMemory, object);
        return array[this.index].hashCode();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.arrayExtractor == null ? 0 : this.arrayExtractor.hashCode());
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayExtractor other = (ArrayExtractor)obj;
        if (this.arrayExtractor == null ? other.arrayExtractor != null : !this.arrayExtractor.equals(other.arrayExtractor)) {
            return false;
        }
        return this.index == other.index;
    }

    public boolean isGlobal() {
        return false;
    }
}

