/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.PackageIntegrationException;
import org.drools.RuleBaseConfiguration;
import org.drools.StatefulSession;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.CompositePackageClassLoader;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.MapBackedClassLoader;
import org.drools.rule.Package;
import org.drools.rule.PackageCompilationData;
import org.drools.rule.Rule;
import org.drools.ruleflow.common.core.Process;
import org.drools.spi.FactHandleFactory;
import org.drools.util.ObjectHashSet;

public abstract class AbstractRuleBase
implements InternalRuleBase,
Externalizable {
    protected String id;
    protected int workingMemoryCounter;
    protected RuleBaseConfiguration config;
    protected Map pkgs;
    protected Map processes;
    protected Map agendaGroupRuleTotals;
    protected transient CompositePackageClassLoader packageClassLoader;
    protected transient MapBackedClassLoader classLoader;
    protected FactHandleFactory factHandleFactory;
    protected Map globals;
    private ReloadPackageCompilationData reloadPackageCompilationData = null;
    protected transient ObjectHashSet statefulSessions;

    public AbstractRuleBase() {
    }

    public synchronized int nextWorkingMemoryCounter() {
        return this.workingMemoryCounter++;
    }

    public AbstractRuleBase(String id, RuleBaseConfiguration config, FactHandleFactory factHandleFactory) {
        this.id = id != null ? id : "default";
        this.config = config != null ? config : new RuleBaseConfiguration();
        this.config.makeImmutable();
        this.factHandleFactory = factHandleFactory;
        if (this.config.isSequential()) {
            this.agendaGroupRuleTotals = new HashMap();
        }
        this.packageClassLoader = new CompositePackageClassLoader(Thread.currentThread().getContextClassLoader());
        this.classLoader = new MapBackedClassLoader(Thread.currentThread().getContextClassLoader());
        this.packageClassLoader.addClassLoader(this.classLoader);
        this.pkgs = new HashMap();
        this.processes = new HashMap();
        this.globals = new HashMap();
        this.statefulSessions = new ObjectHashSet();
    }

    public void doWriteExternal(ObjectOutput stream, Object[] objects) throws IOException {
        stream.writeObject(this.pkgs);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(this.id);
        out.writeObject(this.agendaGroupRuleTotals);
        out.writeObject(this.factHandleFactory);
        out.writeObject(this.globals);
        out.writeObject(this.config);
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            out.writeObject(objects[i]);
        }
        stream.writeObject(bos.toByteArray());
    }

    public void doReadExternal(ObjectInput stream, Object[] objects) throws IOException, ClassNotFoundException {
        this.pkgs = (Map)stream.readObject();
        if (stream instanceof DroolsObjectInputStream) {
            DroolsObjectInputStream parentStream = (DroolsObjectInputStream)stream;
            parentStream.setRuleBase(this);
            this.packageClassLoader = new CompositePackageClassLoader(parentStream.getClassLoader());
            this.classLoader = new MapBackedClassLoader(parentStream.getClassLoader());
        } else {
            this.packageClassLoader = new CompositePackageClassLoader(Thread.currentThread().getContextClassLoader());
            this.classLoader = new MapBackedClassLoader(Thread.currentThread().getContextClassLoader());
        }
        this.packageClassLoader.addClassLoader(this.classLoader);
        Iterator it = this.pkgs.values().iterator();
        while (it.hasNext()) {
            this.packageClassLoader.addClassLoader(((Package)it.next()).getPackageCompilationData().getClassLoader());
        }
        byte[] bytes = (byte[])stream.readObject();
        DroolsObjectInputStream childStream = new DroolsObjectInputStream(new ByteArrayInputStream(bytes), this.packageClassLoader);
        childStream.setRuleBase(this);
        this.id = (String)childStream.readObject();
        this.agendaGroupRuleTotals = (Map)childStream.readObject();
        this.factHandleFactory = (FactHandleFactory)childStream.readObject();
        this.globals = (Map)childStream.readObject();
        this.config = (RuleBaseConfiguration)childStream.readObject();
        this.statefulSessions = new ObjectHashSet();
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            objects[i] = childStream.readObject();
        }
    }

    public String getId() {
        return this.id;
    }

    public StatefulSession newStatefulSession() {
        return this.newStatefulSession(true);
    }

    public abstract StatefulSession newStatefulSession(boolean var1);

    public synchronized void disposeStatefulSession(StatefulSession statefulSession) {
        this.statefulSessions.remove(statefulSession);
    }

    public FactHandleFactory getFactHandleFactory() {
        return this.factHandleFactory;
    }

    public FactHandleFactory newFactHandleFactory() {
        return this.factHandleFactory.newInstance();
    }

    public Process[] getProcesses() {
        return this.processes.values().toArray(new Process[this.processes.size()]);
    }

    public Package[] getPackages() {
        return this.pkgs.values().toArray(new Package[this.pkgs.size()]);
    }

    public Map getPackagesMap() {
        return this.pkgs;
    }

    public Map getGlobals() {
        return this.globals;
    }

    public Map getAgendaGroupRuleTotals() {
        return this.agendaGroupRuleTotals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addPackage(Package newPkg) throws PackageIntegrationException {
        newPkg.checkValidity();
        Map map = this.pkgs;
        synchronized (map) {
            Package pkg = (Package)this.pkgs.get(newPkg.getName());
            int lastAquiredLock = 0;
            InternalWorkingMemory[] wms = this.getWorkingMemories();
            try {
                for (lastAquiredLock = 0; lastAquiredLock < wms.length; ++lastAquiredLock) {
                    wms[lastAquiredLock].getLock().lock();
                }
                if (pkg != null) {
                    this.mergePackage(pkg, newPkg);
                } else {
                    this.pkgs.put(newPkg.getName(), newPkg);
                }
                Map newGlobals = newPkg.getGlobals();
                Iterator it = newGlobals.keySet().iterator();
                while (it.hasNext()) {
                    boolean y;
                    String identifier = (String)it.next();
                    Class type = (Class)newGlobals.get(identifier);
                    boolean f = this.globals.containsKey(identifier);
                    if (!f) continue;
                    boolean bl = y = !this.globals.get(identifier).equals(type);
                    if (!f || !y) continue;
                    throw new PackageIntegrationException(pkg);
                }
                this.globals.putAll(newGlobals);
                Rule[] rules = newPkg.getRules();
                for (int i = 0; i < rules.length; ++i) {
                    this.addRule(rules[i]);
                }
                if (newPkg.getRuleFlows() != Collections.EMPTY_MAP) {
                    Map flows = newPkg.getRuleFlows();
                    Iterator iter = flows.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry flow = iter.next();
                        this.processes.put(flow.getKey(), flow.getValue());
                    }
                }
                this.packageClassLoader.addClassLoader(newPkg.getPackageCompilationData().getClassLoader());
            }
            finally {
                --lastAquiredLock;
                while (lastAquiredLock > -1) {
                    wms[lastAquiredLock].fireAllRules();
                    wms[lastAquiredLock].getLock().unlock();
                    --lastAquiredLock;
                }
            }
        }
    }

    private void mergePackage(Package pkg, Package newPkg) throws PackageIntegrationException {
        Map globals = pkg.getGlobals();
        Set imports = pkg.getImports();
        PackageCompilationData compilationData = pkg.getPackageCompilationData();
        PackageCompilationData newCompilationData = newPkg.getPackageCompilationData();
        String[] files = newCompilationData.list();
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            compilationData.write(files[i], newCompilationData.read(files[i]));
        }
        imports.addAll(newPkg.getImports());
        compilationData.putAllInvokers(newCompilationData.getInvokers());
        if (compilationData.isDirty()) {
            if (this.reloadPackageCompilationData == null) {
                this.reloadPackageCompilationData = new ReloadPackageCompilationData();
            }
            this.reloadPackageCompilationData.addPackageCompilationData(compilationData);
        }
        Iterator it = newPkg.getGlobals().keySet().iterator();
        while (it.hasNext()) {
            String identifier = (String)it.next();
            Class type = (Class)globals.get(identifier);
            if (!globals.containsKey(identifier) || globals.get(identifier).equals(type)) continue;
            throw new PackageIntegrationException("Unable to merge new Package", newPkg);
        }
        globals.putAll(newPkg.getGlobals());
        Rule[] newRules = newPkg.getRules();
        for (int i = 0; i < newRules.length; ++i) {
            Rule newRule = newRules[i];
            if (pkg.getRule(newRule.getName()) != null) continue;
            pkg.addRule(newRule);
        }
        if (newPkg.getRuleFlows() != Collections.EMPTY_MAP) {
            Map flows = newPkg.getRuleFlows();
            Iterator iter = flows.values().iterator();
            while (iter.hasNext()) {
                Process flow = (Process)iter.next();
                pkg.addRuleFlow(flow);
            }
        }
    }

    protected synchronized void addRule(Rule rule) throws InvalidPatternException {
        if (!rule.isValid()) {
            throw new IllegalArgumentException("The rule called " + rule.getName() + " is not valid. Check for compile errors reported.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removePackage(String packageName) {
        Map map = this.pkgs;
        synchronized (map) {
            Package pkg = (Package)this.pkgs.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            int lastAquiredLock = 0;
            InternalWorkingMemory[] wms = this.getWorkingMemories();
            try {
                for (lastAquiredLock = 0; lastAquiredLock < wms.length; ++lastAquiredLock) {
                    wms[lastAquiredLock].getLock().lock();
                }
                Rule[] rules = pkg.getRules();
                for (int i = 0; i < rules.length; ++i) {
                    this.removeRule(rules[i]);
                }
                this.packageClassLoader.removeClassLoader(pkg.getPackageCompilationData().getClassLoader());
                pkg.clear();
                HashSet referencedGlobals = new HashSet();
                Iterator<Object> it = this.pkgs.values().iterator();
                while (it.hasNext()) {
                    Package pkgref = (Package)it.next();
                    if (pkgref == pkg) continue;
                    referencedGlobals.addAll(pkgref.getGlobals().keySet());
                }
                it = pkg.getGlobals().keySet().iterator();
                while (it.hasNext()) {
                    String globalName = (String)it.next();
                    if (referencedGlobals.contains(globalName)) continue;
                    this.globals.remove(globalName);
                }
                Map flows = pkg.getRuleFlows();
                Iterator iter = flows.keySet().iterator();
                while (iter.hasNext()) {
                    this.removeProcess((String)iter.next());
                }
                this.pkgs.remove(pkg.getName());
            }
            finally {
                --lastAquiredLock;
                while (lastAquiredLock > -1) {
                    wms[lastAquiredLock].fireAllRules();
                    wms[lastAquiredLock].getLock().unlock();
                    --lastAquiredLock;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRule(String packageName, String ruleName) {
        Map map = this.pkgs;
        synchronized (map) {
            Package pkg = (Package)this.pkgs.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            Rule rule = pkg.getRule(ruleName);
            if (rule == null) {
                throw new IllegalArgumentException("Rule name '" + ruleName + "' does not exist in the Package '" + packageName + "'.");
            }
            int lastAquiredLock = 0;
            InternalWorkingMemory[] wms = this.getWorkingMemories();
            PackageCompilationData compilationData = null;
            try {
                for (lastAquiredLock = 0; lastAquiredLock < wms.length; ++lastAquiredLock) {
                    wms[lastAquiredLock].getLock().lock();
                }
                this.removeRule(rule);
                compilationData = pkg.removeRule(rule);
                if (this.reloadPackageCompilationData == null) {
                    this.reloadPackageCompilationData = new ReloadPackageCompilationData();
                }
                this.reloadPackageCompilationData.addPackageCompilationData(compilationData);
            }
            finally {
                --lastAquiredLock;
                while (lastAquiredLock > -1) {
                    wms[lastAquiredLock].getLock().unlock();
                    --lastAquiredLock;
                }
            }
        }
    }

    protected abstract void removeRule(Rule var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFunction(String packageName, String functionName) {
        Map map = this.pkgs;
        synchronized (map) {
            Package pkg = (Package)this.pkgs.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            PackageCompilationData compilationData = pkg.removeFunction(functionName);
            if (compilationData == null) {
                throw new IllegalArgumentException("function name '" + packageName + "' does not exist in the Package '" + packageName + "'.");
            }
            if (this.reloadPackageCompilationData == null) {
                this.reloadPackageCompilationData = new ReloadPackageCompilationData();
            }
            this.reloadPackageCompilationData.addPackageCompilationData(compilationData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addProcess(Process process) {
        Map map = this.pkgs;
        synchronized (map) {
            this.processes.put(process.getId(), process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeProcess(String id) {
        Map map = this.pkgs;
        synchronized (map) {
            this.processes.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process getProcess(String id) {
        Process process = null;
        Map map = this.pkgs;
        synchronized (map) {
            process = (Process)this.processes.get(id);
        }
        return process;
    }

    protected synchronized void addStatefulSession(StatefulSession statefulSession) {
        this.statefulSessions.add(statefulSession);
    }

    public Package getPackage(String name) {
        return (Package)this.pkgs.get(name);
    }

    public StatefulSession[] getStatefulSessions() {
        return (StatefulSession[])this.statefulSessions.toArray(new StatefulSession[this.statefulSessions.size()]);
    }

    public InternalWorkingMemory[] getWorkingMemories() {
        return (InternalWorkingMemory[])this.statefulSessions.toArray(new InternalWorkingMemory[this.statefulSessions.size()]);
    }

    public RuleBaseConfiguration getConfiguration() {
        return this.config;
    }

    public StatefulSession newStatefulSession(InputStream stream) throws IOException, ClassNotFoundException {
        return this.newStatefulSession(stream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulSession newStatefulSession(InputStream stream, boolean keepReference) throws IOException, ClassNotFoundException {
        if (this.config.isSequential()) {
            throw new RuntimeException("Cannot have a stateful rule session, with sequential configuration set to true");
        }
        DroolsObjectInputStream streamWithLoader = new DroolsObjectInputStream(stream, this.packageClassLoader);
        AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)streamWithLoader.readObject();
        Map map = this.pkgs;
        synchronized (map) {
            workingMemory.setRuleBase(this);
            return (StatefulSession)((Object)workingMemory);
        }
    }

    public void addClass(String className, byte[] bytes) {
        this.classLoader.addClass(className, bytes);
    }

    public CompositePackageClassLoader getCompositePackageClassLoader() {
        return this.packageClassLoader;
    }

    public MapBackedClassLoader getMapBackedClassLoader() {
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQueuedActions() {
        Map map = this.pkgs;
        synchronized (map) {
            if (this.reloadPackageCompilationData != null) {
                this.reloadPackageCompilationData.execute(this);
            }
        }
    }

    public static interface RuleBaseAction
    extends Serializable {
        public void execute(InternalRuleBase var1);
    }

    public static class ReloadPackageCompilationData
    implements RuleBaseAction {
        private Set set;

        public void addPackageCompilationData(PackageCompilationData packageCompilationData) {
            if (this.set == null) {
                this.set = new HashSet();
            }
            this.set.add(packageCompilationData);
        }

        public void execute(InternalRuleBase ruleBase) {
            Iterator it = this.set.iterator();
            while (it.hasNext()) {
                PackageCompilationData packageCompilationData = (PackageCompilationData)it.next();
                packageCompilationData.reload();
            }
        }
    }
}

