/*
 * Decompiled with CFR 0.152.
 */
package org.drools.objenesis.strategy;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.drools.objenesis.ObjenesisException;
import org.drools.objenesis.instantiator.ObjectInstantiator;
import org.drools.objenesis.instantiator.basic.ObjectStreamClassInstantiator;
import org.drools.objenesis.instantiator.gcj.GCJSerializationInstantiator;
import org.drools.objenesis.instantiator.sun.Sun13SerializationInstantiator;
import org.drools.objenesis.strategy.BaseInstantiatorStrategy;

public class SerializingInstantiatorStrategy
extends BaseInstantiatorStrategy {
    public ObjectInstantiator newInstantiatorOf(Class type) {
        if (!Serializable.class.isAssignableFrom(type)) {
            throw new ObjenesisException(new NotSerializableException(type + " not serializable"));
        }
        if (JVM_NAME.startsWith("Java HotSpot")) {
            if (VM_VERSION.startsWith("1.3")) {
                return new Sun13SerializationInstantiator(type);
            }
        } else if (JVM_NAME.startsWith("GNU libgcj")) {
            return new GCJSerializationInstantiator(type);
        }
        return new ObjectStreamClassInstantiator(type);
    }
}

