/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSinkNode;
import org.drools.reteoo.TupleSource;
import org.drools.rule.EvalCondition;
import org.drools.spi.PropagationContext;
import org.drools.util.Iterator;
import org.drools.util.TupleHashTable;

public class EvalConditionNode
extends TupleSource
implements TupleSinkNode,
NodeMemory {
    private static final long serialVersionUID = 400L;
    private final EvalCondition condition;
    private final TupleSource tupleSource;
    private TupleSinkNode previousTupleSinkNode;
    private TupleSinkNode nextTupleSinkNode;

    public EvalConditionNode(int id, TupleSource tupleSource, EvalCondition eval) {
        super(id);
        this.condition = eval;
        this.tupleSource = tupleSource;
        this.hasMemory = true;
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            InternalWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public EvalCondition getCondition() {
        return this.condition;
    }

    public void assertTuple(ReteTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        boolean allowed = this.condition.isAllowed(tuple, workingMemory);
        if (allowed) {
            if (!workingMemory.isSequential()) {
                TupleHashTable memory = (TupleHashTable)workingMemory.getNodeMemory(this);
                memory.add(tuple);
            }
            this.sink.propagateAssertTuple(tuple, context, workingMemory);
        }
    }

    public void retractTuple(ReteTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        TupleHashTable memory = (TupleHashTable)workingMemory.getNodeMemory(this);
        ReteTuple memTuple = memory.remove(tuple);
        if (memTuple != null) {
            this.sink.propagateRetractTuple(memTuple, context, workingMemory);
        }
    }

    public String toString() {
        return "[EvalConditionNode: cond=" + this.condition + "]";
    }

    public int hashCode() {
        return this.tupleSource.hashCode() ^ this.condition.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != EvalConditionNode.class) {
            return false;
        }
        EvalConditionNode other = (EvalConditionNode)object;
        return this.tupleSource.equals(other.tupleSource) && this.condition.equals(other.condition);
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new TupleHashTable();
    }

    public void updateSink(TupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        TupleHashTable memory = (TupleHashTable)workingMemory.getNodeMemory(this);
        Iterator it = memory.iterator();
        ReteTuple tuple = (ReteTuple)it.next();
        while (tuple != null) {
            sink.assertTuple(tuple, context, workingMemory);
            tuple = (ReteTuple)it.next();
        }
    }

    public void remove(BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeTupleSink((TupleSink)((Object)node));
        }
        this.removeShare();
        if (!this.isInUse()) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                workingMemories[i].clearNodeMemory(this);
            }
        }
        this.tupleSource.remove(this, workingMemories);
    }

    public TupleSinkNode getNextTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextTupleSinkNode(TupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public TupleSinkNode getPreviousTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousTupleSinkNode(TupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }
}

